/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.transaction;

import oracle.toplink.exceptions.TransactionException;
import oracle.toplink.logging.SessionLogEntry;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.transaction.AbstractTransactionController;

public abstract class AbstractSynchronizationListener {
    protected AbstractTransactionController controller;
    protected Session session;
    protected UnitOfWork unitOfWork;
    protected Object transaction;

    public AbstractSynchronizationListener() {
    }

    protected AbstractSynchronizationListener(UnitOfWork unitOfWork, Session session, Object object, AbstractTransactionController abstractTransactionController) {
        this.session = session;
        this.unitOfWork = unitOfWork;
        this.transaction = object;
        this.controller = abstractTransactionController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeCompletion() {
        UnitOfWork unitOfWork = this.getUnitOfWork();
        try {
            Object object = this.getTransactionController().getTransactionStatus();
            this.getTransactionController().logTxStateTrace(unitOfWork, "TX_beforeCompletion", object);
            this.session.startOperationProfile("TXBeforeCompletion");
            if (!unitOfWork.isActive()) {
                throw TransactionException.inactiveUnitOfWork(unitOfWork);
            }
            if (!this.getTransactionController().canIssueSQLToDatabase_impl(object)) {
                return;
            }
            if (this.getSession().isInTransaction()) {
                this.getSession().getTransactionMutex().setActiveThread(Thread.currentThread());
            }
            unitOfWork.issueSQLbeforeCompletion();
            unitOfWork.setPendingMerge();
        }
        catch (RuntimeException runtimeException) {
            unitOfWork.log(new SessionLogEntry((Session)unitOfWork, 6, "transaction", runtimeException));
            this.handleException(runtimeException);
        }
        finally {
            this.session.endOperationProfile("TXBeforeCompletion");
        }
    }

    public void afterCompletion(Object object) {
        UnitOfWork unitOfWork = this.getUnitOfWork();
        try {
            this.getTransactionController().logTxStateTrace(unitOfWork, "TX_afterCompletion", object);
            this.session.startOperationProfile("TXAfterCompletion");
            if (!unitOfWork.isActive()) {
                throw TransactionException.inactiveUnitOfWork(unitOfWork);
            }
            if (this.getTransactionController().canMergeUnitOfWork_impl(object)) {
                unitOfWork.afterTransaction(true, true);
                if (unitOfWork.isMergePending()) {
                    unitOfWork.mergeClonesAfterCompletion();
                }
            } else {
                unitOfWork.afterTransaction(false, true);
            }
        }
        catch (RuntimeException runtimeException) {
            unitOfWork.log(new SessionLogEntry((Session)unitOfWork, 6, "transaction", runtimeException));
            throw runtimeException;
        }
        finally {
            this.session.endOperationProfile("TXAfterCompletion");
        }
        unitOfWork.release();
        this.getTransactionController().removeUnitOfWork(this.getTransaction());
        this.setUnitOfWork(null);
        this.setTransaction(null);
        if (this.getSession().isClientSession()) {
            this.getSession().release();
        }
        this.setSession(null);
    }

    public void handleException(RuntimeException runtimeException) {
        throw runtimeException;
    }

    protected AbstractTransactionController getTransactionController() {
        return this.controller;
    }

    protected void setTransactionController(AbstractTransactionController abstractTransactionController) {
        this.controller = abstractTransactionController;
    }

    protected Object getTransaction() {
        return this.transaction;
    }

    protected void setTransaction(Object object) {
        this.transaction = object;
    }

    protected Session getSession() {
        return this.session;
    }

    protected void setSession(Session session) {
        this.session = session;
    }

    protected UnitOfWork getUnitOfWork() {
        return this.unitOfWork;
    }

    protected void setUnitOfWork(UnitOfWork unitOfWork) {
        this.unitOfWork = unitOfWork;
    }
}

