/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.workbench.expressions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionOperator;
import oracle.toplink.internal.expressions.FunctionExpression;
import oracle.toplink.internal.expressions.LogicalExpression;
import oracle.toplink.tools.workbench.expressions.BasicExpressionRepresentation;
import oracle.toplink.tools.workbench.expressions.ExpressionRepresentation;

public class CompoundExpressionRepresentation
extends ExpressionRepresentation {
    public static final String AND = "AND";
    public static final String OR = "OR";
    public static final String NAND = "NAND";
    public static final String NOR = "NOR";
    private List expressions = new ArrayList();

    public CompoundExpressionRepresentation() {
    }

    public CompoundExpressionRepresentation(String string) {
        super(string);
    }

    private void addExpression(ExpressionRepresentation expressionRepresentation) {
        this.expressions.add(expressionRepresentation);
    }

    public int expressionsSize() {
        return this.expressions.size();
    }

    public ExpressionRepresentation getExpression(int n) {
        return (ExpressionRepresentation)this.expressions.get(n);
    }

    public Iterator expressions() {
        return this.expressions.iterator();
    }

    public String displayString() {
        return this.getOperatorType();
    }

    public boolean isCompoundExpression() {
        return true;
    }

    public Expression convertToRuntime(Expression expression) {
        Expression expression2 = null;
        int n = 0;
        boolean bl = false;
        if (this.getOperatorType() == AND) {
            n = 1;
        } else if (this.getOperatorType() == OR) {
            n = 2;
        } else if (this.getOperatorType() == NAND) {
            n = 1;
            bl = true;
        } else if (this.getOperatorType() == NOR) {
            n = 2;
            bl = true;
        }
        if (this.expressionsSize() > 0) {
            expression2 = ((ExpressionRepresentation)this.expressions.get(0)).convertToRuntime(expression);
            for (int i = 0; i < this.expressionsSize() - 1; ++i) {
                Expression expression3 = ((ExpressionRepresentation)this.expressions.get(i + 1)).convertToRuntime(expression);
                expression2 = n == 1 ? expression.and(expression2).and(expression3) : expression.or(expression2).or(expression3);
            }
        }
        if (bl) {
            return expression2.not();
        }
        return expression2;
    }

    public static ExpressionRepresentation convertFromRuntime(Expression expression) {
        CompoundExpressionRepresentation compoundExpressionRepresentation = new CompoundExpressionRepresentation();
        ExpressionOperator expressionOperator = expression.getOperator();
        boolean bl = false;
        if (expressionOperator == ExpressionOperator.getOperator(new Integer(3))) {
            expression = ((FunctionExpression)expression).getBaseExpression();
            bl = true;
            expressionOperator = expression.getOperator();
        }
        if (expressionOperator == ExpressionOperator.getOperator(new Integer(1))) {
            if (!bl) {
                compoundExpressionRepresentation.setOperatorType(AND);
            } else {
                compoundExpressionRepresentation.setOperatorType(NAND);
            }
        } else if (expressionOperator == ExpressionOperator.getOperator(new Integer(2))) {
            if (!bl) {
                compoundExpressionRepresentation.setOperatorType(OR);
            } else {
                compoundExpressionRepresentation.setOperatorType(NOR);
            }
        }
        if (expression.isFunctionExpression()) {
            compoundExpressionRepresentation.addExpression(BasicExpressionRepresentation.convertFromRuntime(expression));
        } else if (expression.isRelationExpression()) {
            compoundExpressionRepresentation.addExpression(BasicExpressionRepresentation.convertFromRuntime(expression));
            if (!bl) {
                compoundExpressionRepresentation.setOperatorType(AND);
            } else {
                compoundExpressionRepresentation.setOperatorType(NAND);
            }
        } else {
            Expression expression2 = ((LogicalExpression)expression).getFirstChild();
            if (expression2.isRelationExpression() || expression2.isFunctionExpression() && expression2.getOperator() != ExpressionOperator.getOperator(new Integer(3))) {
                compoundExpressionRepresentation.addExpression(BasicExpressionRepresentation.convertFromRuntime(expression2));
            } else {
                compoundExpressionRepresentation.addExpression(CompoundExpressionRepresentation.convertFromRuntime(expression2));
            }
            Expression expression3 = ((LogicalExpression)expression).getSecondChild();
            if (expression3.isRelationExpression() || expression3.isFunctionExpression() && expression3.getOperator() != ExpressionOperator.getOperator(new Integer(3))) {
                compoundExpressionRepresentation.addExpression(BasicExpressionRepresentation.convertFromRuntime(expression3));
            } else {
                compoundExpressionRepresentation.addExpression(CompoundExpressionRepresentation.convertFromRuntime(expression3));
            }
        }
        return compoundExpressionRepresentation;
    }

    public String convertToRuntimeString(String string) {
        String string2;
        String string3 = "";
        boolean bl = false;
        if (this.getOperatorType() == AND) {
            string2 = "and";
        } else if (this.getOperatorType() == OR) {
            string2 = "or";
        } else if (this.getOperatorType() == NAND) {
            string2 = "and";
            bl = true;
        } else {
            string2 = "or";
            bl = true;
        }
        if (this.expressionsSize() > 0) {
            int n = 0;
            while (((ExpressionRepresentation)this.expressions.get(n)).convertToRuntimeString(string) == "") {
                ++n;
            }
            string3 = ((ExpressionRepresentation)this.expressions.get(n)).convertToRuntimeString(string);
            for (int i = n; i < this.expressionsSize() - 1; ++i) {
                String string4 = ((ExpressionRepresentation)this.expressions.get(i + 1)).convertToRuntimeString(string);
                if (string4 == "") continue;
                string3 = string3 + "." + string2 + "(" + string4 + ")";
            }
        }
        if (bl) {
            return string3 + ".not()";
        }
        return string3;
    }
}

