/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.sessionconfiguration;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.naming.InitialContext;
import oracle.toplink.Version;
import oracle.toplink.eis.EISConnectionSpec;
import oracle.toplink.eis.EISLogin;
import oracle.toplink.exceptions.ExceptionHandler;
import oracle.toplink.exceptions.SessionLoaderException;
import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.databaseaccess.DatasourcePlatform;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.ConversionManager;
import oracle.toplink.internal.localization.ExceptionLocalization;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.jndi.JNDIConnector;
import oracle.toplink.logging.DefaultSessionLog;
import oracle.toplink.logging.SessionLog;
import oracle.toplink.platform.server.CustomServerPlatform;
import oracle.toplink.platform.server.NoServerPlatform;
import oracle.toplink.platform.xml.XMLParser;
import oracle.toplink.platform.xml.XMLPlatform;
import oracle.toplink.platform.xml.XMLPlatformException;
import oracle.toplink.platform.xml.XMLPlatformFactory;
import oracle.toplink.publicinterface.DatabaseSession;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.remote.AbstractClusteringService;
import oracle.toplink.remote.AbstractJNDIClusteringService;
import oracle.toplink.remote.CacheSynchronizationManager;
import oracle.toplink.remote.jms.JMSClusteringService;
import oracle.toplink.remotecommand.CommandManager;
import oracle.toplink.remotecommand.RemoteCommandManager;
import oracle.toplink.remotecommand.TransportManager;
import oracle.toplink.remotecommand.jms.JMSTopicTransportManager;
import oracle.toplink.remotecommand.rmi.RMITransportManager;
import oracle.toplink.sessions.DatabaseLogin;
import oracle.toplink.sessions.DatasourceLogin;
import oracle.toplink.sessions.Login;
import oracle.toplink.sessions.Project;
import oracle.toplink.sessions.SessionEventListener;
import oracle.toplink.sessions.SessionProfiler;
import oracle.toplink.threetier.ConnectionPool;
import oracle.toplink.threetier.ReadConnectionPool;
import oracle.toplink.threetier.ServerSession;
import oracle.toplink.tools.sessionconfiguration.NodeListElementEnumerator;
import oracle.toplink.tools.sessionconfiguration.SessionBrokerPlaceHolder;
import oracle.toplink.tools.sessionconfiguration.TopLinkEntityResolver;
import oracle.toplink.tools.sessionmanagement.SessionManager;
import oracle.toplink.tools.workbench.XMLProjectReader;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLLoader {
    protected String resourceName;
    protected ClassLoader classLoader;
    protected Vector exceptionStore = new Vector();
    protected boolean shouldLoginSession;
    protected SessionManager sessionManager;
    protected boolean shouldRefreshSession;
    protected Session currentlyBuildingSession;
    protected static final String DEFAULT_RESOURCE_NAME = "sessions.xml";
    protected static final String DEFAULT_RESOURCE_NAME_IN_META_INF = "META-INF/sessions.xml";
    protected boolean hasBeenRetreived;
    protected Vector messageStore;
    protected EntityResolver m_entityResolver;
    static /* synthetic */ Class class$org$w3c$dom$Node;
    static /* synthetic */ Class class$oracle$toplink$tools$sessionconfiguration$XMLLoader$ObjectHolder;
    static /* synthetic */ Class class$oracle$toplink$sessions$Session;
    static /* synthetic */ Class class$java$lang$Class;

    public XMLLoader() {
        this(DEFAULT_RESOURCE_NAME);
    }

    public XMLLoader(String string) {
        this.resourceName = string;
        this.shouldRefreshSession = false;
        this.shouldLoginSession = true;
        this.messageStore = new Vector();
        this.m_entityResolver = new TopLinkEntityResolver();
    }

    public Vector getExceptionStore() {
        return this.exceptionStore;
    }

    public Vector getMessageStore() {
        return this.messageStore;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String convertNodeToMethodName(Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("process_");
        stringBuffer.append(node.getNodeName().replace('-', '_'));
        stringBuffer.append("_Tag");
        return stringBuffer.toString();
    }

    public void load(SessionManager sessionManager, ClassLoader classLoader, boolean bl, boolean bl2) throws TopLinkException {
        PrivilegedAccessController.loadDeploymentXML(this, sessionManager, classLoader, bl, bl2);
    }

    public void loadInternal(SessionManager sessionManager, ClassLoader classLoader, boolean bl, boolean bl2) throws TopLinkException {
        this.sessionManager = sessionManager;
        this.shouldLoginSession = bl;
        this.shouldRefreshSession = bl2;
        if (this.classLoader != classLoader) {
            this.classLoader = classLoader;
            this.hasBeenRetreived = false;
        }
        if (this.hasBeenRetreived && !this.shouldRefreshSession) {
            return;
        }
        Document document = this.retreiveDOM(classLoader);
        if (document != null) {
            this.processRootTag(document, null, classLoader);
        }
        if (!this.getExceptionStore().isEmpty()) {
            throw SessionLoaderException.finalException(this.getExceptionStore());
        }
    }

    public Document retreiveDOM(ClassLoader classLoader) throws TopLinkException {
        InputStream inputStream = classLoader.getResourceAsStream(this.resourceName);
        if (inputStream == null) {
            if (this.resourceName.equals(DEFAULT_RESOURCE_NAME)) {
                inputStream = classLoader.getResourceAsStream(DEFAULT_RESOURCE_NAME_IN_META_INF);
            }
            if (inputStream == null) {
                throw ValidationException.noSessionsXMLFound(this.resourceName);
            }
        }
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
            XMLParser xMLParser = xMLPlatform.newXMLParser();
            if (SessionManager.shouldPerformDTDValidation()) {
                xMLParser.setValidationMode(2);
            }
            xMLParser.setNamespaceAware(false);
            xMLParser.setWhitespacePreserving(false);
            xMLParser.setErrorHandler(new XMLLoaderErrorHandler());
            xMLParser.setEntityResolver(this.m_entityResolver);
            return xMLParser.parse(inputStreamReader);
        }
        catch (XMLPlatformException xMLPlatformException) {
            if (xMLPlatformException.getInternalException() instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)xMLPlatformException.getInternalException();
                this.getExceptionStore().add(SessionLoaderException.failedToParseXML(sAXParseException.getMessage(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException));
                return null;
            }
            this.getExceptionStore().add(SessionLoaderException.failedToParseXML(xMLPlatformException.getMessage(), xMLPlatformException));
            return null;
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.nonParseException(exception));
            return null;
        }
    }

    public void processRootTag(Node node, ObjectHolder objectHolder, ClassLoader classLoader) {
        objectHolder = new ObjectHolder();
        node = node.getLastChild();
        NodeListElementEnumerator nodeListElementEnumerator = new NodeListElementEnumerator(node.getChildNodes());
        while (nodeListElementEnumerator.hasMoreNodes()) {
            Node node2 = nodeListElementEnumerator.nextNode();
            try {
                Class[] classArray = new Class[]{class$org$w3c$dom$Node == null ? XMLLoader.class$("org.w3c.dom.Node") : class$org$w3c$dom$Node, class$oracle$toplink$tools$sessionconfiguration$XMLLoader$ObjectHolder == null ? XMLLoader.class$("oracle.toplink.tools.sessionconfiguration.XMLLoader$ObjectHolder") : class$oracle$toplink$tools$sessionconfiguration$XMLLoader$ObjectHolder};
                Method method = this.getClass().getMethod(this.convertNodeToMethodName(node2), classArray);
                Object[] objectArray = new Object[]{node2, objectHolder};
                method.invoke((Object)this, objectArray);
            }
            catch (Exception exception) {
                this.getExceptionStore().add(SessionLoaderException.unkownTagAtNode(node2.getNodeName(), node.getNodeName(), exception));
                continue;
            }
            if (!this.getExceptionStore().isEmpty() || this.sessionManager.getSessions().containsKey(((Session)objectHolder.getObject()).getName())) continue;
            this.sessionManager.addSession((Session)objectHolder.getObject());
            ((Session)objectHolder.getObject()).getDatasourcePlatform().getConversionManager().setLoader(classLoader);
        }
    }

    public void process_cache_synchronization_manager_Tag(Node node, ObjectHolder objectHolder) {
        ((Session)objectHolder.getObject()).setCacheSynchronizationManager(new CacheSynchronizationManager());
        NodeListElementEnumerator nodeListElementEnumerator = new NodeListElementEnumerator(node.getChildNodes());
        while (nodeListElementEnumerator.hasMoreNodes()) {
            Node node2 = nodeListElementEnumerator.nextNode();
            try {
                Class[] classArray = new Class[]{class$org$w3c$dom$Node == null ? XMLLoader.class$("org.w3c.dom.Node") : class$org$w3c$dom$Node, class$oracle$toplink$tools$sessionconfiguration$XMLLoader$ObjectHolder == null ? XMLLoader.class$("oracle.toplink.tools.sessionconfiguration.XMLLoader$ObjectHolder") : class$oracle$toplink$tools$sessionconfiguration$XMLLoader$ObjectHolder};
                Method method = this.getClass().getMethod(this.convertNodeToMethodName(node2), classArray);
                Object[] objectArray = new Object[]{node2, objectHolder};
                method.invoke((Object)this, objectArray);
            }
            catch (Exception exception) {
                this.getExceptionStore().add(SessionLoaderException.unkownTagAtNode(node2.getNodeName(), node.getNodeName(), exception));
            }
        }
    }

    public void process_connection_pool_Tag(Node node, ObjectHolder objectHolder) {
        ObjectHolder objectHolder2 = new ObjectHolder();
        NodeListElementEnumerator nodeListElementEnumerator = new NodeListElementEnumerator(node.getChildNodes());
        this.process_is_read_connection_pool_Tag(nodeListElementEnumerator.nextNode(), objectHolder2);
        String string = nodeListElementEnumerator.nextNode().getFirstChild().getNodeValue();
        while (nodeListElementEnumerator.hasMoreNodes()) {
            Node node2 = nodeListElementEnumerator.nextNode();
            try {
                Class[] classArray = new Class[]{class$org$w3c$dom$Node == null ? XMLLoader.class$("org.w3c.dom.Node") : class$org$w3c$dom$Node, class$oracle$toplink$tools$sessionconfiguration$XMLLoader$ObjectHolder == null ? XMLLoader.class$("oracle.toplink.tools.sessionconfiguration.XMLLoader$ObjectHolder") : class$oracle$toplink$tools$sessionconfiguration$XMLLoader$ObjectHolder};
                Method method = this.getClass().getMethod(this.convertNodeToMethodName(node2), classArray);
                Object[] objectArray = new Object[]{node2, objectHolder2};
                method.invoke((Object)this, objectArray);
            }
            catch (Exception exception) {
                this.getExceptionStore().add(SessionLoaderException.unkownTagAtNode(node2.getNodeName(), node.getNodeName(), exception));
            }
        }
        ((ConnectionPool)objectHolder2.getObject()).setName(string);
        ((ServerSession)objectHolder.getObject()).addConnectionPool((ConnectionPool)objectHolder2.getObject());
    }

    public void process_is_read_connection_pool_Tag(Node node, ObjectHolder objectHolder) {
        ConnectionPool connectionPool = null;
        connectionPool = node.getFirstChild().getNodeValue().equals("true") ? new ReadConnectionPool() : new ConnectionPool();
        connectionPool.setLogin((DatabaseLogin)this.currentlyBuildingSession.getProject().getDatasourceLogin().clone());
        objectHolder.setObject(connectionPool);
    }

    public void process_max_connections_Tag(Node node, ObjectHolder objectHolder) {
        try {
            int n = Integer.parseInt(node.getFirstChild().getNodeValue());
            ((ConnectionPool)objectHolder.getObject()).setMaxNumberOfConnections(n);
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_min_connections_Tag(Node node, ObjectHolder objectHolder) {
        try {
            int n = Integer.parseInt(node.getFirstChild().getNodeValue());
            ((ConnectionPool)objectHolder.getObject()).setMinNumberOfConnections(n);
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_login_Tag(Node node, ObjectHolder objectHolder) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ObjectHolder objectHolder2 = new ObjectHolder();
        if (objectHolder.getObject() instanceof Session) {
            objectHolder2.setObject(((Session)objectHolder.getObject()).getProject().getDatasourceLogin());
        } else {
            objectHolder2.setObject(((ConnectionPool)objectHolder.getObject()).getLogin());
        }
        NodeListElementEnumerator nodeListElementEnumerator = new NodeListElementEnumerator(node.getChildNodes());
        while (nodeListElementEnumerator.hasMoreNodes()) {
            object4 = nodeListElementEnumerator.nextNode();
            try {
                object3 = new Class[]{class$org$w3c$dom$Node == null ? XMLLoader.class$("org.w3c.dom.Node") : class$org$w3c$dom$Node, class$oracle$toplink$tools$sessionconfiguration$XMLLoader$ObjectHolder == null ? XMLLoader.class$("oracle.toplink.tools.sessionconfiguration.XMLLoader$ObjectHolder") : class$oracle$toplink$tools$sessionconfiguration$XMLLoader$ObjectHolder};
                object2 = this.getClass().getMethod(this.convertNodeToMethodName((Node)object4), (Class<?>)object3);
                object = new Object[]{object4, objectHolder2};
                ((Method)object2).invoke((Object)this, (Object[])object);
            }
            catch (Exception exception) {
                this.getExceptionStore().add(SessionLoaderException.unkownTagAtNode(object4.getNodeName(), node.getNodeName(), exception));
            }
        }
        object4 = (Login)objectHolder2.getObject();
        if (objectHolder.getObject() instanceof Session) {
            ((Session)objectHolder.getObject()).getProject().setLogin((Login)object4);
            if (objectHolder.getObject() instanceof ServerSession) {
                object3 = (ServerSession)objectHolder.getObject();
                object2 = object4;
                if (object4 instanceof DatabaseLogin && ((ServerSession)object3).getDefaultConnectionPool().getLogin() != ((ServerSession)object3).getReadConnectionPool().getLogin() && ((ServerSession)object3).getReadConnectionPool().getLogin() instanceof DatabaseLogin) {
                    object = (DatabaseLogin)((ServerSession)object3).getReadConnectionPool().getLogin();
                    DatabaseLogin databaseLogin = (DatabaseLogin)object4.clone();
                    databaseLogin.setConnector(((DatasourceLogin)object).getConnector());
                    databaseLogin.setUsesExternalTransactionController(((DatasourceLogin)object).shouldUseExternalTransactionController());
                    object2 = databaseLogin;
                }
                ((ServerSession)object3).getReadConnectionPool().setLogin((Login)object2);
                ((ServerSession)object3).getDefaultConnectionPool().setLogin((Login)object4);
            }
        } else {
            ((ConnectionPool)objectHolder.getObject()).setLogin((Login)object4);
        }
    }

    public void process_license_path_Tag(Node node, ObjectHolder objectHolder) {
    }

    public void process_datasource_Tag(Node node, ObjectHolder objectHolder) {
        try {
            String string = node.getFirstChild().getNodeValue();
            ((DatabaseLogin)objectHolder.getObject()).setConnector(new JNDIConnector(new InitialContext(), string));
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_non_jts_datasource_Tag(Node node, ObjectHolder objectHolder) {
        try {
            String string = node.getFirstChild().getNodeValue();
            JNDIConnector jNDIConnector = new JNDIConnector(new InitialContext(), string);
            if (this.currentlyBuildingSession instanceof ServerSession) {
                DatabaseLogin databaseLogin = (DatabaseLogin)((ServerSession)this.currentlyBuildingSession).getReadConnectionPool().getLogin();
                databaseLogin = (DatabaseLogin)databaseLogin.clone();
                databaseLogin.setConnector(jNDIConnector);
                databaseLogin.setUsesExternalTransactionController(false);
                ((ServerSession)this.currentlyBuildingSession).getReadConnectionPool().setLogin(databaseLogin);
            }
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_session_broker_Tag(Node node, ObjectHolder objectHolder) {
        NodeListElementEnumerator nodeListElementEnumerator = new NodeListElementEnumerator(node.getChildNodes());
        SessionBrokerPlaceHolder sessionBrokerPlaceHolder = new SessionBrokerPlaceHolder();
        String string = nodeListElementEnumerator.nextNode().getFirstChild().getNodeValue();
        sessionBrokerPlaceHolder.setName(string);
        objectHolder.setObject(sessionBrokerPlaceHolder);
        while (nodeListElementEnumerator.hasMoreNodes()) {
            Node node2 = nodeListElementEnumerator.nextNode();
            try {
                Class[] classArray = new Class[]{class$org$w3c$dom$Node == null ? XMLLoader.class$("org.w3c.dom.Node") : class$org$w3c$dom$Node, class$oracle$toplink$tools$sessionconfiguration$XMLLoader$ObjectHolder == null ? XMLLoader.class$("oracle.toplink.tools.sessionconfiguration.XMLLoader$ObjectHolder") : class$oracle$toplink$tools$sessionconfiguration$XMLLoader$ObjectHolder};
                Method method = this.getClass().getMethod(this.convertNodeToMethodName(node2), classArray);
                Object[] objectArray = new Object[]{node2, objectHolder};
                method.invoke((Object)this, objectArray);
            }
            catch (Exception exception) {
                this.getExceptionStore().add(SessionLoaderException.unkownTagAtNode(node2.getNodeName(), node.getNodeName(), exception));
            }
        }
    }

    public void process_session_Tag(Node node, ObjectHolder objectHolder) {
        Object object;
        Object object2;
        Object object3;
        NodeListElementEnumerator nodeListElementEnumerator = new NodeListElementEnumerator(node.getChildNodes());
        String string = nodeListElementEnumerator.nextNode().getFirstChild().getNodeValue();
        Node node2 = nodeListElementEnumerator.nextNode();
        ObjectHolder objectHolder2 = new ObjectHolder();
        try {
            object3 = new Class[]{class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = XMLLoader.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node, class$oracle$toplink$tools$sessionconfiguration$XMLLoader$ObjectHolder == null ? (class$oracle$toplink$tools$sessionconfiguration$XMLLoader$ObjectHolder = XMLLoader.class$("oracle.toplink.tools.sessionconfiguration.XMLLoader$ObjectHolder")) : class$oracle$toplink$tools$sessionconfiguration$XMLLoader$ObjectHolder};
            object2 = this.getClass().getMethod(this.convertNodeToMethodName(node2), (Class<?>)object3);
            object = new Object[]{node2, objectHolder2};
            object2.invoke((Object)this, (Object[])object);
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.unkownTagAtNode(node2.getNodeName(), node.getNodeName(), exception));
        }
        if (objectHolder2.getObject() == null) {
            objectHolder2.setObject(new Project());
        }
        this.process_session_type_Tag(nodeListElementEnumerator.nextNode(), objectHolder2);
        objectHolder.setObject(objectHolder2.getObject());
        this.currentlyBuildingSession = (Session)objectHolder2.getObject();
        this.currentlyBuildingSession.setName(string);
        while (nodeListElementEnumerator.hasMoreNodes()) {
            object3 = nodeListElementEnumerator.nextNode();
            try {
                object2 = new Class[]{class$org$w3c$dom$Node == null ? XMLLoader.class$("org.w3c.dom.Node") : class$org$w3c$dom$Node, class$oracle$toplink$tools$sessionconfiguration$XMLLoader$ObjectHolder == null ? XMLLoader.class$("oracle.toplink.tools.sessionconfiguration.XMLLoader$ObjectHolder") : class$oracle$toplink$tools$sessionconfiguration$XMLLoader$ObjectHolder};
                object = this.getClass().getMethod(this.convertNodeToMethodName((Node)object3), (Class<?>)object2);
                Object[] objectArray = new Object[]{object3, objectHolder};
                ((Method)object).invoke((Object)this, objectArray);
            }
            catch (Exception exception) {
                this.getExceptionStore().add(SessionLoaderException.unkownTagAtNode(object3.getNodeName(), node.getNodeName(), exception));
            }
        }
        if (((Session)objectHolder.getObject()).shouldLog(6, null)) {
            object3 = this.getMessageStore().elements();
            while (object3.hasMoreElements()) {
                object2 = object3.nextElement();
                if (object2 instanceof Throwable) {
                    object = (Throwable)object3.nextElement();
                    ((Session)objectHolder.getObject()).logThrowable(6, null, (Throwable)object);
                    continue;
                }
                object = (String)object3.nextElement();
                ((Session)objectHolder.getObject()).warning((String)object, null);
            }
        }
    }

    public void process_uses_byte_array_binding_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Boolean bl = Boolean.valueOf(node.getFirstChild().getNodeValue());
            ((DatabaseLogin)objectHolder.getObject()).setUsesByteArrayBinding(bl);
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_uses_string_binding_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Boolean bl = Boolean.valueOf(node.getFirstChild().getNodeValue());
            ((DatabaseLogin)objectHolder.getObject()).setUsesStringBinding(bl);
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_uses_streams_for_binding_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Boolean bl = Boolean.valueOf(node.getFirstChild().getNodeValue());
            ((DatabaseLogin)objectHolder.getObject()).setUsesStreamsForBinding(bl);
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_should_force_field_names_to_uppercase_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Boolean bl = Boolean.valueOf(node.getFirstChild().getNodeValue());
            ((DatabaseLogin)objectHolder.getObject()).setShouldForceFieldNamesToUpperCase(bl);
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_should_optimize_data_conversion_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Boolean bl = Boolean.valueOf(node.getFirstChild().getNodeValue());
            ((DatabaseLogin)objectHolder.getObject()).setShouldOptimizeDataConversion(bl);
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_uses_native_sql_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Boolean bl = Boolean.valueOf(node.getFirstChild().getNodeValue());
            ((DatabaseLogin)objectHolder.getObject()).setUsesNativeSQL(bl);
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_should_trim_strings_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Boolean bl = Boolean.valueOf(node.getFirstChild().getNodeValue());
            ((DatabaseLogin)objectHolder.getObject()).setShouldTrimStrings(bl);
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_uses_batch_writing_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Boolean bl = Boolean.valueOf(node.getFirstChild().getNodeValue());
            ((DatabaseLogin)objectHolder.getObject()).setUsesBatchWriting(bl);
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_uses_jdbc20_batch_writing_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Boolean bl = Boolean.valueOf(node.getFirstChild().getNodeValue());
            ((DatabaseLogin)objectHolder.getObject()).setUsesJDBCBatchWriting(bl);
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_uses_external_transaction_controller_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Boolean bl = Boolean.valueOf(node.getFirstChild().getNodeValue());
            ((DatasourceLogin)objectHolder.getObject()).setUsesExternalTransactionController(bl);
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_uses_external_connection_pool_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Boolean bl = Boolean.valueOf(node.getFirstChild().getNodeValue());
            ((DatasourceLogin)objectHolder.getObject()).setUsesExternalConnectionPooling(bl);
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_should_cache_all_statements_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Boolean bl = Boolean.valueOf(node.getFirstChild().getNodeValue());
            ((DatabaseLogin)objectHolder.getObject()).setShouldCacheAllStatements(bl);
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_should_bind_all_parameters_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Boolean bl = Boolean.valueOf(node.getFirstChild().getNodeValue());
            ((DatabaseLogin)objectHolder.getObject()).setShouldBindAllParameters(bl);
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_connection_spec_class_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Class<?> clazz = this.classLoader.loadClass(node.getFirstChild().getNodeValue());
            EISConnectionSpec eISConnectionSpec = (EISConnectionSpec)clazz.newInstance();
            ((EISLogin)objectHolder.getObject()).setConnectionSpec(eISConnectionSpec);
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_connection_factory_url_Tag(Node node, ObjectHolder objectHolder) {
        try {
            ((EISLogin)objectHolder.getObject()).setConnectionFactoryURL(node.getFirstChild().getNodeValue());
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_uses_native_sequencing_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Boolean bl = Boolean.valueOf(node.getFirstChild().getNodeValue());
            ((DatabaseLogin)objectHolder.getObject()).setUsesNativeSequencing(bl);
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_enable_logging_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Boolean bl = Boolean.valueOf(node.getFirstChild().getNodeValue());
            ((Session)objectHolder.getObject()).setShouldLogMessages(bl);
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_driver_class_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Class<?> clazz = this.classLoader.loadClass(node.getFirstChild().getNodeValue());
            ((DatabaseLogin)objectHolder.getObject()).setDriverClass(clazz);
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_event_listener_class_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Class<?> clazz = this.classLoader.loadClass(node.getFirstChild().getNodeValue());
            ((Session)objectHolder.getObject()).getEventManager().addListener((SessionEventListener)clazz.newInstance());
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_session_type_Tag(Node node, ObjectHolder objectHolder) {
        NodeListElementEnumerator nodeListElementEnumerator = new NodeListElementEnumerator(node.getChildNodes());
        String string = nodeListElementEnumerator.nextNode().getNodeName();
        Project project = (Project)objectHolder.getObject();
        if (project.getDatasourceLogin() == null) {
            project.setLogin(new DatabaseLogin());
        }
        if (string.equals("database-session")) {
            objectHolder.setObject(project.createDatabaseSession());
        } else {
            objectHolder.setObject(project.createServerSession());
        }
        DatabaseSession databaseSession = (DatabaseSession)objectHolder.getObject();
        databaseSession.setServerPlatform(new NoServerPlatform(databaseSession));
    }

    public void process_user_name_Tag(Node node, ObjectHolder objectHolder) {
        if (objectHolder.getObject() instanceof TransportManager) {
            if (node.getFirstChild() != null) {
                ((TransportManager)objectHolder.getObject()).setUserName(node.getFirstChild().getNodeValue());
            } else {
                ((TransportManager)objectHolder.getObject()).setUserName("");
            }
            return;
        }
        if (node.getFirstChild() != null) {
            ((DatasourceLogin)objectHolder.getObject()).setUserName(node.getFirstChild().getNodeValue());
        } else {
            ((DatasourceLogin)objectHolder.getObject()).setUserName("");
        }
    }

    public void process_password_Tag(Node node, ObjectHolder objectHolder) {
        if (objectHolder.getObject() instanceof TransportManager) {
            if (node.getFirstChild() != null) {
                ((TransportManager)objectHolder.getObject()).setPassword(node.getFirstChild().getNodeValue());
            }
            return;
        }
        if (node.getFirstChild() == null) {
            ((DatasourceLogin)objectHolder.getObject()).setPassword("");
        } else {
            ((DatasourceLogin)objectHolder.getObject()).setPassword(node.getFirstChild().getNodeValue());
        }
    }

    public void process_encrypted_password_Tag(Node node, ObjectHolder objectHolder) {
        if (objectHolder.getObject() instanceof TransportManager && node.getFirstChild() != null) {
            ((TransportManager)objectHolder.getObject()).setEncryptedPassword(node.getFirstChild().getNodeValue());
            return;
        }
        if (node.getFirstChild() == null) {
            ((DatasourceLogin)objectHolder.getObject()).setEncryptedPassword("");
        } else {
            ((DatasourceLogin)objectHolder.getObject()).setEncryptedPassword(node.getFirstChild().getNodeValue());
        }
    }

    public void process_encryption_class_name_Tag(Node node, ObjectHolder objectHolder) {
        if (objectHolder.getObject() instanceof TransportManager && node.getFirstChild() != null) {
            ((TransportManager)objectHolder.getObject()).setEncryptionClassName(node.getFirstChild().getNodeValue());
            return;
        }
        if (node.getFirstChild() != null) {
            ((DatasourceLogin)objectHolder.getObject()).setEncryptionClassName(node.getFirstChild().getNodeValue());
        }
    }

    public void process_sequence_counter_field_Tag(Node node, ObjectHolder objectHolder) {
        ((DatabaseLogin)objectHolder.getObject()).setSequenceCounterFieldName(node.getFirstChild().getNodeValue());
    }

    public void process_sequence_name_field_Tag(Node node, ObjectHolder objectHolder) {
        ((DatabaseLogin)objectHolder.getObject()).setSequenceNameFieldName(node.getFirstChild().getNodeValue());
    }

    public void process_sequence_table_Tag(Node node, ObjectHolder objectHolder) {
        ((DatabaseLogin)objectHolder.getObject()).setSequenceTableName(node.getFirstChild().getNodeValue());
    }

    public void process_connection_url_Tag(Node node, ObjectHolder objectHolder) {
        ((DatabaseLogin)objectHolder.getObject()).setConnectionString(node.getFirstChild().getNodeValue());
    }

    public void process_non_jts_connection_url_Tag(Node node, ObjectHolder objectHolder) {
        String string = node.getFirstChild().getNodeValue();
        if (this.currentlyBuildingSession instanceof ServerSession) {
            DatabaseLogin databaseLogin = (DatabaseLogin)((ServerSession)this.currentlyBuildingSession).getReadConnectionPool().getLogin();
            databaseLogin = (DatabaseLogin)databaseLogin.clone();
            databaseLogin.setConnectionString(string);
            ((ServerSession)this.currentlyBuildingSession).getReadConnectionPool().setLogin(databaseLogin);
        }
    }

    public void process_uses_sequence_connection_pool_Tag(Node node, ObjectHolder objectHolder) {
        try {
            boolean bl = Boolean.valueOf(node.getFirstChild().getNodeValue());
            if (bl && this.currentlyBuildingSession instanceof ServerSession) {
                ((ServerSession)this.currentlyBuildingSession).getSequencingControl().setShouldUseSeparateConnection(true);
            }
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_session_name_Tag(Node node, ObjectHolder objectHolder) {
        ((SessionBrokerPlaceHolder)objectHolder.getObject()).addSessionName(node.getFirstChild().getNodeValue());
    }

    public void process_is_asynchronous_Tag(Node node, ObjectHolder objectHolder) {
        ((Session)objectHolder.getObject()).getCacheSynchronizationManager().isAsynchronous();
    }

    public void process_multicast_group_address_Tag(Node node, ObjectHolder objectHolder) {
        try {
            String string = node.getFirstChild().getNodeValue();
            if (objectHolder.getObject() instanceof Session) {
                ((Session)objectHolder.getObject()).getCacheSynchronizationManager().getClusteringService().setMulticastGroupAddress(string);
            }
            if (objectHolder.getObject() instanceof TransportManager) {
                RemoteCommandManager remoteCommandManager = ((TransportManager)objectHolder.getObject()).getRemoteCommandManager();
                remoteCommandManager.getDiscoveryManager().setMulticastGroupAddress(string);
            }
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_should_remove_connection_on_error_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Boolean bl = Boolean.valueOf(node.getFirstChild().getNodeValue());
            ((Session)objectHolder.getObject()).getCacheSynchronizationManager().setShouldRemoveConnectionOnError(bl);
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_jms_topic_Tag(Node node, ObjectHolder objectHolder) {
        ObjectHolder objectHolder2 = new ObjectHolder();
        TransportManager transportManager = ((CommandManager)objectHolder.getObject()).getTransportManager();
        try {
            boolean bl = transportManager.shouldRemoveConnectionOnError();
            transportManager = new JMSTopicTransportManager(transportManager.getRemoteCommandManager());
            transportManager.setShouldRemoveConnectionOnError(bl);
            objectHolder2.setObject(transportManager);
            this.processChildrenNodes(node, objectHolder2);
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_jms_topic_connection_factory_name_Tag(Node node, ObjectHolder objectHolder) {
        try {
            ((JMSClusteringService)((Session)objectHolder.getObject()).getCacheSynchronizationManager().getClusteringService()).setTopicConnectionFactoryName(node.getFirstChild().getNodeValue());
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_jms_topic_name_Tag(Node node, ObjectHolder objectHolder) {
        try {
            ((JMSClusteringService)((Session)objectHolder.getObject()).getCacheSynchronizationManager().getClusteringService()).setTopicName(node.getFirstChild().getNodeValue());
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_jndi_user_name_Tag(Node node, ObjectHolder objectHolder) {
        try {
            ((AbstractJNDIClusteringService)((Session)objectHolder.getObject()).getCacheSynchronizationManager().getClusteringService()).setUserName(node.getFirstChild().getNodeValue());
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_jndi_password_Tag(Node node, ObjectHolder objectHolder) {
        try {
            ((AbstractJNDIClusteringService)((Session)objectHolder.getObject()).getCacheSynchronizationManager().getClusteringService()).setPassword(node.getFirstChild().getNodeValue());
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_naming_service_initial_context_factory_name_Tag(Node node, ObjectHolder objectHolder) {
        try {
            ((AbstractJNDIClusteringService)((Session)objectHolder.getObject()).getCacheSynchronizationManager().getClusteringService()).setInitialContextFactoryName(node.getFirstChild().getNodeValue());
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_naming_service_url_Tag(Node node, ObjectHolder objectHolder) {
        try {
            ((Session)objectHolder.getObject()).getCacheSynchronizationManager().getClusteringService().setLocalHostURL(node.getFirstChild().getNodeValue());
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_sequence_preallocation_size_Tag(Node node, ObjectHolder objectHolder) {
        try {
            int n = Integer.parseInt(node.getFirstChild().getNodeValue());
            ((DatasourceLogin)objectHolder.getObject()).setSequencePreallocationSize(n);
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_multicast_port_Tag(Node node, ObjectHolder objectHolder) {
        try {
            int n = Integer.parseInt(node.getFirstChild().getNodeValue());
            if (objectHolder.getObject() instanceof Session) {
                ((Session)objectHolder.getObject()).getCacheSynchronizationManager().getClusteringService().setMulticastPort(n);
            }
            if (objectHolder.getObject() instanceof TransportManager) {
                RemoteCommandManager remoteCommandManager = ((TransportManager)objectHolder.getObject()).getRemoteCommandManager();
                remoteCommandManager.getDiscoveryManager().setMulticastPort(n);
            }
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_packet_time_to_live_Tag(Node node, ObjectHolder objectHolder) {
        try {
            int n = Integer.parseInt(node.getFirstChild().getNodeValue());
            if (objectHolder.getObject() instanceof Session) {
                ((Session)objectHolder.getObject()).getCacheSynchronizationManager().getClusteringService().setTimeToLive(n);
            }
            if (objectHolder.getObject() instanceof TransportManager) {
                RemoteCommandManager remoteCommandManager = ((TransportManager)objectHolder.getObject()).getRemoteCommandManager();
                remoteCommandManager.getDiscoveryManager().setPacketTimeToLive(n);
            }
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_clustering_service_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Class<?> clazz = this.classLoader.loadClass(node.getFirstChild().getNodeValue());
            Class[] classArray = new Class[]{class$oracle$toplink$sessions$Session == null ? (class$oracle$toplink$sessions$Session = XMLLoader.class$("oracle.toplink.sessions.Session")) : class$oracle$toplink$sessions$Session};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this.currentlyBuildingSession};
            ((Session)objectHolder.getObject()).getCacheSynchronizationManager().setClusteringService((AbstractClusteringService)constructor.newInstance(objectArray));
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_platform_class_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Class<?> clazz = this.classLoader.loadClass(node.getFirstChild().getNodeValue());
            ((DatasourceLogin)objectHolder.getObject()).usePlatform((DatasourcePlatform)clazz.newInstance());
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_type_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Class<?> clazz = this.classLoader.loadClass(node.getFirstChild().getNodeValue());
            Login login = (Login)clazz.newInstance();
            objectHolder.setObject(login);
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_project_class_Tag(Node node, ObjectHolder objectHolder) {
        try {
            String string = node.getFirstChild().getNodeValue();
            Class<?> clazz = this.classLoader.loadClass(string);
            objectHolder.setObject(clazz.newInstance());
        }
        catch (Throwable throwable) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadProjectClass(node.getFirstChild().getNodeValue(), throwable));
        }
    }

    public void process_project_xml_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Project project = null;
            try {
                project = XMLProjectReader.read(node.getFirstChild().getNodeValue(), this.classLoader);
            }
            catch (ValidationException validationException) {
                if (validationException.getErrorCode() == 7099) {
                    project = XMLProjectReader.read(node.getFirstChild().getNodeValue());
                }
                this.getExceptionStore().add(SessionLoaderException.failedToLoadProjectXml(node.getFirstChild().getNodeValue(), validationException));
                return;
            }
            if (project != null) {
                objectHolder.setObject(project);
            } else {
                this.getExceptionStore().add(SessionLoaderException.couldNotFindProjectXml(node.getFirstChild().getNodeValue()));
            }
        }
        catch (Throwable throwable) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadProjectXml(node.getFirstChild().getNodeValue(), throwable));
        }
    }

    public void process_external_transaction_controller_class_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Class<?> clazz = this.classLoader.loadClass(node.getFirstChild().getNodeValue());
            if (clazz != null) {
                DatabaseSession databaseSession = (DatabaseSession)objectHolder.getObject();
                CustomServerPlatform customServerPlatform = new CustomServerPlatform(databaseSession);
                databaseSession.setServerPlatform(customServerPlatform);
                customServerPlatform.setExternalTransactionControllerClass(clazz);
            }
        }
        catch (Throwable throwable) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), throwable));
        }
    }

    public void process_exception_handler_class_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Class<?> clazz = this.classLoader.loadClass(node.getFirstChild().getNodeValue());
            ((Session)objectHolder.getObject()).setExceptionHandler((ExceptionHandler)clazz.newInstance());
        }
        catch (Throwable throwable) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), throwable));
        }
    }

    public void process_profiler_class_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Class<?> clazz = this.classLoader.loadClass(node.getFirstChild().getNodeValue());
            ((Session)objectHolder.getObject()).setProfiler((SessionProfiler)clazz.newInstance());
        }
        catch (Throwable throwable) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), throwable));
        }
    }

    public void process_logging_options_Tag(Node node, ObjectHolder objectHolder) {
        this.processChildrenNodes(node, objectHolder);
    }

    public void process_log_type_Tag(Node node, ObjectHolder objectHolder) {
        try {
            NodeListElementEnumerator nodeListElementEnumerator = new NodeListElementEnumerator(node.getChildNodes());
            Node node2 = nodeListElementEnumerator.nextNode();
            String string = node2.getNodeName();
            if (string.equals("toplink")) {
                ((Session)objectHolder.getObject()).setSessionLog(new DefaultSessionLog());
                this.process_toplink_log_Tag(node2, objectHolder);
            } else if (string.equals("java")) {
                SessionLog sessionLog = null;
                if (!Version.isJDK13()) {
                    try {
                        sessionLog = (SessionLog)((Class)ConversionManager.getDefaultManager().convertObject("oracle.toplink.logging.JavaLog", class$java$lang$Class == null ? (class$java$lang$Class = XMLLoader.class$("java.lang.Class")) : class$java$lang$Class)).newInstance();
                        sessionLog.setSession((Session)objectHolder.getObject());
                    }
                    catch (Exception exception) {
                        this.getExceptionStore().add(exception);
                    }
                } else {
                    this.getExceptionStore().add(ValidationException.featureIsNotAvailableInRunningJDKVersion("Java Log"));
                }
                ((Session)objectHolder.getObject()).setSessionLog(sessionLog);
            } else {
                this.getExceptionStore().add(SessionLoaderException.unexpectedValueOfTag(string, node.getNodeName()));
            }
        }
        catch (Throwable throwable) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeName(), throwable));
        }
    }

    public void process_toplink_log_Tag(Node node, ObjectHolder objectHolder) {
        this.processChildrenNodes(node, objectHolder);
    }

    public void process_log_level_Tag(Node node, ObjectHolder objectHolder) {
        try {
            NodeListElementEnumerator nodeListElementEnumerator = new NodeListElementEnumerator(node.getChildNodes());
            String string = nodeListElementEnumerator.nextNode().getNodeName();
            if (string.equals("off")) {
                ((Session)objectHolder.getObject()).getSessionLog().setLevel(8);
            } else if (string.equals("severe")) {
                ((Session)objectHolder.getObject()).getSessionLog().setLevel(7);
            } else if (string.equals("warning")) {
                ((Session)objectHolder.getObject()).getSessionLog().setLevel(6);
            } else if (string.equals("info")) {
                ((Session)objectHolder.getObject()).getSessionLog().setLevel(5);
            } else if (string.equals("config")) {
                ((Session)objectHolder.getObject()).getSessionLog().setLevel(4);
            } else if (string.equals("fine")) {
                ((Session)objectHolder.getObject()).getSessionLog().setLevel(3);
            } else if (string.equals("finer")) {
                ((Session)objectHolder.getObject()).getSessionLog().setLevel(2);
            } else if (string.equals("finest")) {
                ((Session)objectHolder.getObject()).getSessionLog().setLevel(1);
            } else if (string.equals("all")) {
                ((Session)objectHolder.getObject()).getSessionLog().setLevel(0);
            } else {
                this.getExceptionStore().add(SessionLoaderException.unexpectedValueOfTag(string, node.getNodeName()));
            }
        }
        catch (Throwable throwable) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeName(), throwable));
        }
    }

    public void process_file_name_Tag(Node node, ObjectHolder objectHolder) {
        try {
            String string = String.valueOf(node.getFirstChild().getNodeValue());
            ((DefaultSessionLog)((Session)objectHolder.getObject()).getSessionLog()).setWriter(string);
        }
        catch (Throwable throwable) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), throwable));
        }
    }

    public void process_log_debug_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Boolean bl = Boolean.valueOf(node.getFirstChild().getNodeValue());
            ((Session)objectHolder.getObject()).getSessionLog().setShouldLogDebug(bl);
        }
        catch (Throwable throwable) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), throwable));
        }
    }

    public void process_log_exceptions_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Boolean bl = Boolean.valueOf(node.getFirstChild().getNodeValue());
            ((Session)objectHolder.getObject()).getSessionLog().setShouldLogExceptions(bl);
        }
        catch (Throwable throwable) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), throwable));
        }
    }

    public void process_log_exception_stacktrace_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Boolean bl = Boolean.valueOf(node.getFirstChild().getNodeValue());
            ((Session)objectHolder.getObject()).getSessionLog().setShouldLogExceptionStackTrace(bl);
        }
        catch (Throwable throwable) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), throwable));
        }
    }

    public void process_print_thread_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Boolean bl = Boolean.valueOf(node.getFirstChild().getNodeValue());
            ((Session)objectHolder.getObject()).getSessionLog().setShouldPrintThread(bl);
        }
        catch (Throwable throwable) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), throwable));
        }
    }

    public void process_print_session_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Boolean bl = Boolean.valueOf(node.getFirstChild().getNodeValue());
            ((Session)objectHolder.getObject()).getSessionLog().setShouldPrintSession(bl);
        }
        catch (Throwable throwable) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), throwable));
        }
    }

    public void process_print_connection_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Boolean bl = Boolean.valueOf(node.getFirstChild().getNodeValue());
            ((Session)objectHolder.getObject()).getSessionLog().setShouldPrintConnection(bl);
        }
        catch (Throwable throwable) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), throwable));
        }
    }

    public void process_print_date_Tag(Node node, ObjectHolder objectHolder) {
        try {
            Boolean bl = Boolean.valueOf(node.getFirstChild().getNodeValue());
            ((Session)objectHolder.getObject()).getSessionLog().setShouldPrintDate(bl);
        }
        catch (Throwable throwable) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), throwable));
        }
    }

    public void process_remote_command_Tag(Node node, ObjectHolder objectHolder) {
        ObjectHolder objectHolder2 = new ObjectHolder();
        objectHolder2.setObject(new RemoteCommandManager((Session)objectHolder.getObject()));
        this.processChildrenNodes(node, objectHolder2);
    }

    public void process_channel_Tag(Node node, ObjectHolder objectHolder) {
        ((CommandManager)objectHolder.getObject()).setChannel(node.getFirstChild().getNodeValue());
    }

    public void process_commands_Tag(Node node, ObjectHolder objectHolder) {
        this.processChildrenNodes(node, objectHolder);
    }

    public void process_cache_sync_Tag(Node node, ObjectHolder objectHolder) {
        ((Session)((CommandManager)objectHolder.getObject()).getCommandProcessor()).setShouldPropagateChanges(true);
    }

    public void process_transport_Tag(Node node, ObjectHolder objectHolder) {
        this.processChildrenNodes(node, objectHolder);
    }

    public void process_on_connection_error_Tag(Node node, ObjectHolder objectHolder) {
        String string = node.getFirstChild().getNodeValue();
        if (string.equals("DiscardConnection")) {
            ((CommandManager)objectHolder.getObject()).getTransportManager().setShouldRemoveConnectionOnError(true);
        } else if (string.equals("KeepConnection")) {
            ((CommandManager)objectHolder.getObject()).getTransportManager().setShouldRemoveConnectionOnError(false);
        } else {
            this.getExceptionStore().add(SessionLoaderException.unexpectedValueOfTag(string, node.getNodeName()));
        }
    }

    public void process_topic_host_url_Tag(Node node, ObjectHolder objectHolder) {
        try {
            ((JMSTopicTransportManager)objectHolder.getObject()).setTopicHostUrl(node.getFirstChild().getNodeValue());
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_topic_connection_factory_name_Tag(Node node, ObjectHolder objectHolder) {
        try {
            ((JMSTopicTransportManager)objectHolder.getObject()).setTopicConnectionFactoryName(node.getFirstChild().getNodeValue());
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_topic_name_Tag(Node node, ObjectHolder objectHolder) {
        try {
            ((JMSTopicTransportManager)objectHolder.getObject()).setTopicName(node.getFirstChild().getNodeValue());
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), node.getFirstChild().getNodeValue(), exception));
        }
    }

    public void process_transport_class_Tag(Node node, ObjectHolder objectHolder) {
        Session session = (Session)((CommandManager)objectHolder.getObject()).getCommandProcessor();
        String string = node.getFirstChild().getNodeValue();
        try {
            Class clazz = (Class)session.getDatasourcePlatform().getConversionManager().convertObject(string, ClassConstants.CLASS);
            Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
            TransportManager transportManager = (TransportManager)constructor.newInstance(null);
            session.getCommandManager().setTransportManager(transportManager);
        }
        catch (Exception exception) {
            this.getExceptionStore().add(SessionLoaderException.failedToLoadTag(node.getNodeName(), string, exception));
        }
    }

    public void process_rmi_Tag(Node node, ObjectHolder objectHolder) {
        ObjectHolder objectHolder2 = new ObjectHolder();
        RemoteCommandManager remoteCommandManager = (RemoteCommandManager)objectHolder.getObject();
        if (!(remoteCommandManager.getTransportManager() instanceof RMITransportManager)) {
            remoteCommandManager.setTransportManager(new RMITransportManager(remoteCommandManager));
        }
        objectHolder2.setObject(remoteCommandManager.getTransportManager());
        this.processChildrenNodes(node, objectHolder2);
    }

    public void process_send_mode_Tag(Node node, ObjectHolder objectHolder) {
        String string = node.getFirstChild().getNodeValue();
        RemoteCommandManager remoteCommandManager = ((TransportManager)objectHolder.getObject()).getRemoteCommandManager();
        if (string.equals("Asynchronous")) {
            remoteCommandManager.setShouldPropagateAsynchronously(true);
        } else if (string.equals("Synchronous")) {
            remoteCommandManager.setShouldPropagateAsynchronously(false);
        } else {
            this.getExceptionStore().add(SessionLoaderException.unexpectedValueOfTag(string, node.getNodeName()));
        }
    }

    public void process_discovery_Tag(Node node, ObjectHolder objectHolder) {
        this.processChildrenNodes(node, objectHolder);
    }

    public void process_announcement_delay_Tag(Node node, ObjectHolder objectHolder) {
        RemoteCommandManager remoteCommandManager = ((TransportManager)objectHolder.getObject()).getRemoteCommandManager();
        int n = Integer.parseInt(node.getFirstChild().getNodeValue());
        remoteCommandManager.getDiscoveryManager().setAnnouncementDelay(n);
    }

    public void process_jndi_naming_service_Tag(Node node, ObjectHolder objectHolder) {
        ((TransportManager)objectHolder.getObject()).setNamingServiceType(0);
        this.processChildrenNodes(node, objectHolder);
    }

    public void process_url_Tag(Node node, ObjectHolder objectHolder) {
        RemoteCommandManager remoteCommandManager = ((TransportManager)objectHolder.getObject()).getRemoteCommandManager();
        remoteCommandManager.setUrl(node.getFirstChild().getNodeValue());
    }

    public void process_initial_context_factory_name_Tag(Node node, ObjectHolder objectHolder) {
        ((TransportManager)objectHolder.getObject()).setInitialContextFactoryName(node.getFirstChild().getNodeValue());
    }

    public void process_property_Tag(Node node, ObjectHolder objectHolder) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = null;
        Node node3 = null;
        if (namedNodeMap != null) {
            node2 = namedNodeMap.getNamedItem("name");
            node3 = namedNodeMap.getNamedItem("value");
        }
        if (node2 == null || node3 == null) {
            this.getExceptionStore().add(SessionLoaderException.unknownAttributeOfTag(node.getNodeName()));
        } else {
            String string = node2.getNodeValue();
            String string2 = node3.getNodeValue();
            ((TransportManager)objectHolder.getObject()).getRemoteContextProperties().put(string, string2);
        }
    }

    public void process_rmi_registry_naming_service_Tag(Node node, ObjectHolder objectHolder) {
        ((TransportManager)objectHolder.getObject()).setNamingServiceType(1);
        this.processChildrenNodes(node, objectHolder);
    }

    protected void processChildrenNodes(Node node, ObjectHolder objectHolder) {
        NodeListElementEnumerator nodeListElementEnumerator = new NodeListElementEnumerator(node.getChildNodes());
        while (nodeListElementEnumerator.hasMoreNodes()) {
            Node node2 = nodeListElementEnumerator.nextNode();
            try {
                Class[] classArray = new Class[]{class$org$w3c$dom$Node == null ? XMLLoader.class$("org.w3c.dom.Node") : class$org$w3c$dom$Node, class$oracle$toplink$tools$sessionconfiguration$XMLLoader$ObjectHolder == null ? XMLLoader.class$("oracle.toplink.tools.sessionconfiguration.XMLLoader$ObjectHolder") : class$oracle$toplink$tools$sessionconfiguration$XMLLoader$ObjectHolder};
                Method method = this.getClass().getMethod(this.convertNodeToMethodName(node2), classArray);
                Object[] objectArray = new Object[]{node2, objectHolder};
                method.invoke((Object)this, objectArray);
            }
            catch (Exception exception) {
                this.getExceptionStore().add(SessionLoaderException.unkownTagAtNode(node2.getNodeName(), node.getNodeName(), exception));
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class XMLLoaderErrorHandler
    implements ErrorHandler {
        public void warning(SAXParseException sAXParseException) throws SAXException {
            XMLLoader.this.getMessageStore().add(SessionLoaderException.failedToParseXML(ExceptionLocalization.buildMessage("parsing_warning"), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException));
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw new SAXException(ExceptionLocalization.buildMessage("parsing_error"), sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw new SAXException(ExceptionLocalization.buildMessage("parsing_fatal_error"), sAXParseException);
        }
    }

    public class ObjectHolder {
        public Object object;

        public void setObject(Object object) {
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }
    }
}

