/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.schemaframework;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.tools.schemaframework.DatabaseObjectDefinition;
import oracle.toplink.tools.schemaframework.FieldDefinition;

public class TypeDefinition
extends DatabaseObjectDefinition {
    protected Vector fields = new Vector();

    public void addField(String string, Class clazz) {
        this.addField(new FieldDefinition(string, clazz));
    }

    public void addField(String string, Class clazz, int n) {
        this.addField(new FieldDefinition(string, clazz, n));
    }

    public void addField(String string, Class clazz, int n, int n2) {
        this.addField(new FieldDefinition(string, clazz, n, n2));
    }

    public void addField(String string, String string2) {
        this.addField(new FieldDefinition(string, string2));
    }

    public void addField(FieldDefinition fieldDefinition) {
        this.getFields().addElement(fieldDefinition);
    }

    public Writer buildCreationWriter(Session session, Writer writer) throws ValidationException {
        try {
            writer.write("CREATE TYPE " + this.getFullName() + " AS OBJECT (");
            Enumeration enumeration = this.getFields().elements();
            while (enumeration.hasMoreElements()) {
                FieldDefinition fieldDefinition = (FieldDefinition)enumeration.nextElement();
                fieldDefinition.appendTypeString(writer, session);
                if (!enumeration.hasMoreElements()) continue;
                writer.write(", ");
            }
            writer.write(")");
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return writer;
    }

    public Writer buildDeletionWriter(Session session, Writer writer) throws ValidationException {
        try {
            writer.write("DROP TYPE " + this.getFullName());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return writer;
    }

    public Vector getFields() {
        return this.fields;
    }

    public void setFields(Vector vector) {
        this.fields = vector;
    }
}

