/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.profiler;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.localization.ToStringLocalization;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.sessions.SessionProfiler;
import oracle.toplink.tools.profiler.Profile;

public class PerformanceProfiler
implements Serializable,
Cloneable,
SessionProfiler {
    protected Vector profiles = new Vector();
    protected transient Session session;
    protected boolean shouldLogProfile;
    protected int nestLevel;
    protected long nestTime;
    protected long profileTime;
    protected Hashtable operationTimings;
    protected Hashtable operationStartTimes;
    protected Hashtable operationTimingsByThread;
    protected Hashtable operationStartTimesByThread;
    static /* synthetic */ Class class$java$lang$Void;

    public PerformanceProfiler() {
        this(true);
    }

    public PerformanceProfiler(oracle.toplink.sessions.Session session) {
        this(session, true);
    }

    public PerformanceProfiler(oracle.toplink.sessions.Session session, boolean bl) {
        this.session = (Session)session;
        this.shouldLogProfile = bl;
        this.nestLevel = 0;
        this.operationTimingsByThread = new Hashtable();
        this.operationStartTimesByThread = new Hashtable();
    }

    public PerformanceProfiler(boolean bl) {
        this.shouldLogProfile = bl;
        this.nestLevel = 0;
        this.profileTime = 0L;
        this.nestTime = 0L;
        this.operationTimingsByThread = new Hashtable();
        this.operationStartTimesByThread = new Hashtable();
    }

    protected void addProfile(Profile profile) {
        this.getProfiles().addElement(profile);
    }

    public Profile buildProfileSummary() {
        Profile profile = new Profile();
        profile.setDomainClass(class$java$lang$Void == null ? (class$java$lang$Void = PerformanceProfiler.class$("java.lang.Void")) : class$java$lang$Void);
        profile.setQueryClass(class$java$lang$Void == null ? (class$java$lang$Void = PerformanceProfiler.class$("java.lang.Void")) : class$java$lang$Void);
        Enumeration enumeration = this.getProfiles().elements();
        while (enumeration.hasMoreElements()) {
            Profile profile2 = (Profile)enumeration.nextElement();
            if (profile.getShortestTime() == -1L || profile2.getTotalTime() < profile.getShortestTime()) {
                profile.setShortestTime(profile2.getTotalTime());
            }
            if (profile2.getTotalTime() > profile.getLongestTime()) {
                profile.setLongestTime(profile2.getTotalTime());
            }
            profile.setTotalTime(profile.getTotalTime() + profile2.getTotalTime());
            profile.setLocalTime(profile.getLocalTime() + profile2.getLocalTime());
            profile.setProfileTime(profile.getProfileTime() + profile2.getProfileTime());
            profile.setNumberOfInstancesEffected(profile.getNumberOfInstancesEffected() + profile2.getNumberOfInstancesEffected());
            Enumeration enumeration2 = profile2.getOperationTimings().keys();
            while (enumeration2.hasMoreElements()) {
                String string = (String)enumeration2.nextElement();
                Long l = (Long)profile.getOperationTimings().get(string);
                long l2 = (Long)profile2.getOperationTimings().get(string);
                long l3 = l == null ? l2 : l + l2;
                profile.getOperationTimings().put(string, new Long(l3));
            }
        }
        return profile;
    }

    public Hashtable buildProfileSummaryByClass() {
        Hashtable<Class, Profile> hashtable = new Hashtable<Class, Profile>();
        Enumeration enumeration = this.getProfiles().elements();
        while (enumeration.hasMoreElements()) {
            Profile profile;
            Profile profile2 = (Profile)enumeration.nextElement();
            Class clazz = profile2.getDomainClass();
            if (clazz == null) {
                Class clazz2 = clazz = class$java$lang$Void == null ? PerformanceProfiler.class$("java.lang.Void") : class$java$lang$Void;
            }
            if ((profile = (Profile)hashtable.get(clazz)) == null) {
                profile = new Profile();
                profile.setDomainClass(clazz);
                hashtable.put(clazz, profile);
            }
            if (profile.getShortestTime() == -1L || profile2.getTotalTime() < profile.getShortestTime()) {
                profile.setShortestTime(profile2.getTotalTime());
            }
            if (profile2.getTotalTime() > profile.getLongestTime()) {
                profile.setLongestTime(profile2.getTotalTime());
            }
            profile.setTotalTime(profile.getTotalTime() + profile2.getTotalTime());
            profile.setLocalTime(profile.getLocalTime() + profile2.getLocalTime());
            profile.setProfileTime(profile.getProfileTime() + profile2.getProfileTime());
            profile.setNumberOfInstancesEffected(profile.getNumberOfInstancesEffected() + profile2.getNumberOfInstancesEffected());
            Enumeration enumeration2 = profile2.getOperationTimings().keys();
            while (enumeration2.hasMoreElements()) {
                String string = (String)enumeration2.nextElement();
                Long l = (Long)profile.getOperationTimings().get(string);
                long l2 = (Long)profile2.getOperationTimings().get(string);
                long l3 = l == null ? l2 : l + l2;
                profile.getOperationTimings().put(string, new Long(l3));
            }
        }
        return hashtable;
    }

    public Hashtable buildProfileSummaryByQuery() {
        Hashtable<Class, Profile> hashtable = new Hashtable<Class, Profile>();
        Enumeration enumeration = this.getProfiles().elements();
        while (enumeration.hasMoreElements()) {
            Profile profile;
            Profile profile2 = (Profile)enumeration.nextElement();
            Class clazz = profile2.getQueryClass();
            if (clazz == null) {
                Class clazz2 = clazz = class$java$lang$Void == null ? PerformanceProfiler.class$("java.lang.Void") : class$java$lang$Void;
            }
            if ((profile = (Profile)hashtable.get(clazz)) == null) {
                profile = new Profile();
                profile.setQueryClass(clazz);
                hashtable.put(clazz, profile);
            }
            profile.setTotalTime(profile.getTotalTime() + profile2.getTotalTime());
            profile.setLocalTime(profile.getLocalTime() + profile2.getLocalTime());
            profile.setProfileTime(profile.getProfileTime() + profile2.getProfileTime());
            profile.setNumberOfInstancesEffected(profile.getNumberOfInstancesEffected() + profile2.getNumberOfInstancesEffected());
            Enumeration enumeration2 = profile2.getOperationTimings().keys();
            while (enumeration2.hasMoreElements()) {
                String string = (String)enumeration2.nextElement();
                Long l = (Long)profile.getOperationTimings().get(string);
                long l2 = (Long)profile2.getOperationTimings().get(string);
                long l3 = l == null ? l2 : l + l2;
                profile.getOperationTimings().put(string, new Long(l3));
            }
        }
        return hashtable;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void dontLogProfile() {
        this.setShouldLogProfile(false);
    }

    public void endOperationProfile(String string) {
        Serializable serializable;
        long l = System.currentTimeMillis();
        Long l2 = (Long)this.getOperationStartTimes().get(string);
        if (l2 == null) {
            return;
        }
        long l3 = l - l2;
        if (this.getNestLevel() == 0) {
            if (l3 == 0L) {
                return;
            }
            serializable = new Profile();
            ((Profile)serializable).setTotalTime(l3);
            ((Profile)serializable).setLocalTime(l3);
            ((Profile)serializable).addTiming(string, l3);
            this.addProfile((Profile)serializable);
            if (this.shouldLogProfile()) {
                Writer writer = this.getSession().getLog();
                try {
                    ((Profile)serializable).write(writer, this);
                    writer.write(Helper.cr());
                    writer.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if ((serializable = (Long)this.getOperationTimings().get(string)) == null) {
            this.getOperationTimings().put(string, new Long(l3));
        } else {
            this.getOperationTimings().put(string, new Long((Long)serializable + l3));
        }
    }

    protected int getNestLevel() {
        return this.nestLevel;
    }

    protected long getNestTime() {
        return this.nestTime;
    }

    protected Hashtable getOperationStartTimes() {
        Integer n = new Integer(Thread.currentThread().hashCode());
        if (this.getOperationStartTimesByThread().get(n) == null) {
            this.getOperationStartTimesByThread().put(n, new Hashtable(10));
        }
        return (Hashtable)this.getOperationStartTimesByThread().get(n);
    }

    protected Hashtable getOperationStartTimesByThread() {
        return this.operationStartTimesByThread;
    }

    protected Hashtable getOperationTimings() {
        Integer n = new Integer(Thread.currentThread().hashCode());
        if (this.getOperationTimingsByThread().get(n) == null) {
            this.getOperationTimingsByThread().put(n, new Hashtable(10));
        }
        return (Hashtable)this.getOperationTimingsByThread().get(n);
    }

    protected Hashtable getOperationTimingsByThread() {
        return this.operationTimingsByThread;
    }

    public Vector getProfiles() {
        return this.profiles;
    }

    protected long getProfileTime() {
        return this.profileTime;
    }

    public Session getSession() {
        return this.session;
    }

    public void logProfile() {
        this.setShouldLogProfile(true);
    }

    public void logProfileSummary() {
        Writer writer = this.getSession().getLog();
        try {
            writer.write(this.buildProfileSummary().toString());
            writer.write(Helper.cr());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void logProfileSummaryByClass() {
        Hashtable hashtable = this.buildProfileSummaryByClass();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Class clazz = (Class)enumeration.nextElement();
            Writer writer = this.getSession().getLog();
            try {
                writer.write(hashtable.get(clazz).toString());
                writer.write(Helper.cr());
            }
            catch (IOException iOException) {}
        }
    }

    public void logProfileSummaryByQuery() {
        Hashtable hashtable = this.buildProfileSummaryByQuery();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Class clazz = (Class)enumeration.nextElement();
            Writer writer = this.getSession().getLog();
            try {
                writer.write(hashtable.get(clazz).toString());
                writer.write(Helper.cr());
            }
            catch (IOException iOException) {}
        }
    }

    public Object profileExecutionOfQuery(DatabaseQuery databaseQuery, DatabaseRow databaseRow, Session session) {
        long l = System.currentTimeMillis();
        long l2 = this.getProfileTime();
        Profile profile = new Profile();
        profile.setQueryClass(databaseQuery.getClass());
        profile.setDomainClass(databaseQuery.getReferenceClass());
        Writer writer = this.getSession().getLog();
        Object object = null;
        try {
            if (this.shouldLogProfile()) {
                this.writeNestingTabs(writer);
                writer.write(ToStringLocalization.buildMessage("begin_profile_of", null) + "{" + databaseQuery.toString() + Helper.cr());
                writer.flush();
            }
            this.setNestLevel(this.getNestLevel() + 1);
            long l3 = this.getNestTime();
            Hashtable hashtable = (Hashtable)this.getOperationTimings().clone();
            Hashtable hashtable2 = (Hashtable)this.getOperationStartTimes().clone();
            long l4 = System.currentTimeMillis();
            object = session.internalExecuteQuery(databaseQuery, databaseRow);
            long l5 = System.currentTimeMillis();
            this.setNestLevel(this.getNestLevel() - 1);
            Enumeration enumeration = this.getOperationTimings().keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Long l6 = (Long)hashtable.get(string);
                long l7 = (Long)this.getOperationTimings().get(string);
                long l8 = l6 != null ? l7 - l6 : l7;
                profile.addTiming(string, l8);
            }
            profile.setTotalTime(l5 - l4 - (this.getProfileTime() - l2));
            profile.setLocalTime(profile.getTotalTime() - (this.getNestTime() - l3));
            if (object instanceof Vector) {
                profile.setNumberOfInstancesEffected(((Vector)object).size());
            } else {
                profile.setNumberOfInstancesEffected(1L);
            }
            this.addProfile(profile);
            if (this.shouldLogProfile()) {
                this.writeNestingTabs(writer);
                long l9 = System.currentTimeMillis();
                long l10 = l9 - l;
                profile.setProfileTime(l10 - profile.getTotalTime());
                profile.write(writer, this);
                writer.write(Helper.cr());
                this.writeNestingTabs(writer);
                writer.write("}" + ToStringLocalization.buildMessage("end_profile", null));
                writer.write(Helper.cr());
                writer.flush();
            }
            if (this.getNestLevel() == 0) {
                this.setNestTime(0L);
                this.setProfileTime(0L);
                this.setOperationTimings(new Hashtable(5));
                this.setOperationStartTimes(new Hashtable(5));
                long l11 = System.currentTimeMillis();
                long l12 = l11 - l;
                profile.setProfileTime(l12 - profile.getTotalTime());
            } else {
                this.setNestTime(l3 + profile.getTotalTime());
                this.setOperationTimings(hashtable);
                this.setOperationStartTimes(hashtable2);
                long l13 = System.currentTimeMillis();
                long l14 = l13 - l;
                this.setProfileTime(this.getProfileTime() + (l14 - (l5 - l4)));
                profile.setProfileTime(l14 - profile.getTotalTime());
                Enumeration enumeration2 = ((Hashtable)hashtable2.clone()).keys();
                while (enumeration2.hasMoreElements()) {
                    String string = (String)enumeration2.nextElement();
                    hashtable2.put(string, new Long(((Number)hashtable2.get(string)).longValue() + l14));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return object;
    }

    protected void setNestLevel(int n) {
        this.nestLevel = n;
    }

    protected void setNestTime(long l) {
        this.nestTime = l;
    }

    protected void setOperationStartTimes(Hashtable hashtable) {
        Integer n = new Integer(Thread.currentThread().hashCode());
        this.getOperationStartTimesByThread().put(n, hashtable);
    }

    protected void setOperationStartTimesByThread(Hashtable hashtable) {
        this.operationStartTimesByThread = hashtable;
    }

    protected void setOperationTimings(Hashtable hashtable) {
        Integer n = new Integer(Thread.currentThread().hashCode());
        this.getOperationTimingsByThread().put(n, hashtable);
    }

    protected void setOperationTimingsByThread(Hashtable hashtable) {
        this.operationTimingsByThread = hashtable;
    }

    protected void setProfiles(Vector vector) {
        this.profiles = vector;
    }

    protected void setProfileTime(long l) {
        this.profileTime = l;
    }

    public void setSession(oracle.toplink.sessions.Session session) {
        this.session = (Session)session;
    }

    public void setShouldLogProfile(boolean bl) {
        this.shouldLogProfile = bl;
    }

    public boolean shouldLogProfile() {
        return this.shouldLogProfile;
    }

    public void startOperationProfile(String string) {
        this.getOperationStartTimes().put(string, new Long(System.currentTimeMillis()));
    }

    protected void writeNestingTabs(Writer writer) {
        try {
            for (int i = 0; i < this.getNestLevel(); ++i) {
                writer.write("\t");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void update(String string, Object object) {
    }

    public void occurred(String string) {
    }

    public void setProfileWeight(int n) {
    }

    public int getProfileWeight() {
        return -1;
    }

    public void initialize() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

