/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.sessionbroker;

import java.io.Writer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.IntegrityChecker;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.history.AsOfClause;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.databaseaccess.Platform;
import oracle.toplink.internal.identitymaps.IdentityMapManager;
import oracle.toplink.internal.sequencing.Sequencing;
import oracle.toplink.internal.sequencing.SequencingFactory;
import oracle.toplink.internal.sequencing.SequencingHome;
import oracle.toplink.internal.sessions.DatabaseSessionImpl;
import oracle.toplink.internal.sessions.SessionBrokerIdentityMapAccessor;
import oracle.toplink.logging.SessionLog;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.DatabaseSession;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.sessions.DatabaseLogin;
import oracle.toplink.sessions.Project;
import oracle.toplink.sessions.SessionProfiler;
import oracle.toplink.threetier.ClientSession;
import oracle.toplink.threetier.ServerSession;

public class SessionBroker
extends DatabaseSessionImpl {
    protected Map sessionNamesByClass;
    protected Map sessionsByName = new HashMap(2);
    protected Sequencing sequencing;

    public SessionBroker() {
        super(new DatabaseLogin());
        this.sessionNamesByClass = new HashMap(2);
    }

    protected SessionBroker(Map map) {
        super(new DatabaseLogin());
        this.sessionNamesByClass = map;
    }

    public SessionBroker acquireClientSessionBroker() {
        this.log(2, "connection", "acquire_client_session_broker");
        SessionBroker sessionBroker = this.copySessionBroker();
        sessionBroker.getIdentityMapAccessorInstance().setIdentityMapManager(this.getIdentityMapAccessorInstance().getIdentityMapManager());
        sessionBroker.commitManager = this.getCommitManager();
        sessionBroker.cacheSynchronizationManager = this.getCacheSynchronizationManager();
        sessionBroker.externalTransactionController = this.getExternalTransactionController();
        Iterator iterator = this.getSessionsByName().keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Session session = this.getSessionForName(string);
            if (session instanceof ServerSession) {
                if (session.getProject().hasIsolatedClasses()) {
                    throw ValidationException.isolatedDataNotSupportedInSessionBroker(string);
                }
                sessionBroker.internalRegisterSession(string, ((ServerSession)session).acquireClientSession());
                continue;
            }
            throw ValidationException.cannotAcquireClientSessionFromSession();
        }
        sessionBroker.initializeSequencing();
        return sessionBroker;
    }

    public oracle.toplink.sessions.Session acquireHistoricalSession(AsOfClause asOfClause) throws ValidationException {
        if (this.isServerSessionBroker()) {
            throw ValidationException.cannotAcquireHistoricalSession();
        }
        SessionBroker sessionBroker = this.copySessionBroker();
        Iterator iterator = this.getSessionsByName().keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Session session = this.getSessionForName(string);
            sessionBroker.registerSession(string, session.acquireHistoricalSession(asOfClause));
        }
        return sessionBroker;
    }

    public void afterTransaction(boolean bl, boolean bl2) {
        Iterator iterator = this.getSessionsByName().values().iterator();
        while (iterator.hasNext()) {
            Session session = (Session)iterator.next();
            session.afterTransaction(bl, bl2);
        }
    }

    public UnitOfWork acquireUnitOfWork() {
        if (this.isServerSessionBroker()) {
            return this.acquireClientSessionBroker().acquireUnitOfWork();
        }
        return super.acquireUnitOfWork();
    }

    public void addDescriptor(Descriptor descriptor) {
        throw ValidationException.cannotAddDescriptorsToSessionBroker();
    }

    public void addDescriptors(Vector vector) throws ValidationException {
        throw ValidationException.cannotAddDescriptorsToSessionBroker();
    }

    public void addDescriptors(Project project) throws ValidationException {
        throw ValidationException.cannotAddDescriptorsToSessionBroker();
    }

    protected void basicBeginTransaction() throws DatabaseException {
        Iterator iterator = this.getSessionsByName().values().iterator();
        while (iterator.hasNext()) {
            Session session = (Session)iterator.next();
            session.beginTransaction();
        }
    }

    protected void basicCommitTransaction() throws DatabaseException {
        Session session;
        Iterator iterator = this.getSessionsByName().values().iterator();
        while (iterator.hasNext()) {
            session = (Session)iterator.next();
            if (session.isConnected()) continue;
            throw DatabaseException.databaseAccessorNotConnected();
        }
        iterator = this.getSessionsByName().values().iterator();
        while (iterator.hasNext()) {
            session = (Session)iterator.next();
            session.commitTransaction();
        }
    }

    protected void basicRollbackTransaction() throws DatabaseException {
        DatabaseException databaseException = null;
        Iterator iterator = this.getSessionsByName().values().iterator();
        while (iterator.hasNext()) {
            Session session = (Session)iterator.next();
            try {
                session.rollbackTransaction();
            }
            catch (DatabaseException databaseException2) {
                databaseException = databaseException2;
            }
        }
        if (databaseException != null) {
            throw databaseException;
        }
    }

    public boolean containsQuery(String string) {
        boolean bl = this.getQueries().containsKey(string);
        if (this.isClientSessionBroker() && !bl) {
            String string2 = null;
            Session session = null;
            Iterator iterator = this.getSessionsByName().keySet().iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                session = this.getSessionForName(string2);
                if (!(session instanceof ClientSession) || !((ClientSession)session).getParent().getBroker().containsQuery(string)) continue;
                return true;
            }
        }
        return bl;
    }

    protected SessionBroker copySessionBroker() {
        SessionBroker sessionBroker = new SessionBroker(this.getSessionNamesByClass());
        sessionBroker.accessor = this.getAccessor();
        sessionBroker.name = this.getName();
        sessionBroker.sessionLog = this.getSessionLog();
        sessionBroker.project = this.project;
        sessionBroker.eventManager = this.getEventManager().clone(sessionBroker);
        return sessionBroker;
    }

    public Accessor getAccessor(Class clazz) {
        if (clazz == null) {
            throw QueryException.unnamedQueryOnSessionBroker(null);
        }
        return this.getSessionForClass(clazz).getAccessor(clazz);
    }

    public Accessor getAccessor(String string) {
        return this.getSessionForName(string).getAccessor(string);
    }

    public AsOfClause getAsOfClause() {
        Iterator iterator = this.getSessionsByName().values().iterator();
        if (iterator.hasNext()) {
            return ((Session)iterator.next()).getAsOfClause();
        }
        return null;
    }

    public Session getParentIdentityMapSession(DatabaseQuery databaseQuery, boolean bl, boolean bl2) {
        if (databaseQuery == null) {
            return this;
        }
        return this.getSessionForQuery(databaseQuery).getParentIdentityMapSession(databaseQuery, bl, bl2);
    }

    public Session getExecutionSession(DatabaseQuery databaseQuery) {
        Session session = this.getSessionForQuery(databaseQuery);
        return session.getExecutionSession(databaseQuery);
    }

    public Platform getPlatform(Class clazz) {
        if (clazz == null) {
            return super.getDatasourcePlatform();
        }
        return this.getSessionForClass(clazz).getDatasourcePlatform();
    }

    public DatabaseQuery getQuery(String string) {
        DatabaseQuery databaseQuery = super.getQuery(string);
        if (this.isClientSessionBroker() && databaseQuery == null) {
            String string2 = null;
            Session session = null;
            Iterator iterator = this.getSessionsByName().keySet().iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                session = this.getSessionForName(string2);
                if (!(session instanceof ClientSession) || (databaseQuery = ((ClientSession)session).getParent().getBroker().getQuery(string)) == null) continue;
                return databaseQuery;
            }
        }
        return databaseQuery;
    }

    public DatabaseQuery getQuery(String string, Vector vector) {
        DatabaseQuery databaseQuery = super.getQuery(string, vector);
        if (this.isClientSessionBroker() && databaseQuery == null) {
            String string2 = null;
            Session session = null;
            Iterator iterator = this.getSessionsByName().keySet().iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                session = this.getSessionForName(string2);
                if (!(session instanceof ClientSession) || (databaseQuery = ((ClientSession)session).getParent().getBroker().getQuery(string, vector)) == null) continue;
                return databaseQuery;
            }
        }
        return databaseQuery;
    }

    public Session getSessionForClass(Class clazz) throws ValidationException {
        if (clazz == null) {
            return this;
        }
        String string = (String)this.getSessionNamesByClass().get(clazz);
        if (string == null) {
            throw ValidationException.noSessionRegisteredForClass(clazz);
        }
        return (Session)this.getSessionsByName().get(string);
    }

    public Session getSessionForName(String string) throws ValidationException {
        Session session = (Session)this.getSessionsByName().get(string);
        if (session == null) {
            throw ValidationException.noSessionRegisteredForName(string);
        }
        return session;
    }

    protected Session getSessionForQuery(DatabaseQuery databaseQuery) {
        Class clazz;
        if (databaseQuery.hasSessionName()) {
            return this.getSessionForName(databaseQuery.getSessionName());
        }
        if (databaseQuery.getDescriptor() != null) {
            clazz = databaseQuery.getDescriptor().getJavaClass();
        } else {
            clazz = databaseQuery.getReferenceClass();
            if (clazz == null) {
                throw QueryException.unnamedQueryOnSessionBroker(databaseQuery);
            }
        }
        return this.getSessionForClass(clazz);
    }

    protected Map getSessionNamesByClass() {
        return this.sessionNamesByClass;
    }

    public Map getSessionsByName() {
        return this.sessionsByName;
    }

    public void initializeDescriptors() {
        DatabaseSession databaseSession;
        Iterator iterator;
        if (!this.isClientSessionBroker()) {
            iterator = this.getSessionsByName().values().iterator();
            while (iterator.hasNext()) {
                databaseSession = (DatabaseSession)iterator.next();
                databaseSession.initializeSequencing();
            }
        }
        super.initializeDescriptors();
        this.getProject().setIsPureCMP2Project(false);
        iterator = this.getSessionsByName().values().iterator();
        while (iterator.hasNext()) {
            databaseSession = (DatabaseSession)iterator.next();
            if (databaseSession.getProject().hasGenericHistorySupport()) {
                this.getProject().setHasGenericHistorySupport(true);
            }
            if (!databaseSession.getProject().hasIsolatedClasses()) continue;
            this.getProject().setHasIsolatedClasses(true);
        }
        if (this.isServerSessionBroker()) {
            this.sequencing = null;
        }
    }

    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new SessionBrokerIdentityMapAccessor(this, new IdentityMapManager(this));
    }

    public Object internalExecuteQuery(DatabaseQuery databaseQuery, DatabaseRow databaseRow) throws DatabaseException, QueryException {
        Session session = this.getSessionForQuery(databaseQuery);
        return session.internalExecuteQuery(databaseQuery, databaseRow);
    }

    public boolean isBroker() {
        return true;
    }

    public boolean isClientSessionBroker() {
        Iterator iterator = this.getSessionsByName().values().iterator();
        while (iterator.hasNext()) {
            Session session = (Session)iterator.next();
            if (!session.isClientSession()) continue;
            return true;
        }
        return false;
    }

    public boolean isConnected() {
        if (this.getSessionsByName() == null || this.getSessionsByName().isEmpty()) {
            return false;
        }
        Iterator iterator = this.getSessionsByName().values().iterator();
        while (iterator.hasNext()) {
            Session session = (Session)iterator.next();
            if (session.isConnected()) continue;
            return false;
        }
        return true;
    }

    public boolean isServerSessionBroker() {
        Iterator iterator = this.getSessionsByName().values().iterator();
        while (iterator.hasNext()) {
            Session session = (Session)iterator.next();
            if (!session.isServerSession()) continue;
            return true;
        }
        return false;
    }

    public boolean isSessionBroker() {
        return true;
    }

    public void login() throws DatabaseException {
        if (this.isLoggedIn) {
            throw ValidationException.alreadyLoggedIn(this.getName());
        }
        this.getEventManager().preLogin(this);
        if (!this.isConnected()) {
            this.getServerPlatform().initializeExternalTransactionController();
        }
        Iterator iterator = this.getSessionsByName().values().iterator();
        while (iterator.hasNext()) {
            DatabaseSession databaseSession = (DatabaseSession)iterator.next();
            databaseSession.getEventManager().preLogin(databaseSession);
            if (databaseSession.isConnected()) continue;
            databaseSession.connect();
        }
        this.initializeDescriptors();
        if (this.getCacheSynchronizationManager() != null) {
            this.getCacheSynchronizationManager().initialize();
        }
        this.isLoggedIn = true;
    }

    public void login(String string, String string2) throws DatabaseException {
        if (this.isLoggedIn) {
            throw ValidationException.alreadyLoggedIn(this.getName());
        }
        this.getEventManager().preLogin(this);
        if (!this.isConnected()) {
            this.getServerPlatform().initializeExternalTransactionController();
        }
        Iterator iterator = this.getSessionsByName().values().iterator();
        while (iterator.hasNext()) {
            DatabaseSession databaseSession = (DatabaseSession)iterator.next();
            databaseSession.getEventManager().preLogin(databaseSession);
            databaseSession.getDatasourceLogin().setUserName(string);
            databaseSession.getDatasourceLogin().setPassword(string2);
            if (databaseSession.isConnected()) continue;
            databaseSession.connect();
        }
        this.initializeDescriptors();
        this.isLoggedIn = true;
    }

    public void logout() throws DatabaseException {
        Iterator iterator = this.getSessionsByName().values().iterator();
        while (iterator.hasNext()) {
            DatabaseSession databaseSession = (DatabaseSession)iterator.next();
            databaseSession.logout();
        }
        this.sequencing = null;
        this.isLoggedIn = false;
    }

    public void registerSession(String string, Session session) {
        session.setIsInBroker(true);
        this.getSessionsByName().put(string, session);
        session.setBroker(this);
        session.setName(string);
        Iterator iterator = session.getDescriptors().values().iterator();
        Iterator iterator2 = session.getDescriptors().keySet().iterator();
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)iterator.next();
            Class clazz = (Class)iterator2.next();
            this.getSessionNamesByClass().put(clazz, string);
            this.getDescriptors().put(clazz, descriptor);
        }
    }

    public void registerSession(String string, oracle.toplink.sessions.Session session) {
        this.registerSession(string, (Session)session);
    }

    public void internalRegisterSession(String string, Session session) {
        session.setIsInBroker(true);
        this.getSessionsByName().put(string, session);
        session.setBroker(this);
        session.setName(string);
    }

    public void release() {
        if (this.isClientSessionBroker()) {
            this.log(2, "connection", "releasing_client_session_broker");
        }
        Iterator iterator = this.getSessionsByName().values().iterator();
        while (iterator.hasNext()) {
            Session session = (Session)iterator.next();
            session.release();
        }
        super.release();
    }

    public void releaseClientSessionBroker() {
        this.release();
    }

    public void setIntegrityChecker(IntegrityChecker integrityChecker) {
        super.setIntegrityChecker(integrityChecker);
        Iterator iterator = this.getSessionsByName().values().iterator();
        while (iterator.hasNext()) {
            Session session = (Session)iterator.next();
            session.setIntegrityChecker(integrityChecker);
        }
    }

    public void setSessionLog(SessionLog sessionLog) {
        super.setSessionLog(sessionLog);
        Iterator iterator = this.getSessionsByName().values().iterator();
        while (iterator.hasNext()) {
            Session session = (Session)iterator.next();
            session.setSessionLog(sessionLog);
        }
    }

    public void setLog(Writer writer) {
        super.setLog(writer);
        Iterator iterator = this.getSessionsByName().values().iterator();
        while (iterator.hasNext()) {
            Session session = (Session)iterator.next();
            session.setLog(writer);
        }
    }

    public void setProfiler(SessionProfiler sessionProfiler) {
        super.setProfiler(sessionProfiler);
        Iterator iterator = this.getSessionsByName().values().iterator();
        while (iterator.hasNext()) {
            Session session = (Session)iterator.next();
            session.setProfiler(sessionProfiler);
        }
    }

    protected void setSessionNameByClass(HashMap hashMap) {
        this.sessionNamesByClass = hashMap;
    }

    public void setSessionsByName(Hashtable hashtable) {
        this.sessionsByName = hashtable;
    }

    public void setShouldLogMessages(boolean bl) {
        super.setShouldLogMessages(bl);
        Iterator iterator = this.getSessionsByName().values().iterator();
        while (iterator.hasNext()) {
            Session session = (Session)iterator.next();
            session.setShouldLogMessages(bl);
        }
    }

    public void writesCompleted() {
        Session session;
        Iterator iterator = this.getSessionsByName().values().iterator();
        while (iterator.hasNext()) {
            session = (Session)iterator.next();
            if (session.isConnected()) continue;
            throw DatabaseException.databaseAccessorNotConnected();
        }
        iterator = this.getSessionsByName().values().iterator();
        while (iterator.hasNext()) {
            session = (Session)iterator.next();
            session.writesCompleted();
        }
    }

    public void initializeSequencing() {
        this.sequencing = SequencingFactory.createSequencing(this);
    }

    protected SequencingHome getSequencingHome() {
        return null;
    }

    public Sequencing getSequencing() {
        return this.sequencing;
    }
}

