/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.services;

import oracle.toplink.exceptions.SynchronizationException;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.publicinterface.DatabaseSession;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.remote.AbstractClusteringService;
import oracle.toplink.remote.CacheSynchronizationManager;
import oracle.toplink.sessions.DatabaseLogin;
import oracle.toplink.tools.workbench.XMLProjectReader;

public class DevelopmentServices {
    protected Session session;

    public DevelopmentServices() {
    }

    public DevelopmentServices(Session session) {
        this.session = session;
    }

    public void initializeIdentityMap(String string) throws ClassNotFoundException {
        Class clazz = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(string, ClassConstants.CLASS);
        this.getSession().getIdentityMapAccessorInstance().initializeIdentityMap(clazz);
    }

    public void initializeAllIdentityMaps() {
        this.getSession().getIdentityMapAccessorInstance().initializeIdentityMaps();
    }

    public void setIdentityMapForClass(String string, String string2, int n) throws ClassNotFoundException {
        Class clazz = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(string, ClassConstants.CLASS);
        Class clazz2 = PrivilegedAccessController.getClassForName(string2);
        Descriptor descriptor = this.getSession().getDescriptor(clazz);
        descriptor.setIdentityMapClass(clazz2);
        descriptor.setIdentityMapSize(n);
        this.getSession().getIdentityMapAccessorInstance().initializeIdentityMap(clazz);
    }

    public void refreshProject(String string) {
        ((DatabaseSession)this.getSession()).logout();
        this.getSession().setProject(XMLProjectReader.read(string));
        ((DatabaseSession)this.getSession()).login();
    }

    public void updateCacheSize(String string, int n) throws ClassNotFoundException {
        Class clazz = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(string, ClassConstants.CLASS);
        this.getSession().getIdentityMapAccessorInstance().getIdentityMap(clazz).updateMaxSize(n);
    }

    public void setChangeSetPropagationShouldBeAsynchronous(boolean bl) {
        if (this.getSession().getCacheSynchronizationManager() != null) {
            this.getSession().getCacheSynchronizationManager().setIsAsynchronous(bl);
        }
    }

    public boolean getChangeSetPropagationShouldBeAsynchronous() {
        return this.getSession().getCacheSynchronizationManager() != null && this.getSession().getCacheSynchronizationManager().isAsynchronous();
    }

    public void setShouldRemoveConnectionOnError(boolean bl) {
        if (this.getSession().getCacheSynchronizationManager() != null) {
            this.getSession().getCacheSynchronizationManager().setShouldRemoveConnectionOnError(bl);
        }
    }

    public boolean getShouldRemoveConnectionOnError() {
        return this.getSession().getCacheSynchronizationManager() != null && this.getSession().getCacheSynchronizationManager().shouldRemoveConnectionOnError();
    }

    public void updateSynchronizationDiscoveryMulticastGroup(String string, int n) {
        this.getSession().getCacheSynchronizationManager().getClusteringService().setMulticastGroupAddress(string);
        this.getSession().getCacheSynchronizationManager().getClusteringService().setMulticastPort(n);
    }

    public void initializeCacheSynchronizationServices() throws SynchronizationException {
        CacheSynchronizationManager cacheSynchronizationManager = this.getSession().getCacheSynchronizationManager();
        AbstractClusteringService abstractClusteringService = null;
        try {
            abstractClusteringService = (AbstractClusteringService)PrivilegedAccessController.newInstanceFromClass(cacheSynchronizationManager.getClusteringService().getClass());
        }
        catch (Exception exception) {
            throw SynchronizationException.failToResetCacheSynch();
        }
        cacheSynchronizationManager.getClusteringService().stopListening();
        abstractClusteringService.setMulticastGroupAddress(cacheSynchronizationManager.getClusteringService().getMulticastGroupAddress());
        abstractClusteringService.setMulticastPort(cacheSynchronizationManager.getClusteringService().getMulticastPort());
        abstractClusteringService.setSession(this.getSession());
        cacheSynchronizationManager.removeAllRemoteConnections();
        cacheSynchronizationManager.initialize();
    }

    public void setShouldBindAllParameters(boolean bl) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setShouldBindAllParameters(bl);
    }

    public boolean getShouldBindAllParameters() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return false;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).shouldBindAllParameters();
    }

    public void setStringBindingSize(int n) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setStringBindingSize(n);
    }

    public int getStringBindingSize() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return 0;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).getStringBindingSize();
    }

    public void setUsesBatchWriting(boolean bl) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setUsesBatchWriting(bl);
    }

    public boolean getUsesBatchWriting() {
        return this.getSession().getDatasourceLogin().getPlatform().usesBatchWriting();
    }

    public void setUsesJDBCBatchWriting(boolean bl) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setUsesBatchWriting(bl);
    }

    public boolean getUsesJDBCBatchWriting() {
        return this.getSession().getDatasourceLogin().getPlatform().usesJDBCBatchWriting();
    }

    public void setUsesByteArrayBinding(boolean bl) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setUsesByteArrayBinding(bl);
    }

    public boolean getUsesByteArrayBinding() {
        return this.getSession().getDatasourceLogin().getPlatform().usesByteArrayBinding();
    }

    public void setUsesNativeSQL(boolean bl) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setUsesNativeSQL(bl);
    }

    public boolean getUsesNativeSQL() {
        return this.getSession().getDatasourceLogin().getPlatform().usesNativeSQL();
    }

    public void setUsesStreamsForBinding(boolean bl) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setUsesStreamsForBinding(bl);
    }

    public boolean getUsesStreamsForBinding() {
        return this.getSession().getDatasourceLogin().getPlatform().usesStreamsForBinding();
    }

    public void setUsesStringBinding(boolean bl) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setUsesStringBinding(bl);
    }

    public boolean getUsesStringBinding() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return false;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).getPlatform().usesStringBinding();
    }

    protected Session getSession() {
        return this.session;
    }
}

