/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.sequencing;

import java.math.BigDecimal;
import java.util.Vector;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.DataModifyQuery;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ValueReadQuery;
import oracle.toplink.sequencing.StandardSequence;
import oracle.toplink.sessions.Record;

public class QuerySequence
extends StandardSequence {
    protected ValueReadQuery selectQuery;
    protected DataModifyQuery updateQuery;
    protected boolean shouldAcquireValueAfterInsert;
    protected boolean shouldUseTransaction;
    protected boolean shouldSkipUpdate;
    protected boolean shouldSelectBeforeUpdate;
    protected boolean wasSelectQueryCreated;
    protected boolean wasUpdateQueryCreated;

    public QuerySequence() {
    }

    public QuerySequence(String string) {
        super(string);
    }

    public QuerySequence(String string, int n) {
        super(string, n);
    }

    public QuerySequence(boolean bl, boolean bl2) {
        this.setShouldAcquireValueAfterInsert(bl);
        this.setShouldUseTransaction(bl2);
    }

    public QuerySequence(String string, boolean bl, boolean bl2) {
        super(string);
        this.setShouldAcquireValueAfterInsert(bl);
        this.setShouldUseTransaction(bl2);
    }

    public QuerySequence(String string, int n, boolean bl, boolean bl2) {
        super(string, n);
        this.setShouldAcquireValueAfterInsert(bl);
        this.setShouldUseTransaction(bl2);
    }

    public boolean equals(Object object) {
        if (object instanceof QuerySequence && super.equals(object)) {
            QuerySequence querySequence = (QuerySequence)object;
            return this.getSelectQuery() == querySequence.getSelectQuery() && this.getUpdateQuery() == querySequence.getUpdateQuery() && this.shouldAcquireValueAfterInsert() == querySequence.shouldAcquireValueAfterInsert() && this.shouldUseTransaction() == querySequence.shouldUseTransaction() && this.shouldSkipUpdate() == querySequence.shouldSkipUpdate() && this.shouldSelectBeforeUpdate() == querySequence.shouldSelectBeforeUpdate();
        }
        return false;
    }

    public boolean shouldAcquireValueAfterInsert() {
        return this.shouldAcquireValueAfterInsert;
    }

    public void setShouldAcquireValueAfterInsert(boolean bl) {
        this.shouldAcquireValueAfterInsert = bl;
    }

    public boolean shouldUseTransaction() {
        return this.shouldUseTransaction;
    }

    public void setShouldUseTransaction(boolean bl) {
        this.shouldUseTransaction = bl;
    }

    public void setSelectQuery(ValueReadQuery valueReadQuery) {
        this.selectQuery = valueReadQuery;
    }

    public ValueReadQuery getSelectQuery() {
        return this.selectQuery;
    }

    public void setUpdateQuery(DataModifyQuery dataModifyQuery) {
        this.updateQuery = dataModifyQuery;
    }

    public DataModifyQuery getUpdateQuery() {
        return this.updateQuery;
    }

    public void setShouldSkipUpdate(boolean bl) {
        this.shouldSkipUpdate = bl;
    }

    public boolean shouldSkipUpdate() {
        return this.shouldSkipUpdate;
    }

    public void setShouldSelectBeforeUpdate(boolean bl) {
        this.shouldSelectBeforeUpdate = bl;
    }

    public boolean shouldSelectBeforeUpdate() {
        return this.shouldSelectBeforeUpdate;
    }

    protected ValueReadQuery buildSelectQuery() {
        return null;
    }

    protected DataModifyQuery buildUpdateQuery() {
        return null;
    }

    protected ValueReadQuery buildSelectQuery(String string, Integer n) {
        return null;
    }

    protected DataModifyQuery buildUpdateQuery(String string, Number number) {
        return null;
    }

    public void onConnect() {
        super.onConnect();
        if (this.getSelectQuery() == null) {
            this.setSelectQuery(this.buildSelectQuery());
            boolean bl = this.wasSelectQueryCreated = this.getSelectQuery() != null;
        }
        if (this.getUpdateQuery() == null && !this.shouldSkipUpdate()) {
            this.setUpdateQuery(this.buildUpdateQuery());
            this.wasUpdateQueryCreated = this.getUpdateQuery() != null;
        }
    }

    public void onDisconnect() {
        if (this.wasSelectQueryCreated) {
            this.setSelectQuery(null);
            this.wasSelectQueryCreated = false;
        }
        if (this.wasUpdateQueryCreated) {
            this.setUpdateQuery(null);
            this.wasUpdateQueryCreated = false;
        }
        super.onDisconnect();
    }

    protected Number updateAndSelectSequence(Accessor accessor, Session session, String string, int n) {
        Integer n2 = new Integer(n);
        if (this.shouldSkipUpdate()) {
            return (Number)this.select(accessor, session, string, n2);
        }
        if (this.shouldSelectBeforeUpdate()) {
            Object object;
            BigDecimal bigDecimal;
            Object object2 = this.select(accessor, session, string, n2);
            if (object2 instanceof Number) {
                bigDecimal = new BigDecimal((double)((Number)object2).longValue());
            } else if (object2 instanceof String) {
                bigDecimal = new BigDecimal((String)object2);
            } else if (object2 instanceof Record) {
                object = ((Record)object2).get("text()");
                bigDecimal = new BigDecimal((String)object);
            } else {
                return null;
            }
            object = bigDecimal.add(new BigDecimal((double)n));
            this.update(accessor, session, string, (Number)object);
            return object;
        }
        this.update(accessor, session, string, n2);
        return (Number)this.select(accessor, session, string, n2);
    }

    protected Object select(Accessor accessor, Session session, String string, Integer n) {
        Vector vector;
        ValueReadQuery valueReadQuery = this.getSelectQuery();
        if (valueReadQuery != null) {
            if (accessor != null) {
                valueReadQuery.setIsUserDefined(true);
                valueReadQuery.checkPrepare(session, null);
                valueReadQuery = (ValueReadQuery)valueReadQuery.clone();
                valueReadQuery.setAccessor(accessor);
            }
        } else {
            valueReadQuery = this.buildSelectQuery(string, n);
            if (accessor != null) {
                valueReadQuery.setAccessor(accessor);
            }
        }
        if ((vector = this.createArguments(valueReadQuery, string, n)) != null) {
            return session.executeQuery((DatabaseQuery)valueReadQuery, vector);
        }
        return session.executeQuery(valueReadQuery);
    }

    protected void update(Accessor accessor, Session session, String string, Number number) {
        Vector vector;
        DataModifyQuery dataModifyQuery = this.getUpdateQuery();
        if (dataModifyQuery != null) {
            if (accessor != null) {
                dataModifyQuery.setIsUserDefined(true);
                dataModifyQuery.checkPrepare(session, null);
                dataModifyQuery = (DataModifyQuery)dataModifyQuery.clone();
                dataModifyQuery.setAccessor(accessor);
            }
        } else {
            dataModifyQuery = this.buildUpdateQuery(string, number);
            if (dataModifyQuery == null) {
                return;
            }
            if (accessor != null) {
                dataModifyQuery.setAccessor(accessor);
            }
        }
        if ((vector = this.createArguments(dataModifyQuery, string, number)) != null) {
            session.executeQuery((DatabaseQuery)dataModifyQuery, vector);
        } else {
            session.executeQuery(dataModifyQuery);
        }
    }

    protected Vector createArguments(DatabaseQuery databaseQuery, String string, Number number) {
        int n = databaseQuery.getArguments().size();
        if (n > 0) {
            Vector<Object> vector = new Vector<Object>(n);
            vector.addElement(string);
            if (n > 1) {
                vector.addElement(number);
            }
            return vector;
        }
        return null;
    }
}

