/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.sdk;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;
import oracle.toplink.internal.helper.Helper;

public class SDKFieldValue {
    protected Vector elements;
    protected String elementDataTypeName;
    protected boolean isDirectCollection;

    public SDKFieldValue() {
        this.initialize();
    }

    public SDKFieldValue(Vector vector, String string, boolean bl) {
        this.initialize(vector, string, bl);
    }

    public void addElement(Object object) {
        this.getElements().addElement(object);
    }

    public SDKFieldValue clone(Vector vector) {
        return new SDKFieldValue(vector, this.getElementDataTypeName(), this.isDirectCollection());
    }

    public static SDKFieldValue forDatabaseRows(Vector vector, String string) {
        return new SDKFieldValue(vector, string, false);
    }

    public static SDKFieldValue forDirectValues(Vector vector, String string) {
        return new SDKFieldValue(vector, string, true);
    }

    public String getElementDataTypeName() {
        return this.elementDataTypeName;
    }

    public Vector getElements() {
        return this.elements;
    }

    protected void initialize() {
        this.setElements(new Vector());
        this.setElementDataTypeName("");
        this.setIsDirectCollection(false);
    }

    protected void initialize(Vector vector, String string, boolean bl) {
        this.setElements(vector);
        this.setElementDataTypeName(string);
        this.setIsDirectCollection(bl);
    }

    public boolean isDirectCollection() {
        return this.isDirectCollection;
    }

    public void setElementDataTypeName(String string) {
        this.elementDataTypeName = string;
    }

    public void setElements(Vector vector) {
        this.elements = vector;
    }

    public void setIsDirectCollection(boolean bl) {
        this.isDirectCollection = bl;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.write(Helper.getShortClassName(this));
        printWriter.write("(");
        printWriter.write(this.getElementDataTypeName());
        printWriter.write(" - ");
        printWriter.print(this.getElements());
        printWriter.write(")");
        return stringWriter.toString();
    }
}

