/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.remotecommand;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.toplink.exceptions.CommunicationException;
import oracle.toplink.exceptions.RemoteCommandManagerException;
import oracle.toplink.internal.remotecommand.ConnectToHostCommand;
import oracle.toplink.internal.remotecommand.RemoteConnection;
import oracle.toplink.internal.security.SecurableObjectHolder;
import oracle.toplink.remotecommand.DiscoveryManager;
import oracle.toplink.remotecommand.RemoteCommandManager;
import oracle.toplink.remotecommand.ServiceId;

public abstract class TransportManager {
    protected RemoteConnection localConnection;
    protected RemoteCommandManager rcm;
    protected int namingServiceType;
    protected Hashtable localContextProperties;
    protected Hashtable remoteContextProperties;
    protected boolean shouldRemoveConnectionOnError;
    protected Hashtable connectionsToExternalServices;
    SecurableObjectHolder securableObjectHolder;
    public static final boolean DEFAULT_REMOVE_CONNECTION_ON_ERROR_MODE = true;
    public static final int JNDI_NAMING_SERVICE = 0;
    public static final int REGISTRY_NAMING_SERVICE = 1;
    public static final String DEFAULT_URL_PROTOCOL = "ormi";
    public static final String DEFAULT_IIOP_URL_PROTOCOL = "corbaname";
    public static final String DEFAULT_URL_PORT = "23791";
    public static final String DEFAULT_IIOP_URL_PORT = "5555#";
    public static final int DEFAULT_NAMING_SERVICE = 0;
    public static final String DEFAULT_CONTEXT_FACTORY = "com.evermind.server.rmi.RMIInitialContextFactory";
    public static final String DEFAULT_DEDICATED_CONNECTION_KEY = "dedicated.connection";
    public static final String DEFAULT_DEDICATED_CONNECTION_VALUE = "true";
    public static final String DEFAULT_USER_NAME = "admin";

    public abstract RemoteConnection createConnection(ServiceId var1);

    public void connectBackToRemote(RemoteConnection remoteConnection) throws Exception {
        ConnectToHostCommand connectToHostCommand = new ConnectToHostCommand();
        connectToHostCommand.setServiceId(this.rcm.getServiceId());
        remoteConnection.executeCommand(connectToHostCommand);
    }

    public RemoteConnection getConnectionToLocalHost() {
        return this.localConnection;
    }

    public abstract void createLocalConnection();

    public int getNamingServiceType() {
        return this.namingServiceType;
    }

    public void setNamingServiceType(int n) {
        this.namingServiceType = n;
    }

    public String getUserName() {
        return (String)this.getRemoteContextProperties().get("java.naming.security.principal");
    }

    public void setUserName(String string) {
        this.getRemoteContextProperties().put("java.naming.security.principal", string);
    }

    public String getPassword() {
        return (String)this.getRemoteContextProperties().get("java.naming.security.credentials");
    }

    public void setPassword(String string) {
        if (string != null) {
            this.getRemoteContextProperties().put("java.naming.security.credentials", this.encrypt(string));
        }
    }

    public void setEncryptedPassword(String string) {
        this.getRemoteContextProperties().put("java.naming.security.credentials", string);
    }

    public String getInitialContextFactoryName() {
        return (String)this.getRemoteContextProperties().get("java.naming.factory.initial");
    }

    public void setInitialContextFactoryName(String string) {
        this.getRemoteContextProperties().put("java.naming.factory.initial", string);
    }

    public Context getContext(Hashtable hashtable) {
        try {
            return new InitialContext(hashtable);
        }
        catch (NamingException namingException) {
            this.rcm.handleException(RemoteCommandManagerException.errorObtainingContext(hashtable.toString(), namingException));
            return null;
        }
    }

    public Hashtable getRemoteContextProperties() {
        return this.remoteContextProperties;
    }

    public void setRemoteContextProperties(Hashtable hashtable) {
        this.remoteContextProperties = hashtable;
    }

    public Hashtable getLocalContextProperties() {
        if (this.localContextProperties == null) {
            this.localContextProperties = new Hashtable();
        }
        return this.localContextProperties;
    }

    public void setLocalContextProperties(Hashtable hashtable) {
        this.localContextProperties = hashtable;
    }

    public RemoteCommandManager getRemoteCommandManager() {
        return this.rcm;
    }

    public void addConnectionToExternalService(RemoteConnection remoteConnection) {
        block5: {
            if (remoteConnection == null) {
                return;
            }
            try {
                this.connectBackToRemote(remoteConnection);
                this.connectionsToExternalServices.put(remoteConnection.getServiceId().getId(), remoteConnection);
                Object[] objectArray = new Object[]{remoteConnection.getServiceId()};
                this.rcm.logDebug("received_connection_from", objectArray);
            }
            catch (Exception exception) {
                try {
                    this.rcm.handleException(CommunicationException.errorSendingConnectionService(remoteConnection.toString(), exception));
                }
                catch (RuntimeException runtimeException) {
                    Object[] objectArray = new Object[]{remoteConnection.getServiceId(), runtimeException};
                    this.rcm.logWarning("problem_adding_connection", objectArray);
                    if (this.shouldRemoveConnectionOnError) break block5;
                    throw runtimeException;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionToExternalService(RemoteConnection remoteConnection) {
        Hashtable hashtable = this.connectionsToExternalServices;
        synchronized (hashtable) {
            this.connectionsToExternalServices.remove(remoteConnection.getServiceId().getId());
            remoteConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllConnectionsToExternalServices() {
        Hashtable hashtable = this.connectionsToExternalServices;
        synchronized (hashtable) {
            Enumeration enumeration = this.connectionsToExternalServices.elements();
            this.connectionsToExternalServices = new Hashtable(3);
            while (enumeration.hasMoreElements()) {
                ((RemoteConnection)enumeration.nextElement()).close();
            }
        }
    }

    public Hashtable getConnectionsToExternalServices() {
        return this.connectionsToExternalServices;
    }

    public void setShouldRemoveConnectionOnError(boolean bl) {
        this.shouldRemoveConnectionOnError = bl;
    }

    public boolean shouldRemoveConnectionOnError() {
        return this.shouldRemoveConnectionOnError;
    }

    public void setEncryptionClassName(String string) {
        String string2 = null;
        if (this.getPassword() != null) {
            string2 = this.decrypt(this.getPassword());
        }
        this.securableObjectHolder = new SecurableObjectHolder();
        this.securableObjectHolder.setEncryptionClassName(string);
        this.setPassword(string2);
    }

    public void initialize() {
        this.shouldRemoveConnectionOnError = true;
        this.connectionsToExternalServices = new Hashtable(2);
        this.remoteContextProperties = new Hashtable();
        this.remoteContextProperties.put("java.naming.factory.initial", DEFAULT_CONTEXT_FACTORY);
        this.remoteContextProperties.put(DEFAULT_DEDICATED_CONNECTION_KEY, DEFAULT_DEDICATED_CONNECTION_VALUE);
        this.remoteContextProperties.put("java.naming.security.principal", DEFAULT_USER_NAME);
        this.securableObjectHolder = new SecurableObjectHolder();
    }

    protected String encrypt(String string) {
        return this.securableObjectHolder.getSecurableObject().encryptPassword(string);
    }

    protected String decrypt(String string) {
        return this.securableObjectHolder.getSecurableObject().decryptPassword(string);
    }

    public Context getRemoteHostContext(String string) {
        Hashtable hashtable = (Hashtable)this.getRemoteContextProperties().clone();
        hashtable.put("java.naming.provider.url", string);
        Object[] objectArray = new Object[]{hashtable};
        this.rcm.logDebug("context_props_for_remote_lookup", objectArray);
        hashtable.put("java.naming.security.credentials", this.decrypt(this.getPassword()));
        return this.getContext(hashtable);
    }

    public DiscoveryManager createDiscoveryManager() {
        return new DiscoveryManager(this.rcm);
    }

    public void discardConnections() {
        this.removeLocalConnection();
        this.removeAllConnectionsToExternalServices();
    }

    public abstract void removeLocalConnection();
}

