/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.remotecommand;

import java.io.IOException;
import oracle.toplink.exceptions.CommunicationException;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.sessions.MergeManager;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.remotecommand.Command;

public class MergeChangeSetCommand
extends Command {
    protected transient UnitOfWorkChangeSet changeSet;
    protected byte[] changeSetBytes;

    public UnitOfWorkChangeSet getChangeSet() {
        if (this.changeSet == null && this.changeSetBytes != null) {
            try {
                this.changeSet = new UnitOfWorkChangeSet(this.changeSetBytes);
            }
            catch (IOException iOException) {
                throw CommunicationException.unableToPropagateChanges(this.getServiceId().toString(), iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw CommunicationException.unableToPropagateChanges(this.getServiceId().toString(), classNotFoundException);
            }
        }
        return this.changeSet;
    }

    public void setChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet) {
        this.changeSet = unitOfWorkChangeSet;
    }

    public boolean convertChangeSetToByteArray(Session session) throws IOException {
        this.changeSetBytes = this.changeSet.getByteArrayRepresentation(session);
        return this.changeSetBytes != null;
    }

    public void executeWithSession(Session session) {
        MergeManager mergeManager = new MergeManager(session);
        mergeManager.mergeIntoDistributedCache();
        mergeManager.setCascadePolicy(3);
        mergeManager.mergeChangesFromChangeSet(this.getChangeSet());
    }

    public String getIdForSDK() {
        return Helper.getShortClassName(this.getClass());
    }

    public void setIdForSDK(String string) {
    }
}

