/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.remote.jms.mdb;

import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.toplink.exceptions.JMSProcessingException;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.remote.jms.TopLinkMessageListener;
import oracle.toplink.tools.sessionmanagement.SessionManager;

public class ClusteringMDB
implements MessageDrivenBean,
MessageListener {
    protected TopLinkMessageListener tlMessageListener;
    public final String TOPLINK_SESSION_NAME = "tl_session_name_for_mdb";
    MessageDrivenContext mdbCtx;

    public void setMessageDrivenContext(MessageDrivenContext messageDrivenContext) {
        this.mdbCtx = messageDrivenContext;
    }

    public void ejbCreate() {
        this.tlMessageListener = new TopLinkMessageListener(this.getSession());
    }

    public void ejbRemove() {
        this.tlMessageListener = null;
    }

    public oracle.toplink.sessions.Session getSession() {
        Session session;
        try {
            InitialContext initialContext = new InitialContext();
            Context context = (Context)initialContext.lookup("java:comp/env");
            String string = (String)context.lookup("tl_session_name_for_mdb");
            session = SessionManager.getManager().getSession(string);
        }
        catch (NamingException namingException) {
            throw JMSProcessingException.errorLookupSessionNameInCtx(namingException);
        }
        if (session == null) {
            throw JMSProcessingException.mdbFoundNoSession();
        }
        return session;
    }

    public void onMessage(Message message) {
        this.tlMessageListener.onMessage(message);
    }
}

