/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.remote.jms;

import java.net.MulticastSocket;
import java.rmi.RemoteException;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.NamingException;
import oracle.toplink.exceptions.JMSProcessingException;
import oracle.toplink.exceptions.SynchronizationException;
import oracle.toplink.internal.remote.RemoteConnection;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.remote.AbstractJNDIClusteringService;
import oracle.toplink.remote.jms.JMSConnection;
import oracle.toplink.remote.jms.JMSDistributedSessionReconnectPolicy;
import oracle.toplink.remote.jms.TopLinkMessageListener;

public class JMSClusteringService
extends AbstractJNDIClusteringService {
    protected String topicName;
    protected String connectionFactoryName;
    protected TopicConnection listeningConnection;

    public JMSClusteringService(oracle.toplink.sessions.Session session) {
        super(session);
        this.reconnectionPolicy = new JMSDistributedSessionReconnectPolicy(this);
    }

    public void connectBackToRemote(RemoteConnection remoteConnection) throws Exception {
        TopicConnectionFactory topicConnectionFactory = (TopicConnectionFactory)this.getContext(this.getInitialContextProperties()).lookup(this.getTopicConnectionFactoryName());
        Topic topic = (Topic)this.getContext(this.getInitialContextProperties()).lookup(remoteConnection.getServiceName());
        this.listeningConnection = topicConnectionFactory.createTopicConnection();
        TopicSession topicSession = this.listeningConnection.createTopicSession(false, 1);
        TopLinkMessageListener topLinkMessageListener = new TopLinkMessageListener(this.getSession());
        TopicSubscriber topicSubscriber = topicSession.createSubscriber(topic);
        topicSubscriber.setMessageListener((MessageListener)topLinkMessageListener);
        this.listeningConnection.start();
    }

    public RemoteConnection createRemoteConnection() throws JMSException, NamingException {
        TopicConnectionFactory topicConnectionFactory = (TopicConnectionFactory)this.getContext(this.getInitialContextProperties()).lookup(this.getTopicConnectionFactoryName());
        Topic topic = (Topic)this.getContext(this.getInitialContextProperties()).lookup(this.getTopicName());
        TopicConnection topicConnection = topicConnectionFactory.createTopicConnection();
        TopicSession topicSession = topicConnection.createTopicSession(false, 1);
        TopicPublisher topicPublisher = topicSession.createPublisher(topic);
        JMSConnection jMSConnection = new JMSConnection(topicSession, topicPublisher);
        jMSConnection.setServiceName(this.getTopicName());
        return jMSConnection;
    }

    public RemoteConnection createRemoteConnection(String string, String string2) {
        return null;
    }

    public void registerDispatcher() {
    }

    public void deregisterDispatcher() {
    }

    public MulticastSocket getCommunicationSocket() {
        return null;
    }

    public Object getDispatcher() throws RemoteException {
        return null;
    }

    public String getTopicConnectionFactoryName() {
        if (this.connectionFactoryName == null) {
            return "";
        }
        return this.connectionFactoryName;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void initialize() {
        this.stopListening();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.localContext = null;
        this.communicationSocket = null;
        this.start();
    }

    public void run() {
        this.setSessionId(this.buildSessionId());
        if (this.getTopicName() == null) {
            throw JMSProcessingException.noTopicSet(null);
        }
        this.retreiveRemoteSessions();
    }

    public RemoteConnection getLocalRemoteConnection() {
        return null;
    }

    public void retreiveRemoteSessions() {
        try {
            RemoteConnection remoteConnection = this.createRemoteConnection();
            this.getSession().getCacheSynchronizationManager().addRemoteConnection(remoteConnection);
        }
        catch (NamingException namingException) {
            this.getSession().handleException(SynchronizationException.errorLookingUpJMSService(this.getTopicName(), namingException));
        }
        catch (JMSException jMSException) {
            this.getSession().handleException(SynchronizationException.errorLookingUpJMSService(this.getTopicName(), (Exception)((Object)jMSException)));
        }
    }

    public void setTopicConnectionFactoryName(String string) {
        this.connectionFactoryName = string;
    }

    public void setTopicName(String string) {
        this.topicName = string;
    }

    public void stopListening() {
        this.stopListening = true;
        try {
            if (this.listeningConnection != null) {
                this.listeningConnection.close();
            }
        }
        catch (JMSException jMSException) {
            ((Session)this.getSession()).log(6, "propagation", "exception_thrown_when_attempting_to_close_listening_topic_connection", (Object)jMSException);
        }
    }
}

