/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.queryframework;

import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.ModifyQuery;

public abstract class ObjectLevelModifyQuery
extends ModifyQuery {
    protected Vector primaryKey;
    protected Object object;
    protected ObjectChangeSet objectChangeSet;
    protected Object backupClone;

    public ObjectLevelModifyQuery() {
        this.cascadePolicy = 2;
    }

    public void checkDescriptor(Session session) throws QueryException {
        if (this.getDescriptor() == null) {
            if (this.getObject() == null) {
                throw QueryException.objectToModifyNotSpecified(this);
            }
            Descriptor descriptor = session.getDescriptor(this.getObject());
            if (descriptor == null) {
                throw QueryException.descriptorIsMissing(this.getObject().getClass(), this);
            }
            this.setDescriptor(descriptor);
        }
    }

    public Object executeInUnitOfWork(UnitOfWork unitOfWork, DatabaseRow databaseRow) throws DatabaseException {
        if (unitOfWork.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.illegalOperationForUnitOfWorkLifecycle(unitOfWork.getLifecycle(), "executeQuery(ObjectLevelModifyQuery)");
        }
        return this.executeInUnitOfWorkObjectLevelModifyQuery(unitOfWork, databaseRow);
    }

    protected Object executeInUnitOfWorkObjectLevelModifyQuery(UnitOfWork unitOfWork, DatabaseRow databaseRow) throws DatabaseException, OptimisticLockException {
        if (!unitOfWork.getCommitManager().isActive()) {
            throw QueryException.invalidQuery(this);
        }
        if (this.getObject() != null && unitOfWork.isClassReadOnly(this.getObject().getClass())) {
            return this.getObject();
        }
        if (unitOfWork.shouldPerformNoValidation() && unitOfWork.getUnregisteredExistingObjects().containsKey(this.getObject())) {
            return null;
        }
        return super.executeInUnitOfWork(unitOfWork, databaseRow);
    }

    public Object getBackupClone() {
        if (this.backupClone == null && this.getSession().isUnitOfWork()) {
            this.setBackupClone(((UnitOfWork)this.getSession()).getBackupCloneForCommit(this.getObject()));
        }
        return this.backupClone;
    }

    public Object getObject() {
        return this.object;
    }

    public ObjectChangeSet getObjectChangeSet() {
        return this.objectChangeSet;
    }

    public Vector getPrimaryKey() {
        return this.primaryKey;
    }

    public Class getReferenceClass() {
        if (this.getObject() == null) {
            return null;
        }
        return this.getObject().getClass();
    }

    public String getReferenceClassName() {
        return this.getReferenceClass().getName();
    }

    public boolean isObjectLevelModifyQuery() {
        return true;
    }

    protected void prepare() throws QueryException {
        this.checkDescriptor(this.getSession());
        if (this.getObject() != null) {
            this.setObject(this.getDescriptor().getObjectBuilder().unwrapObject(this.getObject(), this.getSession()));
        }
        if (this.getDescriptor().isAggregateDescriptor()) {
            throw QueryException.aggregateObjectCannotBeDeletedOrWritten(this.getDescriptor(), this);
        }
        super.prepare();
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        if (this.getObject() == null) {
            throw QueryException.objectToModifyNotSpecified(this);
        }
        this.setObject(this.getDescriptor().getObjectBuilder().unwrapObject(this.getObject(), this.getSession()));
        if (this.getPrimaryKey() == null) {
            if (this.getObjectChangeSet() != null) {
                this.setPrimaryKey(this.getObjectChangeSet().getPrimaryKeys());
            } else {
                this.setPrimaryKey(this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(this.getObject(), this.getSession()));
            }
        }
    }

    public void setBackupClone(Object object) {
        this.backupClone = object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public void setObjectChangeSet(ObjectChangeSet objectChangeSet) {
        this.objectChangeSet = objectChangeSet;
    }

    public void setPrimaryKey(Vector vector) {
        this.primaryKey = vector;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + String.valueOf(this.getObject()) + ")";
    }
}

