/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.queryframework;

import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.DescriptorQueryManager;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.WriteObjectQuery;

public class InsertObjectQuery
extends WriteObjectQuery {
    public InsertObjectQuery() {
    }

    public InsertObjectQuery(Object object) {
        this();
        this.setObject(object);
    }

    public InsertObjectQuery(Call call) {
        this();
        this.setCall(call);
    }

    public void executeCommit() throws DatabaseException {
        if (this.getRedirector() != null) {
            this.redirectQuery(this, this.session, this.translationRow);
            return;
        }
        if (this.getSession().getCommitManager().isCommitInPreModify(this.getObject())) {
            this.dontCascadeParts();
            this.getQueryMechanism().insertObjectForWrite();
            this.getSession().getCommitManager().markShallowCommit(this.object);
        } else {
            this.getQueryMechanism().insertObjectForWrite();
        }
    }

    public void executeCommitWithChangeSet() throws DatabaseException {
        this.executeCommit();
    }

    protected void prepare() {
        super.prepare();
        this.getQueryMechanism().prepareInsertObject();
    }

    protected DatabaseQuery checkForCustomQuery(Session session, DatabaseRow databaseRow) {
        this.checkDescriptor(session);
        DescriptorQueryManager descriptorQueryManager = this.getDescriptor().getQueryManager();
        if (!this.isCallQuery() && !this.isUserDefined() && descriptorQueryManager.hasInsertQuery()) {
            return descriptorQueryManager.getInsertQuery();
        }
        return null;
    }

    protected void prepareCustomQuery(DatabaseQuery databaseQuery) {
        InsertObjectQuery insertObjectQuery = (InsertObjectQuery)databaseQuery;
        insertObjectQuery.setObject(this.getObject());
        insertObjectQuery.setObjectChangeSet(this.getObjectChangeSet());
        insertObjectQuery.setCascadePolicy(this.getCascadePolicy());
        insertObjectQuery.setShouldMaintainCache(this.shouldMaintainCache());
        insertObjectQuery.setModifyRow(null);
    }

    public boolean isInsertObjectQuery() {
        return true;
    }
}

