/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.queryframework;

import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.queryframework.ContainerPolicy;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.CursoredStreamPolicy;
import oracle.toplink.queryframework.ReadQuery;
import oracle.toplink.queryframework.ScrollableCursorPolicy;
import oracle.toplink.queryframework.ValueReadQuery;

public class DataReadQuery
extends ReadQuery {
    protected ContainerPolicy containerPolicy;

    public DataReadQuery() {
        this.shouldMaintainCache = false;
        this.setContainerPolicy(ContainerPolicy.buildPolicyFor(ClassConstants.Vector_class));
    }

    public DataReadQuery(String string) {
        this();
        this.setSQLString(string);
    }

    public DataReadQuery(Call call) {
        this();
        this.setCall(call);
    }

    public void cacheResult(Object object) {
        this.setTemporaryCachedQueryResults(object);
    }

    public Object clone() {
        DataReadQuery dataReadQuery = (DataReadQuery)super.clone();
        dataReadQuery.setContainerPolicy(this.getContainerPolicy().clone(dataReadQuery));
        return dataReadQuery;
    }

    public Object execute(Session session, DatabaseRow databaseRow) throws DatabaseException {
        if (this.shouldCacheQueryResults()) {
            Object object;
            if (this.getContainerPolicy().overridesRead()) {
                throw QueryException.cannotCacheCursorResultsOnQuery(this);
            }
            if (this.isPrepared() && (object = this.getQueryResults(session, databaseRow, true)) != null) {
                return object;
            }
        }
        return super.execute(session, databaseRow);
    }

    public Object executeDatabaseQuery() throws DatabaseException {
        if (this.getContainerPolicy().overridesRead()) {
            return this.getContainerPolicy().execute();
        }
        return this.executeNonCursor();
    }

    protected Object executeNonCursor() throws DatabaseException {
        Vector vector = this.getQueryMechanism().executeSelect();
        Object object = this.getContainerPolicy().buildContainerFromVector(vector, this.getSession());
        return object;
    }

    public ContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    public boolean isDataReadQuery() {
        return true;
    }

    protected void prepare() {
        super.prepare();
        this.getContainerPolicy().prepare(this, this.getSession());
        if (this.getContainerPolicy().overridesRead()) {
            return;
        }
        this.getQueryMechanism().prepareExecuteSelect();
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        this.getContainerPolicy().prepareForExecution();
    }

    public Object remoteExecute() {
        if (this.getContainerPolicy().overridesRead()) {
            return this.getContainerPolicy().remoteExecute();
        }
        return super.remoteExecute();
    }

    public void setContainerPolicy(ContainerPolicy containerPolicy) {
        if (containerPolicy == null) {
            return;
        }
        this.containerPolicy = containerPolicy;
    }

    public void useCollectionClass(Class clazz) {
        this.setContainerPolicy(ContainerPolicy.buildPolicyFor(clazz));
    }

    public void useCursoredStream() {
        this.useCursoredStream(10, 5);
    }

    public void useCursoredStream(int n, int n2) {
        this.setContainerPolicy(new CursoredStreamPolicy(this, n, n2));
    }

    public void useCursoredStream(int n, int n2, ValueReadQuery valueReadQuery) {
        this.setContainerPolicy(new CursoredStreamPolicy(this, n, n2, valueReadQuery));
    }

    public void useScrollableCursor() {
        this.useScrollableCursor(10);
    }

    public void useScrollableCursor(int n) {
        this.setContainerPolicy(new ScrollableCursorPolicy(this, n));
    }

    public void useScrollableCursor(ScrollableCursorPolicy scrollableCursorPolicy) {
        scrollableCursorPolicy.setQuery(this);
        this.setContainerPolicy(scrollableCursorPolicy);
    }
}

