/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.platform.xml.jaxp;

import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.ox.XMLDescriptor;
import oracle.toplink.platform.xml.XMLNamespaceResolver;
import oracle.toplink.platform.xml.XMLParser;
import oracle.toplink.platform.xml.XMLPlatform;
import oracle.toplink.platform.xml.XMLPlatformException;
import oracle.toplink.platform.xml.XMLTransformer;
import oracle.toplink.platform.xml.jaxp.JAXPParser;
import oracle.toplink.platform.xml.jaxp.JAXPTransformer;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;

public class JAXPPlatform
implements XMLPlatform {
    public NodeList selectNodesAdvanced(Node node, String string, XMLNamespaceResolver xMLNamespaceResolver) throws XMLPlatformException {
        throw ValidationException.operationNotSupported("selectNodesAdvanced");
    }

    public Node selectSingleNodeAdvanced(Node node, String string, XMLNamespaceResolver xMLNamespaceResolver) throws XMLPlatformException {
        throw ValidationException.operationNotSupported("selectSingleNodeAdvanced");
    }

    public boolean isWhitespaceNode(Text text) {
        String string = text.getNodeValue();
        if (null == string) {
            return false;
        }
        return string.trim().equals("");
    }

    public XMLParser newXMLParser() {
        return new JAXPParser();
    }

    public XMLTransformer newXMLTransformer() {
        return new JAXPTransformer();
    }

    public Document createDocument() throws XMLPlatformException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.newDocument();
        }
        catch (Exception exception) {
            throw XMLPlatformException.xmlPlatformCouldNotCreateDocument(exception);
        }
    }

    public Document createDocumentWithPublicIdentifier(String string, String string2, String string3) throws XMLPlatformException {
        try {
            if (null == string2) {
                return this.createDocumentWithSystemIdentifier(string, string3);
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
            DocumentType documentType = dOMImplementation.createDocumentType(string, string2, string3);
            Document document = dOMImplementation.createDocument(null, string, documentType);
            return document;
        }
        catch (Exception exception) {
            throw XMLPlatformException.xmlPlatformCouldNotCreateDocument(exception);
        }
    }

    public Document createDocumentWithSystemIdentifier(String string, String string2) throws XMLPlatformException {
        try {
            Document document = null;
            if (null == string2) {
                document = this.createDocument();
                Element element = document.createElement(string);
                document.appendChild(element);
                return document;
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
            DocumentType documentType = dOMImplementation.createDocumentType(string, null, string2);
            document = dOMImplementation.createDocument(null, string, documentType);
            return document;
        }
        catch (Exception exception) {
            throw XMLPlatformException.xmlPlatformCouldNotCreateDocument(exception);
        }
    }

    public String resolveNamespacePrefix(Node node, String string) throws XMLPlatformException {
        Node node2;
        Attr attr;
        if (null == string ? null == node.getPrefix() : string.equals(node.getPrefix())) {
            return node.getNamespaceURI();
        }
        if (node.getNodeType() == 1 && null != (attr = (node2 = (Element)node).getAttributeNode("xmlns:" + string))) {
            return attr.getValue();
        }
        node2 = node.getParentNode();
        if (node2.getNodeType() == 1) {
            return this.resolveNamespacePrefix((Element)node2, string);
        }
        return null;
    }

    public boolean validateDocument(Document document, URL uRL, ErrorHandler errorHandler) throws XMLPlatformException {
        return true;
    }

    public boolean validate(Element element, XMLDescriptor xMLDescriptor, ErrorHandler errorHandler) throws XMLPlatformException {
        return true;
    }
}

