/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.platform.database;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.expressions.ExpressionOperator;
import oracle.toplink.internal.databaseaccess.FieldTypeDefinition;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.platform.database.DatabasePlatform;
import oracle.toplink.queryframework.ValueReadQuery;

public class MySQL4Platform
extends DatabasePlatform {
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class array$Ljava$lang$Byte;
    static /* synthetic */ Class array$Ljava$lang$Character;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$oracle$toplink$internal$expressions$FunctionExpression;

    protected void appendDate(Date date, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            writer.write(Helper.printDate(date));
            writer.write("'");
        } else {
            super.appendDate(date, writer);
        }
    }

    protected void appendTime(Time time, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            writer.write(Helper.printTime(time));
            writer.write("'");
        } else {
            super.appendTime(time, writer);
        }
    }

    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            writer.write(Helper.printTimestampWithoutNanos(timestamp));
            writer.write("'");
        } else {
            super.appendTimestamp(timestamp, writer);
        }
    }

    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            writer.write(Helper.printCalendarWithoutNanos(calendar));
            writer.write("'");
        } else {
            super.appendCalendar(calendar, writer);
        }
    }

    protected Hashtable buildFieldTypes() {
        Hashtable<Class, FieldTypeDefinition> hashtable = new Hashtable<Class, FieldTypeDefinition>();
        hashtable.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = MySQL4Platform.class$("java.lang.Boolean")) : class$java$lang$Boolean, new FieldTypeDefinition("TINYINT(1) default 0", false));
        hashtable.put(class$java$lang$Integer == null ? (class$java$lang$Integer = MySQL4Platform.class$("java.lang.Integer")) : class$java$lang$Integer, new FieldTypeDefinition("INTEGER", false));
        hashtable.put(class$java$lang$Long == null ? (class$java$lang$Long = MySQL4Platform.class$("java.lang.Long")) : class$java$lang$Long, new FieldTypeDefinition("BIGINT", false));
        hashtable.put(class$java$lang$Float == null ? (class$java$lang$Float = MySQL4Platform.class$("java.lang.Float")) : class$java$lang$Float, new FieldTypeDefinition("FLOAT", false));
        hashtable.put(class$java$lang$Double == null ? (class$java$lang$Double = MySQL4Platform.class$("java.lang.Double")) : class$java$lang$Double, new FieldTypeDefinition("DOUBLE", false));
        hashtable.put(class$java$lang$Short == null ? (class$java$lang$Short = MySQL4Platform.class$("java.lang.Short")) : class$java$lang$Short, new FieldTypeDefinition("SMALLINT", false));
        hashtable.put(class$java$lang$Byte == null ? (class$java$lang$Byte = MySQL4Platform.class$("java.lang.Byte")) : class$java$lang$Byte, new FieldTypeDefinition("TINYINT", false));
        hashtable.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = MySQL4Platform.class$("java.math.BigInteger")) : class$java$math$BigInteger, new FieldTypeDefinition("BIGINT", false));
        hashtable.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = MySQL4Platform.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new FieldTypeDefinition("DECIMAL(38)", false));
        hashtable.put(class$java$lang$String == null ? (class$java$lang$String = MySQL4Platform.class$("java.lang.String")) : class$java$lang$String, new FieldTypeDefinition("VARCHAR", 255));
        hashtable.put(class$java$lang$Character == null ? (class$java$lang$Character = MySQL4Platform.class$("java.lang.Character")) : class$java$lang$Character, new FieldTypeDefinition("CHAR", 1));
        hashtable.put(array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = MySQL4Platform.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte, new FieldTypeDefinition("BLOB", 64000));
        hashtable.put(array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = MySQL4Platform.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character, new FieldTypeDefinition("TEXT", 64000));
        hashtable.put(class$java$sql$Date == null ? (class$java$sql$Date = MySQL4Platform.class$("java.sql.Date")) : class$java$sql$Date, new FieldTypeDefinition("DATE", false));
        hashtable.put(class$java$sql$Time == null ? (class$java$sql$Time = MySQL4Platform.class$("java.sql.Time")) : class$java$sql$Time, new FieldTypeDefinition("TIME", false));
        hashtable.put(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = MySQL4Platform.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, new FieldTypeDefinition("DATETIME", false));
        return hashtable;
    }

    public ValueReadQuery buildSelectQueryForNativeSequence() {
        ValueReadQuery valueReadQuery = new ValueReadQuery();
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("SELECT LAST_INSERT_ID()");
        valueReadQuery.setSQLString(stringWriter.toString());
        return valueReadQuery;
    }

    public String getConstraintDeletionString() {
        return " DROP FOREIGN KEY ";
    }

    public String getSelectForUpdateString() {
        return " FOR UPDATE";
    }

    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery();
            this.timestampQuery.setSQLString("SELECT NOW()");
        }
        return this.timestampQuery;
    }

    public boolean isMySQL() {
        return true;
    }

    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(this.logOperator());
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(91, "ATAN2"));
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(31, "CONCAT"));
        this.addOperator(this.todayOperator());
        this.addOperator(this.toNumberOperator());
        this.addOperator(this.toCharOperator());
        this.addOperator(this.toDateOperator());
        this.addOperator(this.dateToStringOperator());
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(104, "IFNULL"));
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(75, "TRUNCATE"));
    }

    protected ExpressionOperator logOperator() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setSelector(66);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement("LOG(");
        ((Vector)nonSynchronizedVector).addElement(", 10)");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(class$oracle$toplink$internal$expressions$FunctionExpression == null ? (class$oracle$toplink$internal$expressions$FunctionExpression = MySQL4Platform.class$("oracle.toplink.internal.expressions.FunctionExpression")) : class$oracle$toplink$internal$expressions$FunctionExpression);
        return expressionOperator;
    }

    protected ExpressionOperator toNumberOperator() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(42);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement("CONVERT(");
        ((Vector)nonSynchronizedVector).addElement(", SIGNED)");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    protected ExpressionOperator toDateOperator() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(53);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement("CONVERT(");
        ((Vector)nonSynchronizedVector).addElement(", DATETIME)");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    protected ExpressionOperator toCharOperator() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(114);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement("CONVERT(");
        ((Vector)nonSynchronizedVector).addElement(", CHAR)");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    protected ExpressionOperator dateToStringOperator() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setType(5);
        expressionOperator.setSelector(48);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement("CONVERT(");
        ((Vector)nonSynchronizedVector).addElement(", CHAR)");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return expressionOperator;
    }

    protected ExpressionOperator todayOperator() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setSelector(54);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(1);
        ((Vector)nonSynchronizedVector).addElement("SYSDATE()");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePrefix();
        expressionOperator.setNodeClass(class$oracle$toplink$internal$expressions$FunctionExpression == null ? (class$oracle$toplink$internal$expressions$FunctionExpression = MySQL4Platform.class$("oracle.toplink.internal.expressions.FunctionExpression")) : class$oracle$toplink$internal$expressions$FunctionExpression);
        return expressionOperator;
    }

    public void printFieldIdentityClause(Writer writer) throws ValidationException {
        try {
            writer.write(" AUTO_INCREMENT");
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public boolean shouldNativeSequenceAcquireValueAfterInsert() {
        return true;
    }

    public boolean shouldUseJDBCOuterJoinSyntax() {
        return false;
    }

    public boolean supportsNativeSequenceNumbers() {
        return true;
    }

    public String getIdentifierQuoteCharacter() {
        return "`";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

