/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.ox.record;

import java.util.Stack;
import oracle.toplink.exceptions.XMLMarshalException;
import oracle.toplink.internal.ox.XPathFragment;
import oracle.toplink.ox.NamespaceResolver;
import oracle.toplink.ox.record.MarshalRecord;
import oracle.toplink.platform.xml.XMLPlatform;
import oracle.toplink.platform.xml.XMLPlatformFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class NodeRecord
extends MarshalRecord {
    private Document document;
    private Stack nodes;

    public NodeRecord() {
        XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        this.document = xMLPlatform.createDocument();
    }

    public NodeRecord(String string) {
        this(string, (NamespaceResolver)null);
    }

    public NodeRecord(String string, NamespaceResolver namespaceResolver) {
        this();
        String string2 = this.resolveNamespace(namespaceResolver, string);
        Element element = this.document.createElementNS(string2, string);
        this.document.appendChild(element);
        this.setDOM(element);
    }

    public NodeRecord(String string, Node node) {
        this(string, null, node);
    }

    public NodeRecord(String string, NamespaceResolver namespaceResolver, Node node) {
        this();
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        String string2 = this.resolveNamespace(namespaceResolver, string);
        Element element = document.createElementNS(string2, string);
        node.appendChild(element);
        this.setDOM(element);
    }

    public NodeRecord(Element element) {
        this();
        this.setDOM(element);
    }

    public NodeRecord(Document document) {
        this();
        this.setDOM(document.getDocumentElement());
    }

    public String getLocalName() {
        return this.getNode().getLocalName();
    }

    public String getNamespaceURI() {
        return this.getNode().getNamespaceURI();
    }

    public void clear() {
    }

    public Document getDocument() {
        return this.document;
    }

    public Element getDOM() {
        return (Element)this.nodes.peek();
    }

    private Node getNode() {
        return (Node)this.nodes.peek();
    }

    public void setDOM(Node node) {
        this.nodes = new Stack();
        if (node.getNodeType() == 9) {
            this.document = (Document)node;
        } else if (node.getNodeType() == 1 || node.getNodeType() == 11) {
            this.document = node.getOwnerDocument();
            this.nodes.push(node);
        } else {
            throw XMLMarshalException.marshalException(null);
        }
    }

    public String transformToXML() {
        return null;
    }

    public void startDocument(String string, String string2) {
    }

    public void endDocument() {
    }

    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        super.openStartElement(xPathFragment, namespaceResolver);
        String string = this.resolveNamespacePrefix(xPathFragment, namespaceResolver);
        Element element = this.getDocument().createElementNS(string, xPathFragment.getShortName());
        try {
            this.getNode().appendChild(element);
            this.nodes.push(element);
        }
        catch (Exception exception) {
            this.document.appendChild(element);
            this.setDOM(element);
            this.nodes.push(element);
        }
    }

    public void element(String string, String string2, String string3) {
        Element element = this.getDocument().createElementNS(string, string3);
        this.getNode().appendChild(element);
    }

    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String string) {
        String string2 = this.resolveNamespacePrefix(xPathFragment, namespaceResolver);
        if (this.getNode().getNodeType() == 1) {
            this.getDOM().setAttributeNS(string2, xPathFragment.getShortName(), string);
        }
    }

    public void attribute(String string, String string2, String string3, String string4) {
        if (this.getNode().getNodeType() == 1) {
            this.getDOM().setAttributeNS(string, string3, string4);
        }
    }

    public void closeStartElement() {
    }

    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.nodes.pop();
    }

    public void characters(String string) {
        Text text = this.getDocument().createTextNode(string);
        this.getNode().appendChild(text);
    }

    private String resolveNamespace(NamespaceResolver namespaceResolver, String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            if (namespaceResolver != null) {
                return namespaceResolver.resolveNamespacePrefix("");
            }
            return null;
        }
        if (namespaceResolver == null) {
            throw XMLMarshalException.namespaceResolverNotSpecified(string);
        }
        String string2 = string.substring(0, n);
        String string3 = namespaceResolver.resolveNamespacePrefix(string2);
        if (string3 == null) {
            throw XMLMarshalException.namespaceNotFound(string2);
        }
        return string3;
    }
}

