/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.mappings.foundation;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import oracle.toplink.exceptions.ConversionException;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.indirection.ValueHolderInterface;
import oracle.toplink.internal.descriptors.DescriptorIterator;
import oracle.toplink.internal.descriptors.FieldTransformation;
import oracle.toplink.internal.descriptors.InstanceVariableAttributeAccessor;
import oracle.toplink.internal.descriptors.MethodAttributeAccessor;
import oracle.toplink.internal.descriptors.MethodBasedFieldTransformation;
import oracle.toplink.internal.descriptors.TransformerBasedFieldTransformation;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.ConversionManager;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.indirection.BasicIndirectionPolicy;
import oracle.toplink.internal.indirection.ContainerIndirectionPolicy;
import oracle.toplink.internal.indirection.IndirectionPolicy;
import oracle.toplink.internal.indirection.NoIndirectionPolicy;
import oracle.toplink.internal.indirection.UnitOfWorkTransformerValueHolder;
import oracle.toplink.internal.indirection.UnitOfWorkValueHolder;
import oracle.toplink.internal.remote.RemoteValueHolder;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.internal.sessions.ChangeRecord;
import oracle.toplink.internal.sessions.MergeManager;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.internal.sessions.TransformationMappingChangeRecord;
import oracle.toplink.mappings.Association;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.transformers.AttributeTransformer;
import oracle.toplink.mappings.transformers.FieldTransformer;
import oracle.toplink.mappings.transformers.MethodBasedAttributeTransformer;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.queryframework.WriteObjectQuery;
import oracle.toplink.remote.DistributedSession;
import oracle.toplink.remote.RemoteSession;
import oracle.toplink.sessions.DatabaseRecord;
import oracle.toplink.sessions.ObjectCopyingPolicy;
import oracle.toplink.sessions.Record;

public abstract class AbstractTransformationMapping
extends DatabaseMapping {
    protected String attributeTransformerClassName;
    protected AttributeTransformer attributeTransformer;
    protected Vector fieldTransformations = NonSynchronizedVector.newInstance();
    protected Vector fieldToTransformers = NonSynchronizedVector.newInstance();
    protected boolean isMutable;
    protected IndirectionPolicy indirectionPolicy;

    public AbstractTransformationMapping() {
        this.setIsMutable(true);
        this.dontUseIndirection();
    }

    public void addFieldTransformation(DatabaseField databaseField, String string) {
        MethodBasedFieldTransformation methodBasedFieldTransformation = new MethodBasedFieldTransformation();
        methodBasedFieldTransformation.setField(databaseField);
        methodBasedFieldTransformation.setMethodName(string);
        this.getFieldTransformations().addElement(methodBasedFieldTransformation);
    }

    public void addFieldTransformation(String string, String string2) {
        this.addFieldTransformation(new DatabaseField(string), string2);
    }

    public void addFieldTransformerClassName(String string, String string2) {
        this.addFieldTransformerClassName(new DatabaseField(string), string2);
    }

    public void addFieldTransformerClassName(DatabaseField databaseField, String string) {
        TransformerBasedFieldTransformation transformerBasedFieldTransformation = new TransformerBasedFieldTransformation();
        transformerBasedFieldTransformation.setField(databaseField);
        transformerBasedFieldTransformation.setTransformerClassName(string);
        this.getFieldTransformations().addElement(transformerBasedFieldTransformation);
    }

    public void addFieldTransformer(String string, FieldTransformer fieldTransformer) {
        this.addFieldTransformer(new DatabaseField(string), fieldTransformer);
    }

    public void addFieldTransformer(DatabaseField databaseField, FieldTransformer fieldTransformer) {
        TransformerBasedFieldTransformation transformerBasedFieldTransformation = new TransformerBasedFieldTransformation(fieldTransformer);
        transformerBasedFieldTransformation.setField(databaseField);
        this.getFieldTransformations().addElement(transformerBasedFieldTransformation);
    }

    protected boolean areObjectsToBeProcessedInstantiated(Object object) {
        return this.getIndirectionPolicy().objectIsInstantiated(this.getAttributeValueFromObject(object));
    }

    public void buildBackupClone(Object object, Object object2, UnitOfWork unitOfWork) {
        if (this.isWriteOnly()) {
            return;
        }
        Object object3 = this.getAttributeValueFromObject(object);
        if (!this.isMutable()) {
            this.setAttributeValueInObject(object2, object3);
            return;
        }
        Object object4 = this.isReadOnly() ? object3 : this.getIndirectionPolicy().backupCloneAttribute(object3, object, object2, unitOfWork);
        this.setAttributeValueInObject(object2, object4);
    }

    protected DatabaseRow buildPhantomRowFrom(Object object, Session session) {
        DatabaseRecord databaseRecord = new DatabaseRecord(this.getFieldToTransformers().size());
        Enumeration enumeration = this.getFieldToTransformers().elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            DatabaseField databaseField = (DatabaseField)objectArray[0];
            FieldTransformer fieldTransformer = (FieldTransformer)objectArray[1];
            Object object2 = this.invokeFieldTransformer(databaseField, fieldTransformer, object, session);
            databaseRecord.put(databaseField, object2);
        }
        return databaseRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildShallowOriginalFromRow(DatabaseRow databaseRow, Object object, ObjectLevelReadQuery objectLevelReadQuery, Session session) {
        UnitOfWork unitOfWork = (UnitOfWork)objectLevelReadQuery.getSession();
        objectLevelReadQuery.setSession(unitOfWork.getParent());
        try {
            this.readFromRowIntoObject(databaseRow, object, objectLevelReadQuery, session);
        }
        finally {
            objectLevelReadQuery.setSession(unitOfWork);
        }
    }

    public Object buildBackupCloneForPartObject(Object object, Object object2, Object object3, UnitOfWork unitOfWork) {
        if (!this.isMutable()) {
            return object;
        }
        DatabaseRow databaseRow = this.buildPhantomRowFrom(object2, unitOfWork);
        return this.invokeAttributeTransformer(databaseRow, object3, unitOfWork);
    }

    public void buildClone(Object object, Object object2, UnitOfWork unitOfWork) {
        if (this.isWriteOnly()) {
            return;
        }
        Object object3 = this.getAttributeValueFromObject(object);
        Object object4 = this.isReadOnly() || !this.isMutable() ? object3 : this.getIndirectionPolicy().cloneAttribute(object3, object, object2, unitOfWork, false);
        this.setAttributeValueInObject(object2, object4);
    }

    public void buildCloneFromRow(DatabaseRow databaseRow, Object object, ObjectLevelReadQuery objectLevelReadQuery, UnitOfWork unitOfWork, Session session) {
        if (this.isWriteOnly()) {
            return;
        }
        Object object2 = this.readFromRowIntoObject(databaseRow, object, objectLevelReadQuery, session);
        Object object3 = this.isReadOnly() || !this.isMutable() ? object2 : this.getIndirectionPolicy().cloneAttribute(object2, null, object, unitOfWork, true);
        this.setAttributeValueInObject(object, object3);
    }

    public Object buildCloneForPartObject(Object object, Object object2, Object object3, UnitOfWork unitOfWork, boolean bl) {
        return this.buildBackupCloneForPartObject(object, object2, object3, unitOfWork);
    }

    public void buildCopy(Object object, Object object2, ObjectCopyingPolicy objectCopyingPolicy) {
        Object object3;
        if (this.isWriteOnly()) {
            return;
        }
        Object object4 = this.getAttributeValueFromObject(object2);
        if (this.isReadOnly() || !this.isMutable()) {
            object3 = object4;
        } else {
            DatabaseRow databaseRow = this.buildPhantomRowFrom(object2, objectCopyingPolicy.getSession());
            object3 = this.invokeAttributeTransformer(databaseRow, object, objectCopyingPolicy.getSession());
        }
        this.setAttributeValueInObject(object, object3);
    }

    public void cascadePerformRemoveIfRequired(Object object, UnitOfWork unitOfWork, IdentityHashtable identityHashtable) {
    }

    public void cascadeRegisterNewIfRequired(Object object, UnitOfWork unitOfWork, IdentityHashtable identityHashtable) {
    }

    public Object clone() {
        AbstractTransformationMapping abstractTransformationMapping = (AbstractTransformationMapping)super.clone();
        abstractTransformationMapping.setFieldToTransformers(NonSynchronizedVector.newInstance(this.getFieldToTransformers().size() + 1));
        Enumeration enumeration = this.getFieldToTransformers().elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = (Object[])enumeration.nextElement();
            objectArray[0] = objectArray2[0];
            objectArray[1] = objectArray2[1];
            abstractTransformationMapping.getFieldToTransformers().addElement(objectArray);
        }
        abstractTransformationMapping.setIndirectionPolicy((IndirectionPolicy)this.indirectionPolicy.clone());
        return abstractTransformationMapping;
    }

    protected Vector collectFields() {
        Vector<Object> vector = new Vector<Object>(this.getFieldToTransformers().size());
        Enumeration enumeration = this.getFieldToTransformers().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(((Object[])enumeration.nextElement())[0]);
        }
        return vector;
    }

    public ChangeRecord compareForChange(Object object, Object object2, ObjectChangeSet objectChangeSet, Session session) {
        if (this.isReadOnly() || this.isWriteOnly()) {
            return null;
        }
        Object object3 = this.getAttributeValueFromObject(object);
        Object object4 = null;
        if (object3 != null && !this.getIndirectionPolicy().objectIsInstantiated(object3)) {
            return null;
        }
        boolean bl = false;
        if (objectChangeSet.isNew()) {
            bl = true;
        } else {
            if (object2 != null) {
                object4 = this.getAttributeValueFromObject(object2);
            }
            boolean bl2 = object4 == null || this.getIndirectionPolicy().objectIsInstantiated(object4);
            Enumeration enumeration = this.getFieldToTransformers().elements();
            while (enumeration.hasMoreElements()) {
                Object[] objectArray = (Object[])enumeration.nextElement();
                DatabaseField databaseField = (DatabaseField)objectArray[0];
                FieldTransformer fieldTransformer = (FieldTransformer)objectArray[1];
                Object object5 = null;
                Object object6 = null;
                if (object != null) {
                    object5 = this.invokeFieldTransformer(databaseField, fieldTransformer, object, session);
                }
                if (bl2 && object2 != null) {
                    object6 = this.invokeFieldTransformer(databaseField, fieldTransformer, object2, session);
                }
                if (object5 == null && object6 == null || object5 != null && object5.equals(object6)) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            return this.buildChangeRecord(object, objectChangeSet, session);
        }
        return null;
    }

    public ChangeRecord buildChangeRecord(Object object, ObjectChangeSet objectChangeSet, Session session) {
        TransformationMappingChangeRecord transformationMappingChangeRecord = new TransformationMappingChangeRecord(objectChangeSet);
        transformationMappingChangeRecord.setRow(this.buildPhantomRowFrom(object, session));
        transformationMappingChangeRecord.setAttribute(this.getAttributeName());
        transformationMappingChangeRecord.setMapping(this);
        return transformationMappingChangeRecord;
    }

    public boolean compareObjects(Object object, Object object2, Session session) {
        Enumeration enumeration = this.getFieldToTransformers().elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            DatabaseField databaseField = (DatabaseField)objectArray[0];
            FieldTransformer fieldTransformer = (FieldTransformer)objectArray[1];
            Object object3 = this.invokeFieldTransformer(databaseField, fieldTransformer, object, session);
            Object object4 = this.invokeFieldTransformer(databaseField, fieldTransformer, object2, session);
            if (object3 == null && object4 == null) continue;
            if (object3 == null || object4 == null) {
                return false;
            }
            if (object3.equals(object4)) continue;
            return false;
        }
        return true;
    }

    public UnitOfWorkValueHolder createUnitOfWorkValueHolder(ValueHolderInterface valueHolderInterface, Object object, Object object2, DatabaseRow databaseRow, UnitOfWork unitOfWork, boolean bl) {
        return new UnitOfWorkTransformerValueHolder(valueHolderInterface, object, object2, this, unitOfWork);
    }

    public void dontUseIndirection() {
        this.setIndirectionPolicy(new NoIndirectionPolicy());
    }

    public void fixObjectReferences(Object object, IdentityHashtable identityHashtable, IdentityHashtable identityHashtable2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
        this.getIndirectionPolicy().fixObjectReferences(object, identityHashtable, identityHashtable2, objectLevelReadQuery, remoteSession);
    }

    public AttributeTransformer getAttributeTransformer() {
        return this.attributeTransformer;
    }

    public String getAttributeMethodName() {
        if (this.getAttributeTransformer() instanceof MethodBasedAttributeTransformer) {
            return ((MethodBasedAttributeTransformer)this.getAttributeTransformer()).getMethodName();
        }
        return null;
    }

    public String getAttributeTransformerClassName() {
        return this.attributeTransformerClassName;
    }

    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
        if (this.isWriteOnly()) {
            return null;
        }
        Object object2 = super.getAttributeValueFromObject(object);
        return this.getIndirectionPolicy().validateAttributeOfInstantiatedObject(object2);
    }

    public Vector getFieldTransformations() {
        return this.fieldTransformations;
    }

    public Vector getFieldToTransformers() {
        return this.fieldToTransformers;
    }

    public IndirectionPolicy getIndirectionPolicy() {
        return this.indirectionPolicy;
    }

    public Object getRealAttributeValueFromObject(Object object, Session session) {
        return this.getIndirectionPolicy().getRealAttributeValueFromObject(this.getAttributeValueFromObject(object));
    }

    public Object getValueFromRemoteValueHolder(RemoteValueHolder remoteValueHolder) {
        return this.getIndirectionPolicy().getValueFromRemoteValueHolder(remoteValueHolder);
    }

    public void initialize(Session session) throws DescriptorException {
        super.initialize(session);
        this.initializeAttributeTransformer(session);
        this.initializeFieldToTransformers(session);
        this.setFields(this.collectFields());
        this.getIndirectionPolicy().initialize();
    }

    protected void initializeAttributeTransformer(Session session) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        if (this.getAttributeTransformer() == null) {
            try {
                Class clazz = ConversionManager.loadClass(this.getAttributeTransformerClassName());
                Object object = PrivilegedAccessController.newInstanceFromClass(clazz);
                this.setAttributeTransformer((AttributeTransformer)object);
            }
            catch (ConversionException conversionException) {
                throw DescriptorException.attributeTransformerClassNotFound(this.getAttributeTransformerClassName(), this, conversionException);
            }
            catch (Exception exception) {
                throw DescriptorException.attributeTransformerClassInvalid(this.getAttributeTransformerClassName(), this, exception);
            }
        }
        this.getAttributeTransformer().initialize(this);
    }

    public Hashtable getFieldNameToMethodNames() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(this.getFieldTransformations().size());
        Iterator iterator = this.getFieldTransformations().iterator();
        while (iterator.hasNext()) {
            FieldTransformation fieldTransformation = (FieldTransformation)iterator.next();
            if (!(fieldTransformation instanceof MethodBasedFieldTransformation)) continue;
            hashtable.put(fieldTransformation.getField().getQualifiedName(), ((MethodBasedFieldTransformation)fieldTransformation).getMethodName());
        }
        return hashtable;
    }

    protected void initializeFieldToTransformers(Session session) throws DescriptorException {
        Object object;
        Enumeration enumeration = this.getFieldToTransformers().elements();
        while (enumeration.hasMoreElements()) {
            object = (Object[])enumeration.nextElement();
            object[0] = this.getDescriptor().buildField(((DatabaseField)object[0]).getQualifiedName());
            ((FieldTransformer)object[1]).initialize(this);
        }
        enumeration = this.getFieldTransformations().elements();
        while (enumeration.hasMoreElements()) {
            object = (FieldTransformation)enumeration.nextElement();
            DatabaseField databaseField = this.getDescriptor().buildField(((FieldTransformation)object).getField().getQualifiedName());
            String string = "MethodBasedFieldTransformer";
            FieldTransformer fieldTransformer = null;
            try {
                fieldTransformer = ((FieldTransformation)object).buildTransformer();
            }
            catch (ConversionException conversionException) {
                if (object instanceof TransformerBasedFieldTransformation) {
                    string = ((TransformerBasedFieldTransformation)object).getTransformerClassName();
                }
                throw DescriptorException.fieldTransformerClassNotFound(string, this, conversionException);
            }
            catch (Exception exception) {
                if (object instanceof TransformerBasedFieldTransformation) {
                    string = ((TransformerBasedFieldTransformation)object).getTransformerClassName();
                }
                throw DescriptorException.fieldTransformerClassInvalid(string, this, exception);
            }
            fieldTransformer.initialize(this);
            Object[] objectArray = new Object[]{databaseField, fieldTransformer};
            this.getFieldToTransformers().addElement(objectArray);
        }
    }

    public Object invokeAttributeTransformer(Record record, Object object, Session session) throws DescriptorException {
        return this.getAttributeTransformer().buildAttributeValue(record, object, session);
    }

    protected Object invokeFieldTransformer(DatabaseField databaseField, FieldTransformer fieldTransformer, Object object, Session session) throws DescriptorException {
        return fieldTransformer.buildFieldValue(object, databaseField.getName(), session);
    }

    protected Object invokeFieldTransformer(DatabaseField databaseField, Object object, Session session) {
        Enumeration enumeration = this.getFieldToTransformers().elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            if (!databaseField.equals(objectArray[0])) continue;
            return this.invokeFieldTransformer(databaseField, (FieldTransformer)objectArray[1], object, session);
        }
        return null;
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    public boolean isReadOnly() {
        if (super.isReadOnly()) {
            return true;
        }
        return this.getFieldTransformations().isEmpty() && this.getFieldToTransformers().isEmpty();
    }

    public boolean isTransformationMapping() {
        return true;
    }

    public boolean isWriteOnly() {
        return this.getAttributeName() == null && this.getAttributeTransformer() == null && this.getAttributeTransformerClassName() == null;
    }

    public void iterate(DescriptorIterator descriptorIterator) {
        Object object = this.getAttributeValueFromObject(descriptorIterator.getVisitedParent());
        this.getIndirectionPolicy().iterateOnAttributeValue(descriptorIterator, object);
    }

    public void iterateOnRealAttributeValue(DescriptorIterator descriptorIterator, Object object) {
        descriptorIterator.iteratePrimitiveForMapping(object, this);
    }

    public void mergeChangesIntoObject(Object object, ChangeRecord changeRecord, Object object2, MergeManager mergeManager) {
        if (this.isWriteOnly()) {
            return;
        }
        if (!this.isMutable()) {
            this.setRealAttributeValueInObject(object, this.getRealAttributeValueFromObject(object2, mergeManager.getSession()));
            return;
        }
        DatabaseRow databaseRow = ((TransformationMappingChangeRecord)changeRecord).getRow();
        Object object3 = this.invokeAttributeTransformer(databaseRow, object, mergeManager.getSession());
        this.setRealAttributeValueInObject(object, object3);
    }

    public void mergeIntoObject(Object object, boolean bl, Object object2, MergeManager mergeManager) {
        if (this.isWriteOnly()) {
            return;
        }
        if (mergeManager.shouldRefreshRemoteObject() && this.usesIndirection()) {
            this.getIndirectionPolicy().mergeRemoteValueHolder(object, object2, mergeManager);
            return;
        }
        if (mergeManager.shouldMergeOriginalIntoWorkingCopy() ? !this.areObjectsToBeProcessedInstantiated(object) : !this.areObjectsToBeProcessedInstantiated(object2)) {
            return;
        }
        if (bl && mergeManager.shouldMergeWorkingCopyIntoOriginal() && !this.areObjectsToBeProcessedInstantiated(object2)) {
            this.setAttributeValueInObject(object, this.getIndirectionPolicy().getOriginalIndirectionObject(this.getAttributeValueFromObject(object2), mergeManager.getSession()));
            return;
        }
        if (this.isReadOnly()) {
            this.setRealAttributeValueInObject(object, this.getRealAttributeValueFromObject(object2, mergeManager.getSession()));
            return;
        }
        if (!this.isMutable()) {
            Object object3 = this.getRealAttributeValueFromObject(object2, mergeManager.getSession());
            if (this.getDescriptor().getObjectChangePolicy().isObjectChangeTrackingPolicy()) {
                Object object4 = this.getRealAttributeValueFromObject(object, mergeManager.getSession());
                if (mergeManager.shouldMergeCloneIntoWorkingCopy() && (object4 == null && object3 != null || object4 != null && !object4.equals(object3))) {
                    this.getDescriptor().getObjectChangePolicy().raiseInternalPropertyChangeEvent(object, this.getAttributeName(), object4, object3);
                }
            }
            this.setRealAttributeValueInObject(object, object3);
            return;
        }
        DatabaseRow databaseRow = this.buildPhantomRowFrom(object2, mergeManager.getSession());
        Object object5 = this.invokeAttributeTransformer(databaseRow, object2, mergeManager.getSession());
        DatabaseRow databaseRow2 = this.buildPhantomRowFrom(object, mergeManager.getSession());
        this.setRealAttributeValueInObject(object, object5);
        if (this.getDescriptor().getObjectChangePolicy().isObjectChangeTrackingPolicy()) {
            Enumeration enumeration = databaseRow2.keys();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!mergeManager.shouldMergeCloneIntoWorkingCopy() || databaseRow.get(e).equals(databaseRow2.get(e))) continue;
                this.getDescriptor().getObjectChangePolicy().raiseInternalPropertyChangeEvent(object, this.getAttributeName(), this.invokeAttributeTransformer(databaseRow2, object2, mergeManager.getSession()), object5);
                break;
            }
        }
    }

    public void preInitialize(Session session) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        super.preInitialize(session);
        if (this.getAttributeClassification() != null && (this.getAttributeClassification().isPrimitive() || Helper.isPrimitiveWrapper(this.getAttributeClassification()) || this.getAttributeClassification().equals(ClassConstants.STRING) || this.getAttributeClassification().equals(ClassConstants.BIGDECIMAL) || this.getAttributeClassification().equals(ClassConstants.NUMBER))) {
            this.setIsMutable(false);
        }
    }

    public Object readFromReturnRowIntoObject(DatabaseRow databaseRow, Object object, ReadObjectQuery readObjectQuery, Collection collection) throws DatabaseException {
        DatabaseRecord databaseRecord = new DatabaseRecord(this.getFields().size());
        for (int i = 0; i < this.getFields().size(); ++i) {
            DatabaseField databaseField = (DatabaseField)this.getFields().elementAt(i);
            Object object2 = databaseRow.containsKey(databaseField) ? databaseRow.get(databaseField) : this.valueFromObject(object, databaseField, readObjectQuery.getSession());
            databaseRecord.add(databaseField, object2);
        }
        Object object3 = this.readFromRowIntoObject(databaseRecord, object, readObjectQuery);
        if (collection != null) {
            collection.add(this);
        }
        return object3;
    }

    public Object readFromRowIntoObject(DatabaseRow databaseRow, Object object, ObjectLevelReadQuery objectLevelReadQuery, Session session) throws DatabaseException {
        if (this.isWriteOnly()) {
            return null;
        }
        Object object2 = this.getIndirectionPolicy().valueFromMethod(object, databaseRow, objectLevelReadQuery.getSession());
        try {
            this.getAttributeAccessor().setAttributeValueInObject(object, object2);
        }
        catch (DescriptorException descriptorException) {
            descriptorException.setMapping(this);
            throw descriptorException;
        }
        return object2;
    }

    public Vector getFieldNameToMethodNameAssociations() {
        Vector<Association> vector = new Vector<Association>();
        Iterator iterator = this.getFieldTransformations().iterator();
        while (iterator.hasNext()) {
            FieldTransformation fieldTransformation = (FieldTransformation)iterator.next();
            if (!(fieldTransformation instanceof MethodBasedFieldTransformation)) continue;
            Association association = new Association();
            association.setKey(fieldTransformation.getField().getQualifiedName());
            association.setValue(((MethodBasedFieldTransformation)fieldTransformation).getMethodName());
            vector.addElement(association);
        }
        return vector;
    }

    public void setFieldNameToMethodNameAssociations(Vector vector) {
        this.setFieldTransformations(NonSynchronizedVector.newInstance(vector.size()));
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            Association association = (Association)iterator.next();
            MethodBasedFieldTransformation methodBasedFieldTransformation = new MethodBasedFieldTransformation();
            methodBasedFieldTransformation.setField(new DatabaseField((String)association.getKey()));
            methodBasedFieldTransformation.setMethodName((String)association.getValue());
            this.getFieldTransformations().addElement(methodBasedFieldTransformation);
        }
    }

    public void remoteInitialization(DistributedSession distributedSession) {
        this.setFieldToTransformers(new Vector());
        if (!this.isWriteOnly()) {
            super.remoteInitialization(distributedSession);
            this.initializeAttributeTransformer(distributedSession);
        }
        this.initializeFieldToTransformers(distributedSession);
    }

    public void setAttributeTransformer(AttributeTransformer attributeTransformer) {
        this.attributeTransformer = attributeTransformer;
        if (attributeTransformer != null && !(attributeTransformer instanceof MethodBasedAttributeTransformer)) {
            this.attributeTransformerClassName = attributeTransformer.getClass().getName();
        }
    }

    public void setAttributeTransformerClassName(String string) {
        this.attributeTransformerClassName = string;
    }

    public void setAttributeMethodName(String string) {
        if (string != null && string != "") {
            this.setAttributeTransformer(new MethodBasedAttributeTransformer(string));
        } else {
            this.setAttributeTransformer(null);
        }
    }

    public void setAttributeTransformation(String string) {
        this.setAttributeMethodName(string);
    }

    public void setAttributeValueInObject(Object object, Object object2) {
        if (this.isWriteOnly()) {
            return;
        }
        super.setAttributeValueInObject(object, object2);
    }

    public void setIsMutable(boolean bl) {
        this.isMutable = bl;
    }

    public void setRealAttributeValueInObject(Object object, Object object2) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        this.getIndirectionPolicy().setRealAttributeValueInObject(object, object2);
    }

    public void setFieldTransformations(Vector vector) {
        this.fieldTransformations = vector;
    }

    protected void setFieldToTransformers(Vector vector) {
        this.fieldToTransformers = vector;
    }

    public void setIndirectionPolicy(IndirectionPolicy indirectionPolicy) {
        this.indirectionPolicy = indirectionPolicy;
        indirectionPolicy.setMapping(this);
    }

    public void setUsesIndirection(boolean bl) {
        if (bl) {
            this.useBasicIndirection();
        } else {
            this.dontUseIndirection();
        }
    }

    public boolean shouldMergeCascadeParts(MergeManager mergeManager) {
        return mergeManager.shouldCascadeAllParts() || mergeManager.shouldCascadePrivateParts() && this.isPrivateOwned();
    }

    protected boolean shouldMergeCascadeReference(MergeManager mergeManager) {
        if (mergeManager.shouldCascadeReferences()) {
            return true;
        }
        return this.shouldMergeCascadeParts(mergeManager);
    }

    public void updateChangeRecord(Object object, Object object2, Object object3, ObjectChangeSet objectChangeSet, UnitOfWork unitOfWork) {
        TransformationMappingChangeRecord transformationMappingChangeRecord = (TransformationMappingChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (!this.isWriteOnly()) {
            if (transformationMappingChangeRecord == null) {
                objectChangeSet.addChange(this.buildChangeRecord(object, objectChangeSet, unitOfWork));
            } else {
                transformationMappingChangeRecord.setRow(this.buildPhantomRowFrom(object, unitOfWork));
            }
        }
    }

    public boolean isChangeTrackingSupported() {
        return !this.isMutable();
    }

    public void useBasicIndirection() {
        this.setIndirectionPolicy(new BasicIndirectionPolicy());
    }

    public void useContainerIndirection(Class clazz) {
        ContainerIndirectionPolicy containerIndirectionPolicy = new ContainerIndirectionPolicy();
        containerIndirectionPolicy.setContainerClass(clazz);
        this.setIndirectionPolicy(containerIndirectionPolicy);
    }

    public void useIndirection() {
        this.useBasicIndirection();
    }

    public boolean usesIndirection() {
        return this.getIndirectionPolicy().usesIndirection();
    }

    public void validateBeforeInitialization(Session session) throws DescriptorException {
        super.validateBeforeInitialization(session);
        if (this.isWriteOnly()) {
            return;
        }
        if (this.getAttributeTransformer() == null && this.getAttributeTransformerClassName() == null) {
            session.getIntegrityChecker().handleError(DescriptorException.noAttributeTransformationMethod(this));
        }
        if (this.getAttributeAccessor() instanceof InstanceVariableAttributeAccessor) {
            Class clazz = ((InstanceVariableAttributeAccessor)this.getAttributeAccessor()).getAttributeType();
            this.getIndirectionPolicy().validateDeclaredAttributeType(clazz, session.getIntegrityChecker());
        } else if (this.getAttributeAccessor() instanceof MethodAttributeAccessor) {
            Class clazz = ((MethodAttributeAccessor)this.getAttributeAccessor()).getGetMethodReturnType();
            this.getIndirectionPolicy().validateGetMethodReturnType(clazz, session.getIntegrityChecker());
            Class clazz2 = ((MethodAttributeAccessor)this.getAttributeAccessor()).getSetMethodParameterType();
            this.getIndirectionPolicy().validateSetMethodParameterType(clazz2, session.getIntegrityChecker());
        }
    }

    public Object valueFromObject(Object object, DatabaseField databaseField, Session session) {
        return this.invokeFieldTransformer(databaseField, object, session);
    }

    public void writeFromObjectIntoRow(Object object, DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly()) {
            return;
        }
        Enumeration enumeration = this.getFieldToTransformers().elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            DatabaseField databaseField = (DatabaseField)objectArray[0];
            FieldTransformer fieldTransformer = (FieldTransformer)objectArray[1];
            Object object2 = this.invokeFieldTransformer(databaseField, fieldTransformer, object, session);
            databaseRow.put(databaseField, object2);
        }
    }

    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly()) {
            return;
        }
        Enumeration enumeration = this.getFieldToTransformers().elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            DatabaseField databaseField = (DatabaseField)objectArray[0];
            Object object = ((TransformationMappingChangeRecord)changeRecord).getRow().get(databaseField);
            databaseRow.put(databaseField, object);
        }
    }

    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery writeObjectQuery, DatabaseRow databaseRow) {
        if (!this.areObjectsToBeProcessedInstantiated(writeObjectQuery.getObject())) {
            return;
        }
        if (writeObjectQuery.getSession().isUnitOfWork() && this.compareObjects(writeObjectQuery.getBackupClone(), writeObjectQuery.getObject(), writeObjectQuery.getSession())) {
            return;
        }
        this.writeFromObjectIntoRow(writeObjectQuery.getObject(), databaseRow, writeObjectQuery.getSession());
    }

    public void writeInsertFieldsIntoRow(DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly()) {
            return;
        }
        Enumeration enumeration = this.getFieldToTransformers().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)((Object[])enumeration.nextElement())[0];
            databaseRow.put(databaseField, (Object)null);
        }
    }
}

