/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.mappings.converters;

import oracle.toplink.exceptions.ConversionException;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.converters.Converter;
import oracle.toplink.mappings.foundation.AbstractDirectMapping;
import oracle.toplink.publicinterface.Session;

public class TypeConversionConverter
implements Converter {
    protected DatabaseMapping mapping;
    protected Class dataClass;
    protected String dataClassName;
    protected Class objectClass;
    protected String objectClassName;

    public TypeConversionConverter() {
    }

    public TypeConversionConverter(DatabaseMapping databaseMapping) {
        this.mapping = databaseMapping;
    }

    public Object convertDataValueToObjectValue(Object object, oracle.toplink.sessions.Session session) {
        Object object2 = object;
        if (object2 != null) {
            try {
                object2 = ((Session)session).getDatasourcePlatform().convertObject(object2, this.getDataClass());
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this.mapping, this.mapping.getDescriptor(), conversionException);
            }
            try {
                object2 = ((Session)session).getDatasourcePlatform().convertObject(object2, this.getObjectClass());
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this.mapping, this.mapping.getDescriptor(), conversionException);
            }
        }
        return object2;
    }

    public Class getObjectClass() {
        return this.objectClass;
    }

    public String getObjectClassName() {
        if (this.objectClassName == null && this.objectClass != null) {
            this.objectClassName = this.objectClass.getName();
        }
        return this.objectClassName;
    }

    public Class getDataClass() {
        return this.dataClass;
    }

    public String getDataClassName() {
        if (this.dataClassName == null && this.dataClass != null) {
            this.dataClassName = this.dataClass.getName();
        }
        return this.dataClassName;
    }

    public void setDataClass(Class clazz) {
        this.dataClass = clazz;
    }

    public void setDataClassName(String string) {
        this.dataClassName = string;
    }

    public void setObjectClass(Class clazz) {
        this.objectClass = clazz;
    }

    public void setObjectClassName(String string) {
        this.objectClassName = string;
    }

    public Object convertObjectValueToDataValue(Object object, oracle.toplink.sessions.Session session) {
        try {
            return ((Session)session).getDatasourcePlatform().convertObject(object, this.getDataClass());
        }
        catch (ConversionException conversionException) {
            throw ConversionException.couldNotBeConverted((Object)this.mapping, this.mapping.getDescriptor(), conversionException);
        }
    }

    public void initialize(DatabaseMapping databaseMapping, oracle.toplink.sessions.Session session) {
        this.mapping = databaseMapping;
        if (this.getMapping().isDirectToFieldMapping()) {
            AbstractDirectMapping abstractDirectMapping = (AbstractDirectMapping)this.getMapping();
            if (abstractDirectMapping.getFieldClassification() == null) {
                abstractDirectMapping.setFieldClassification(this.getDataClass());
            }
            if (this.getObjectClass() == null) {
                this.setObjectClass(abstractDirectMapping.getAttributeClassification());
            }
        }
    }

    protected DatabaseMapping getMapping() {
        return this.mapping;
    }

    public boolean isMutable() {
        return false;
    }
}

