/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.mappings;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.exceptions.ConversionException;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.ConversionManager;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.identitymaps.CacheKey;
import oracle.toplink.internal.sessions.ChangeRecord;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.internal.sessions.ObjectReferenceChangeRecord;
import oracle.toplink.mappings.Association;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.ObjectReferenceMapping;
import oracle.toplink.mappings.RelationalMapping;
import oracle.toplink.mappings.TypedAssociation;
import oracle.toplink.mappings.foundation.AbstractDirectMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelModifyQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadAllQuery;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.queryframework.ReadQuery;

public class VariableOneToOneMapping
extends ObjectReferenceMapping
implements RelationalMapping {
    protected DatabaseField typeField;
    protected Map sourceToTargetQueryKeyNames;
    protected Map typeIndicatorTranslation;
    protected Map typeIndicatorNameTranslation;

    public VariableOneToOneMapping() {
        this.selectionQuery = new ReadObjectQuery();
        this.sourceToTargetQueryKeyNames = new HashMap(2);
        this.typeIndicatorTranslation = new HashMap(5);
        this.typeIndicatorNameTranslation = new HashMap(5);
        this.foreignKeyFields = NonSynchronizedVector.newInstance(1);
        this.isForeignKeyRelationship = false;
    }

    public boolean isRelationalMapping() {
        return true;
    }

    public void addClassIndicator(Class clazz, Object object) {
        if (object == null) {
            object = Helper.getNullWrapper();
        }
        this.getTypeIndicatorTranslation().put(clazz, object);
        this.getTypeIndicatorTranslation().put(object, clazz);
    }

    public void addClassNameIndicator(String string, Object object) {
        if (object == null) {
            object = Helper.getNullWrapper();
        }
        this.getTypeIndicatorNameTranslation().put(string, object);
    }

    public void addForeignQueryKeyName(String string, String string2) {
        DatabaseField databaseField = new DatabaseField(string);
        this.getSourceToTargetQueryKeyNames().put(databaseField, string2);
        this.getForeignKeyFields().addElement(databaseField);
        this.setIsForeignKeyRelationship(true);
    }

    public void addTargetForeignQueryKeyName(String string, String string2) {
        DatabaseField databaseField = new DatabaseField(string2);
        this.getSourceToTargetQueryKeyNames().put(databaseField, string);
    }

    protected Object batchedValueFromRow(DatabaseRow databaseRow, ReadAllQuery readAllQuery) {
        throw QueryException.batchReadingNotSupported(this, readAllQuery);
    }

    public Object clone() {
        DatabaseField databaseField;
        VariableOneToOneMapping variableOneToOneMapping = (VariableOneToOneMapping)super.clone();
        HashMap<DatabaseField, DatabaseField> hashMap = new HashMap<DatabaseField, DatabaseField>(this.getSourceToTargetQueryKeyNames().size());
        HashMap hashMap2 = new HashMap(this.getSourceToTargetQueryKeyNames().size());
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(this.getForeignKeyFields().size());
        if (this.getTypeField() != null) {
            variableOneToOneMapping.setTypeField((DatabaseField)this.getTypeField().clone());
        }
        Object object = this.getSourceToTargetQueryKeyNames().keySet().iterator();
        while (object.hasNext()) {
            databaseField = (DatabaseField)object.next();
            DatabaseField databaseField2 = (DatabaseField)databaseField.clone();
            hashMap.put(databaseField, databaseField2);
            hashMap2.put(databaseField2, this.getSourceToTargetQueryKeyNames().get(databaseField));
        }
        object = this.getForeignKeyFields().elements();
        while (object.hasMoreElements()) {
            databaseField = (DatabaseField)object.nextElement();
            ((Vector)nonSynchronizedVector).addElement(hashMap.get(databaseField));
        }
        variableOneToOneMapping.setSourceToTargetQueryKeyFields(hashMap2);
        variableOneToOneMapping.setForeignKeyFields(nonSynchronizedVector);
        variableOneToOneMapping.setTypeIndicatorTranslation(new HashMap(this.getTypeIndicatorTranslation()));
        return variableOneToOneMapping;
    }

    protected Vector collectFields() {
        DatabaseField databaseField = this.getTypeField();
        if (databaseField != null) {
            Vector vector = (Vector)this.getForeignKeyFields().clone();
            vector.addElement(databaseField);
            return vector;
        }
        return this.getForeignKeyFields();
    }

    protected boolean compareObjectsWithoutPrivateOwned(Object object, Object object2, Session session) {
        Object object3 = this.getRealAttributeValueFromObject(object, session);
        Object object4 = this.getRealAttributeValueFromObject(object2, session);
        if (object3 == null && object4 == null) {
            return true;
        }
        if (object3 == null || object4 == null) {
            return false;
        }
        if (object3.getClass() != object4.getClass()) {
            return false;
        }
        Iterator iterator = this.getSourceToTargetQueryKeyNames().values().iterator();
        Descriptor descriptor = session.getDescriptor(object3.getClass());
        Descriptor descriptor2 = session.getDescriptor(object4.getClass());
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            DatabaseField databaseField = descriptor.getObjectBuilder().getFieldForQueryKeyName(string);
            Object object5 = descriptor.getObjectBuilder().extractValueFromObjectForField(object3, databaseField, session);
            DatabaseField databaseField2 = descriptor2.getObjectBuilder().getFieldForQueryKeyName(string);
            Object object6 = descriptor2.getObjectBuilder().extractValueFromObjectForField(object4, databaseField2, session);
            if (object5 == null && object6 == null) continue;
            if (object5 == null || object6 == null) {
                return false;
            }
            if (object5.equals(object6)) continue;
            return false;
        }
        return true;
    }

    public Vector getClassIndicatorAssociations() {
        Vector<TypedAssociation> vector = new Vector<TypedAssociation>();
        Iterator iterator = this.getTypeIndicatorNameTranslation().keySet().iterator();
        Iterator iterator2 = this.getTypeIndicatorNameTranslation().values().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof Class) {
                object = ((Class)object).getName();
            }
            Object v = iterator2.next();
            vector.addElement(new TypedAssociation(object, v));
        }
        return vector;
    }

    public Descriptor getDescriptorForTarget(Object object, Session session) {
        return session.getDescriptor(object);
    }

    public Class getFieldClassification(DatabaseField databaseField) {
        if (this.getTypeField() != null && databaseField.equals(this.getTypeField())) {
            return this.getTypeField().getType();
        }
        String string = (String)this.getSourceToTargetQueryKeyNames().get(databaseField);
        if (string == null) {
            return null;
        }
        DatabaseMapping databaseMapping = this.getReferenceDescriptor().getObjectBuilder().getMappingForAttributeName(string);
        if (databaseMapping == null || !databaseMapping.isDirectToFieldMapping()) {
            return null;
        }
        return ((AbstractDirectMapping)databaseMapping).getAttributeClassification();
    }

    public Vector getForeignKeyFieldNames() {
        Vector<String> vector = new Vector<String>(this.getForeignKeyFields().size());
        Enumeration enumeration = this.getForeignKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(((DatabaseField)enumeration.nextElement()).getQualifiedName());
        }
        return vector;
    }

    protected Object getImplementorForType(Object object, Session session) {
        if (object == null) {
            return this.getTypeIndicatorTranslation().get(Helper.getNullWrapper());
        }
        try {
            object = session.getDatasourcePlatform().convertObject(object, this.getTypeField().getType());
        }
        catch (ConversionException conversionException) {
            throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
        }
        return this.getTypeIndicatorTranslation().get(object);
    }

    public Vector getSourceToTargetQueryKeyFieldAssociations() {
        Vector<Association> vector = new Vector<Association>(this.getSourceToTargetQueryKeyNames().size());
        Iterator iterator = this.getSourceToTargetQueryKeyNames().keySet().iterator();
        Iterator iterator2 = this.getSourceToTargetQueryKeyNames().values().iterator();
        while (iterator.hasNext()) {
            String string = ((DatabaseField)iterator.next()).getQualifiedName();
            Object v = iterator2.next();
            vector.addElement(new Association(string, v));
        }
        return vector;
    }

    public Map getSourceToTargetQueryKeyNames() {
        return this.sourceToTargetQueryKeyNames;
    }

    public DatabaseField getTypeField() {
        return this.typeField;
    }

    public String getTypeFieldName() {
        if (this.getTypeField() == null) {
            return null;
        }
        return this.getTypeField().getQualifiedName();
    }

    protected Object getTypeForImplementor(Class clazz) {
        Object v = this.getTypeIndicatorTranslation().get(clazz);
        if (v == Helper.getNullWrapper()) {
            v = null;
        }
        return v;
    }

    public Map getTypeIndicatorTranslation() {
        if (this.typeIndicatorTranslation.isEmpty() && !this.typeIndicatorNameTranslation.isEmpty()) {
            Iterator iterator = this.typeIndicatorNameTranslation.keySet().iterator();
            Iterator iterator2 = this.typeIndicatorNameTranslation.values().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                Object v = iterator2.next();
                Class clazz = (Class)ConversionManager.getDefaultManager().convertObject((String)k, ClassConstants.CLASS);
                this.typeIndicatorTranslation.put(clazz, v);
                this.typeIndicatorTranslation.put(v, clazz);
            }
        }
        return this.typeIndicatorTranslation;
    }

    public Map getTypeIndicatorNameTranslation() {
        if (this.typeIndicatorNameTranslation.isEmpty() && !this.typeIndicatorTranslation.isEmpty()) {
            Iterator iterator = this.typeIndicatorTranslation.keySet().iterator();
            Iterator iterator2 = this.typeIndicatorTranslation.values().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                Object v = iterator2.next();
                if (!(k instanceof Class)) continue;
                String string = ((Class)k).getName();
                this.typeIndicatorNameTranslation.put(string, v);
            }
        }
        return this.typeIndicatorNameTranslation;
    }

    public void initialize(Session session) {
        super.initialize(session);
        this.initializeForeignKeys(session);
        this.setFields(this.collectFields());
        if (this.getTypeField() != null) {
            this.getDescriptor().buildField(this.getTypeField());
        }
        if (this.shouldInitializeSelectionCriteria()) {
            this.initializeSelectionCriteria(session);
        }
    }

    protected void initializeForeignKeys(Session session) {
        Iterator iterator = this.getSourceToTargetQueryKeyNames().keySet().iterator();
        while (iterator.hasNext()) {
            this.getDescriptor().buildField((DatabaseField)iterator.next());
        }
    }

    public void initializeSelectionCriteria(Session session) {
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        Iterator iterator = this.getSourceToTargetQueryKeyNames().keySet().iterator();
        while (iterator.hasNext()) {
            DatabaseField databaseField = (DatabaseField)iterator.next();
            String string = (String)this.getSourceToTargetQueryKeyNames().get(databaseField);
            Expression expression2 = expressionBuilder.getParameter(databaseField).equal(expressionBuilder.get(string));
            if (expression == null) {
                expression = expression2;
                continue;
            }
            expression = expression2.and(expression);
        }
        this.setSelectionCriteria(expression);
    }

    public boolean isVariableOneToOneMapping() {
        return true;
    }

    protected boolean cacheKeysAreEqual(CacheKey cacheKey, CacheKey cacheKey2) {
        return cacheKey.equals(cacheKey2) && cacheKey2.getClass().equals(cacheKey.getClass());
    }

    protected Vector getPrimaryKeyForObject(Object object, Session session) {
        return session.keyFromObject(object);
    }

    public void preInitialize(Session session) throws DescriptorException {
        super.preInitialize(session);
        if (this.getTypeIndicatorTranslation().isEmpty()) {
            return;
        }
        Class<?> clazz = null;
        Iterator iterator = this.getTypeIndicatorTranslation().values().iterator();
        while (iterator.hasNext() && clazz == null) {
            Object v = iterator.next();
            if (v == Helper.getNullWrapper() || v instanceof Class) continue;
            clazz = v.getClass();
        }
        this.getTypeField().setType(clazz);
    }

    public void rehashFieldDependancies(Session session) {
        this.setSourceToTargetQueryKeyFields(Helper.rehashMap(this.getSourceToTargetQueryKeyNames()));
    }

    public void setClassIndicatorAssociations(Vector vector) {
        this.setTypeIndicatorNameTranslation(new HashMap(vector.size() + 1));
        this.setTypeIndicatorTranslation(new HashMap(vector.size() * 2 + 1));
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Association association = (Association)enumeration.nextElement();
            Object object = association.getKey();
            if (object instanceof Class) {
                this.addClassIndicator((Class)association.getKey(), association.getValue());
                continue;
            }
            this.addClassNameIndicator((String)association.getKey(), association.getValue());
        }
    }

    public void setForeignKeyFieldNames(Vector vector) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(new DatabaseField((String)enumeration.nextElement()));
        }
        this.setForeignKeyFields(nonSynchronizedVector);
        if (!((Vector)nonSynchronizedVector).isEmpty()) {
            this.setIsForeignKeyRelationship(true);
        }
    }

    public void setForeignQueryKeyName(String string, String string2) {
        this.addForeignQueryKeyName(string, string2);
    }

    public void setSourceToTargetQueryKeyFieldAssociations(Vector vector) {
        this.setSourceToTargetQueryKeyFields(new HashMap(vector.size() + 1));
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Association association = (Association)enumeration.nextElement();
            DatabaseField databaseField = new DatabaseField((String)association.getKey());
            String string = (String)association.getValue();
            this.getSourceToTargetQueryKeyNames().put(databaseField, string);
        }
    }

    protected void setSourceToTargetQueryKeyFields(Map map) {
        this.sourceToTargetQueryKeyNames = map;
    }

    protected void setTypeField(DatabaseField databaseField) {
        this.typeField = databaseField;
    }

    public void setTypeFieldName(String string) {
        this.setTypeField(new DatabaseField(string));
    }

    protected void setTypeIndicatorTranslation(Map map) {
        this.typeIndicatorTranslation = map;
    }

    protected void setTypeIndicatorNameTranslation(Map map) {
        this.typeIndicatorNameTranslation = map;
    }

    public Object valueFromObject(Object object, DatabaseField databaseField, Session session) {
        DatabaseRow databaseRow = this.getIndirectionPolicy().extractReferenceRow(this.getAttributeValueFromObject(object));
        if (databaseRow != null) {
            Object object2 = databaseRow.get(databaseField);
            try {
                object2 = session.getDatasourcePlatform().convertObject(object2, this.getFieldClassification(databaseField));
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
            return object2;
        }
        Object object3 = this.getRealAttributeValueFromObject(object, session);
        String string = (String)this.getSourceToTargetQueryKeyNames().get(databaseField);
        Descriptor descriptor = session.getDescriptor(object3.getClass());
        DatabaseField databaseField2 = descriptor.getObjectBuilder().getTargetFieldForQueryKeyName(string);
        if (databaseField2 == null) {
            return null;
        }
        return descriptor.getObjectBuilder().extractValueFromObjectForField(object3, databaseField2, session);
    }

    public Object valueFromRow(DatabaseRow databaseRow, ObjectLevelReadQuery objectLevelReadQuery, Session session) throws DatabaseException {
        Cloneable cloneable;
        Object object = this.getFields().elements();
        while (object.hasMoreElements()) {
            cloneable = (DatabaseField)object.nextElement();
            if (databaseRow.get((DatabaseField)cloneable) != null) continue;
            return this.getIndirectionPolicy().nullValueFromRow();
        }
        if (this.getTypeField() != null) {
            if (objectLevelReadQuery.isReadAllQuery() && (((ReadAllQuery)objectLevelReadQuery).isAttributeBatchRead(this.getDescriptor(), this.getAttributeName()) || this.shouldUseBatchReading())) {
                return this.batchedValueFromRow(databaseRow, (ReadAllQuery)objectLevelReadQuery);
            }
            if (databaseRow.get(this.getTypeField()) == null) {
                return this.getIndirectionPolicy().nullValueFromRow();
            }
            object = (Class)this.getImplementorForType(databaseRow.get(this.getTypeField()), session);
            cloneable = (ReadObjectQuery)this.getSelectionQuery().clone();
            ((ObjectLevelReadQuery)cloneable).setReferenceClass((Class)object);
            ((ObjectLevelReadQuery)cloneable).setSelectionCriteria(this.getSelectionCriteria());
            ((DatabaseQuery)cloneable).setDescriptor(null);
            if (((ObjectLevelReadQuery)cloneable).isObjectLevelReadQuery() && (objectLevelReadQuery.shouldCascadeAllParts() || objectLevelReadQuery.shouldCascadePrivateParts() && this.isPrivateOwned() || objectLevelReadQuery.shouldCascadeByMapping() && this.cascadeRefresh)) {
                ((ObjectLevelReadQuery)cloneable).setShouldRefreshIdentityMapResult(objectLevelReadQuery.shouldRefreshIdentityMapResult());
                ((DatabaseQuery)cloneable).setCascadePolicy(objectLevelReadQuery.getCascadePolicy());
                ((DatabaseQuery)cloneable).setShouldMaintainCache(objectLevelReadQuery.shouldMaintainCache());
                if (objectLevelReadQuery.hasAsOfClause()) {
                    ((ObjectLevelReadQuery)cloneable).setAsOfClause(objectLevelReadQuery.getAsOfClause());
                }
                ((ReadQuery)cloneable).setQueryId(objectLevelReadQuery.getQueryId());
            }
            return this.getIndirectionPolicy().valueFromQuery((ReadQuery)cloneable, databaseRow, session);
        }
        return super.valueFromRow(databaseRow, objectLevelReadQuery, session);
    }

    protected void writeFromNullObjectIntoRow(DatabaseRow databaseRow) {
        if (this.isReadOnly()) {
            return;
        }
        if (this.isForeignKeyRelationship()) {
            Enumeration enumeration = this.getForeignKeyFields().elements();
            while (enumeration.hasMoreElements()) {
                databaseRow.put((DatabaseField)enumeration.nextElement(), (Object)null);
            }
        }
        if (this.getTypeField() != null) {
            databaseRow.put(this.getTypeField(), (Object)null);
        }
    }

    public void writeFromObjectIntoRow(Object object, DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly()) {
            return;
        }
        Object object2 = this.getRealAttributeValueFromObject(object, session);
        if (object2 == null) {
            this.writeFromNullObjectIntoRow(databaseRow);
        } else {
            if (this.isForeignKeyRelationship()) {
                Enumeration enumeration = this.getForeignKeyFields().elements();
                Descriptor descriptor = session.getDescriptor(object2.getClass());
                while (enumeration.hasMoreElements()) {
                    DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
                    String string = (String)this.getSourceToTargetQueryKeyNames().get(databaseField);
                    DatabaseField databaseField2 = descriptor.getObjectBuilder().getFieldForQueryKeyName(string);
                    if (databaseField2 == null) {
                        throw DescriptorException.variableOneToOneMappingIsNotDefinedProperly(this, descriptor, string);
                    }
                    Object object3 = descriptor.getObjectBuilder().extractValueFromObjectForField(object2, databaseField2, session);
                    databaseRow.put(databaseField, object3);
                }
            }
            if (this.getTypeField() != null) {
                databaseRow.put(this.getTypeField(), this.getTypeForImplementor(object2.getClass()));
            }
        }
    }

    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly()) {
            return;
        }
        ObjectChangeSet objectChangeSet = (ObjectChangeSet)((ObjectReferenceChangeRecord)changeRecord).getNewValue();
        if (objectChangeSet == null) {
            this.writeFromNullObjectIntoRow(databaseRow);
        } else {
            Object object = objectChangeSet.getUnitOfWorkClone();
            if (this.isForeignKeyRelationship()) {
                Enumeration enumeration = this.getForeignKeyFields().elements();
                Descriptor descriptor = session.getDescriptor(object.getClass());
                while (enumeration.hasMoreElements()) {
                    DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
                    String string = (String)this.getSourceToTargetQueryKeyNames().get(databaseField);
                    DatabaseField databaseField2 = descriptor.getObjectBuilder().getFieldForQueryKeyName(string);
                    if (databaseField2 == null) {
                        throw DescriptorException.variableOneToOneMappingIsNotDefinedProperly(this, descriptor, string);
                    }
                    Object object2 = descriptor.getObjectBuilder().extractValueFromObjectForField(object, databaseField2, session);
                    databaseRow.put(databaseField, object2);
                }
            }
            if (this.getTypeField() != null) {
                databaseRow.put(this.getTypeField(), this.getTypeForImplementor(object.getClass()));
            }
        }
    }

    public void writeFromObjectIntoRowForShallowInsert(Object object, DatabaseRow databaseRow, Session session) {
        this.writeFromNullObjectIntoRow(databaseRow);
    }

    public void writeFromObjectIntoRowForShallowInsertWithChangeRecord(ChangeRecord changeRecord, DatabaseRow databaseRow, Session session) {
        this.writeFromNullObjectIntoRow(databaseRow);
    }

    public void writeFromObjectIntoRowForWhereClause(ObjectLevelModifyQuery objectLevelModifyQuery, DatabaseRow databaseRow) {
        if (this.isReadOnly()) {
            return;
        }
        Object object = objectLevelModifyQuery.isDeleteObjectQuery() ? objectLevelModifyQuery.getObject() : objectLevelModifyQuery.getBackupClone();
        Object object2 = this.getRealAttributeValueFromObject(object, objectLevelModifyQuery.getSession());
        if (object2 == null) {
            this.writeFromNullObjectIntoRow(databaseRow);
        } else {
            if (this.isForeignKeyRelationship()) {
                Enumeration enumeration = this.getForeignKeyFields().elements();
                Descriptor descriptor = objectLevelModifyQuery.getSession().getDescriptor(object2.getClass());
                while (enumeration.hasMoreElements()) {
                    DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
                    String string = (String)this.getSourceToTargetQueryKeyNames().get(databaseField);
                    DatabaseField databaseField2 = descriptor.getObjectBuilder().getFieldForQueryKeyName(string);
                    if (databaseField2 == null) {
                        throw DescriptorException.variableOneToOneMappingIsNotDefinedProperly(this, descriptor, string);
                    }
                    Object object3 = descriptor.getObjectBuilder().extractValueFromObjectForField(object2, databaseField2, objectLevelModifyQuery.getSession());
                    databaseRow.put(databaseField, object3);
                }
            }
            if (this.getTypeField() != null) {
                databaseRow.put(this.getTypeField(), this.getTypeForImplementor(object2.getClass()));
            }
        }
    }

    public void writeInsertFieldsIntoRow(DatabaseRow databaseRow, Session session) {
        this.writeFromNullObjectIntoRow(databaseRow);
    }
}

