/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.mappings;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.indirection.ValueHolderInterface;
import oracle.toplink.internal.descriptors.DescriptorIterator;
import oracle.toplink.internal.descriptors.ObjectBuilder;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.identitymaps.CacheKey;
import oracle.toplink.internal.indirection.ProxyIndirectionPolicy;
import oracle.toplink.internal.indirection.UnitOfWorkQueryValueHolder;
import oracle.toplink.internal.indirection.UnitOfWorkValueHolder;
import oracle.toplink.internal.sessions.ChangeRecord;
import oracle.toplink.internal.sessions.MergeManager;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.internal.sessions.ObjectReferenceChangeRecord;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.mappings.ForeignReferenceMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.DeleteObjectQuery;
import oracle.toplink.queryframework.InsertObjectQuery;
import oracle.toplink.queryframework.ObjectLevelModifyQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.QueryByExamplePolicy;
import oracle.toplink.queryframework.WriteObjectQuery;
import oracle.toplink.remote.RemoteSession;
import oracle.toplink.sessions.ObjectCopyingPolicy;

public abstract class ObjectReferenceMapping
extends ForeignReferenceMapping {
    protected boolean isForeignKeyRelationship;
    protected Vector foreignKeyFields;

    protected ObjectReferenceMapping() {
    }

    public Object buildBackupCloneForPartObject(Object object, Object object2, Object object3, UnitOfWork unitOfWork) {
        return object;
    }

    public Object buildCloneForPartObject(Object object, Object object2, Object object3, UnitOfWork unitOfWork, boolean bl) {
        if (bl) {
            return unitOfWork.registerExistingObject(object);
        }
        return unitOfWork.registerObject(object);
    }

    public void buildCopy(Object object, Object object2, ObjectCopyingPolicy objectCopyingPolicy) {
        Object object3;
        Object object4 = this.getRealAttributeValueFromObject(object2, objectCopyingPolicy.getSession());
        if (object4 != null && (objectCopyingPolicy.shouldCascadeAllParts() || objectCopyingPolicy.shouldCascadePrivateParts() && this.isPrivateOwned())) {
            object4 = objectCopyingPolicy.getSession().copyObject(object4, objectCopyingPolicy);
        } else if (object4 != null && (object3 = objectCopyingPolicy.getCopies().get(object4)) != null) {
            object4 = object3;
        }
        this.setRealAttributeValueInObject(object, object4);
    }

    public Expression buildExpression(Object object, QueryByExamplePolicy queryByExamplePolicy, Expression expression, IdentityHashtable identityHashtable, Session session) {
        String string = this.getAttributeName();
        Object object2 = this.getRealAttributeValueFromObject(object, session);
        if (!queryByExamplePolicy.shouldIncludeInQuery(object.getClass(), string, object2)) {
            return null;
        }
        if (object2 == null) {
            Expression expression2 = expression.get(string);
            return queryByExamplePolicy.completeExpressionForNull(expression2);
        }
        ObjectBuilder objectBuilder = this.getReferenceDescriptor().getObjectBuilder();
        return objectBuilder.buildExpressionFromExample(object2, queryByExamplePolicy, expression.get(string), identityHashtable, session);
    }

    public ChangeRecord compareForChange(Object object, Object object2, ObjectChangeSet objectChangeSet, Session session) {
        Object object3 = null;
        Object object4 = null;
        object3 = this.getAttributeValueFromObject(object);
        if (!objectChangeSet.isNew() && (object4 = this.getAttributeValueFromObject(object2)) == null && object3 == null) {
            return null;
        }
        if (object3 != null && !this.getIndirectionPolicy().objectIsInstantiated(object3)) {
            return null;
        }
        Object object5 = null;
        Object object6 = null;
        if (object3 != null) {
            object5 = this.getRealAttributeValueFromObject(object, session);
        }
        if (object4 != null) {
            object6 = this.getRealAttributeValueFromObject(object2, session);
        }
        if (object5 == object6 && !objectChangeSet.isNew()) {
            return null;
        }
        ObjectReferenceChangeRecord objectReferenceChangeRecord = this.internalBuildChangeRecord(object5, objectChangeSet, session);
        if (!objectChangeSet.isNew()) {
            objectReferenceChangeRecord.setOldValue(object6);
        }
        return objectReferenceChangeRecord;
    }

    public ObjectReferenceChangeRecord internalBuildChangeRecord(Object object, ObjectChangeSet objectChangeSet, Session session) {
        ObjectReferenceChangeRecord objectReferenceChangeRecord = new ObjectReferenceChangeRecord(objectChangeSet);
        objectReferenceChangeRecord.setAttribute(this.getAttributeName());
        objectReferenceChangeRecord.setMapping(this);
        this.setNewValueInChangeRecord(object, objectReferenceChangeRecord, objectChangeSet, session);
        return objectReferenceChangeRecord;
    }

    public void setNewValueInChangeRecord(Object object, ObjectReferenceChangeRecord objectReferenceChangeRecord, ObjectChangeSet objectChangeSet, Session session) {
        if (object != null) {
            ObjectChangeSet objectChangeSet2 = this.getDescriptorForTarget(object, session).getObjectBuilder().createObjectChangeSet(object, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), session);
            objectReferenceChangeRecord.setNewValue(objectChangeSet2);
        } else {
            objectReferenceChangeRecord.setNewValue(null);
        }
    }

    protected boolean compareObjectsWithoutPrivateOwned(Object object, Object object2, Session session) {
        Object object3 = this.getRealAttributeValueFromObject(object, session);
        Object object4 = this.getRealAttributeValueFromObject(object2, session);
        if (object3 == null && object4 == null) {
            return true;
        }
        if (object3 == null || object4 == null) {
            return false;
        }
        Vector vector = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object3, session);
        Vector vector2 = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object4, session);
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            Object e2 = vector2.elementAt(i);
            if (e == null && e2 == null) continue;
            if (e == null || e2 == null) {
                return false;
            }
            if (e.equals(e2)) continue;
            return false;
        }
        return true;
    }

    protected boolean compareObjectsWithPrivateOwned(Object object, Object object2, Session session) {
        Object object3 = this.getRealAttributeValueFromObject(object, session);
        Object object4 = this.getRealAttributeValueFromObject(object2, session);
        return session.compareObjects(object3, object4);
    }

    public void fixRealObjectReferences(Object object, IdentityHashtable identityHashtable, IdentityHashtable identityHashtable2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
        Object object2 = this.getRealAttributeValueFromObject(object, remoteSession);
        object2 = this.getReferenceDescriptor().getObjectBuilder().unwrapObject(object2, remoteSession);
        ObjectLevelReadQuery objectLevelReadQuery2 = objectLevelReadQuery;
        if (!objectLevelReadQuery2.shouldMaintainCache() && (!objectLevelReadQuery2.shouldCascadeParts() || objectLevelReadQuery2.shouldCascadePrivateParts() && !this.isPrivateOwned())) {
            objectLevelReadQuery2 = null;
        }
        Object object3 = remoteSession.getObjectCorrespondingTo(object2, identityHashtable, identityHashtable2, objectLevelReadQuery2);
        object3 = this.getReferenceDescriptor().getObjectBuilder().wrapObject(object3, remoteSession);
        this.setRealAttributeValueInObject(object, object3);
    }

    public Descriptor getDescriptorForTarget(Object object, Session session) {
        return this.getReferenceDescriptor();
    }

    public Object getRealAttributeValueFromObject(Object object, Session session) {
        Object object2 = super.getRealAttributeValueFromObject(object, session);
        object2 = this.getReferenceDescriptor().getObjectBuilder().unwrapObject(object2, session);
        return object2;
    }

    public boolean isObjectReferenceMapping() {
        return true;
    }

    public void iterateOnRealAttributeValue(DescriptorIterator descriptorIterator, Object object) {
        Object object2 = this.getReferenceDescriptor().getObjectBuilder().unwrapObject(object, descriptorIterator.getSession());
        descriptorIterator.iterateReferenceObjectForMapping(object2, this);
    }

    public void mergeChangesIntoObject(Object object, ChangeRecord changeRecord, Object object2, MergeManager mergeManager) {
        ObjectChangeSet objectChangeSet;
        Object object3 = null;
        if (this.shouldMergeCascadeParts(mergeManager) && (objectChangeSet = (ObjectChangeSet)((ObjectReferenceChangeRecord)changeRecord).getNewValue()) != null) {
            if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                object3 = objectChangeSet.getTargetVersionOfSourceObject(mergeManager.getSession(), false);
                if (object3 == null && (objectChangeSet.isNew() || objectChangeSet.isAggregate()) && objectChangeSet.containsChangesFromSynchronization()) {
                    if (!mergeManager.getObjectsAlreadyMerged().containsKey(objectChangeSet)) {
                        Class clazz = objectChangeSet.getClassType(mergeManager.getSession());
                        object3 = mergeManager.getSession().getDescriptor(clazz).getObjectBuilder().buildNewInstance();
                        mergeManager.getObjectsAlreadyMerged().put(objectChangeSet, object3);
                    } else {
                        object3 = mergeManager.getObjectsAlreadyMerged().get(objectChangeSet);
                    }
                } else {
                    object3 = objectChangeSet.getTargetVersionOfSourceObject(mergeManager.getSession(), true);
                }
                if (objectChangeSet.containsChangesFromSynchronization()) {
                    mergeManager.mergeChanges(object3, objectChangeSet);
                }
                if (object3 == null) {
                    mergeManager.getSession().getIdentityMapAccessorInstance().invalidateObject(object);
                    return;
                }
            } else {
                mergeManager.mergeChanges(objectChangeSet.getUnitOfWorkClone(), objectChangeSet);
            }
        }
        if (object3 == null && ((ObjectReferenceChangeRecord)changeRecord).getNewValue() != null) {
            object3 = ((ObjectChangeSet)((ObjectReferenceChangeRecord)changeRecord).getNewValue()).getTargetVersionOfSourceObject(mergeManager.getSession());
        }
        if (this.isPrivateOwned() && object2 != null) {
            mergeManager.registerRemovedNewObjectIfRequired(this.getRealAttributeValueFromObject(object2, mergeManager.getSession()));
        }
        object3 = this.getReferenceDescriptor().getObjectBuilder().wrapObject(object3, mergeManager.getSession());
        this.setRealAttributeValueInObject(object, object3);
    }

    public void mergeIntoObject(Object object, boolean bl, Object object2, MergeManager mergeManager) {
        Object object3;
        if (bl && mergeManager.shouldMergeWorkingCopyIntoOriginal() && !this.isAttributeValueInstantiated(object2)) {
            this.setAttributeValueInObject(object, this.getIndirectionPolicy().getOriginalIndirectionObject(this.getAttributeValueFromObject(object2), mergeManager.getSession()));
            return;
        }
        if (!this.shouldMergeCascadeReference(mergeManager)) {
            return;
        }
        if (mergeManager.shouldRefreshRemoteObject() && this.usesIndirection()) {
            this.mergeRemoteValueHolder(object, object2, mergeManager);
            return;
        }
        if (mergeManager.shouldMergeOriginalIntoWorkingCopy() ? !this.isAttributeValueInstantiated(object) : !this.isAttributeValueInstantiated(object2)) {
            return;
        }
        Object object4 = this.getRealAttributeValueFromObject(object2, mergeManager.getSession());
        Object object5 = null;
        if (this.shouldMergeCascadeParts(mergeManager) && object4 != null) {
            if (mergeManager.getSession().isUnitOfWork() && ((UnitOfWork)mergeManager.getSession()).getUnitOfWorkChangeSet() != null) {
                mergeManager.mergeChanges(mergeManager.getObjectToMerge(object4), (ObjectChangeSet)((UnitOfWorkChangeSet)((UnitOfWork)mergeManager.getSession()).getUnitOfWorkChangeSet()).getObjectChangeSetForClone(object4));
            } else {
                mergeManager.mergeChanges(mergeManager.getObjectToMerge(object4), null);
            }
        }
        if (object4 != null) {
            object5 = mergeManager.getTargetVersionOfSourceObject(object4);
        }
        if (this.getDescriptor().getObjectChangePolicy().isObjectChangeTrackingPolicy() && (object3 = this.getRealAttributeValueFromObject(object, mergeManager.getSession())) != object5) {
            this.getDescriptor().getObjectChangePolicy().raiseInternalPropertyChangeEvent(object, this.getAttributeName(), object3, object5);
        }
        object5 = this.getReferenceDescriptor().getObjectBuilder().wrapObject(object5, mergeManager.getSession());
        this.setRealAttributeValueInObject(object, object5);
    }

    protected Vector collectFields() {
        return this.getForeignKeyFields();
    }

    public Vector getForeignKeyFields() {
        return this.foreignKeyFields;
    }

    protected void setForeignKeyFields(Vector vector) {
        this.foreignKeyFields = vector;
        if (!vector.isEmpty()) {
            this.setIsForeignKeyRelationship(true);
        }
    }

    public boolean isForeignKeyRelationship() {
        return this.isForeignKeyRelationship;
    }

    public void setIsForeignKeyRelationship(boolean bl) {
        this.isForeignKeyRelationship = bl;
    }

    public void preInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (this.isForeignKeyRelationship()) {
            this.insert(writeObjectQuery);
        }
    }

    protected Object readPrivateOwnedForObject(ObjectLevelModifyQuery objectLevelModifyQuery) throws DatabaseException {
        if (objectLevelModifyQuery.getSession().isUnitOfWork()) {
            if (objectLevelModifyQuery.getObjectChangeSet() != null) {
                ObjectReferenceChangeRecord objectReferenceChangeRecord = (ObjectReferenceChangeRecord)objectLevelModifyQuery.getObjectChangeSet().getChangesForAttributeNamed(this.getAttributeName());
                if (objectReferenceChangeRecord != null) {
                    return objectReferenceChangeRecord.getOldValue();
                }
            } else {
                return this.getRealAttributeValueFromObject(objectLevelModifyQuery.getBackupClone(), objectLevelModifyQuery.getSession());
            }
        }
        return null;
    }

    public void preUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        Object object;
        if (!this.isAttributeValueInstantiated(writeObjectQuery.getObject())) {
            return;
        }
        if (this.isPrivateOwned() && (object = this.readPrivateOwnedForObject(writeObjectQuery)) != null) {
            writeObjectQuery.setProperty(this, object);
        }
        if (!this.isForeignKeyRelationship()) {
            return;
        }
        this.update(writeObjectQuery);
    }

    public void postDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(deleteObjectQuery)) {
            return;
        }
        Object object = deleteObjectQuery.getProperty(this);
        if (this.isForeignKeyRelationship() && object != null) {
            deleteObjectQuery.removeProperty(this);
            if (deleteObjectQuery.isCascadeOfAggregateDelete()) {
                deleteObjectQuery.getSession().getCommitManager().addObjectToDelete(object);
            } else {
                DeleteObjectQuery deleteObjectQuery2 = new DeleteObjectQuery();
                deleteObjectQuery2.setIsExecutionClone(true);
                deleteObjectQuery2.setObject(object);
                deleteObjectQuery2.setCascadePolicy(deleteObjectQuery.getCascadePolicy());
                deleteObjectQuery.getSession().executeQuery(deleteObjectQuery2);
            }
        }
    }

    public void postInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.isForeignKeyRelationship()) {
            this.insert(writeObjectQuery);
        }
    }

    public void postUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        Object object;
        if (!this.isAttributeValueInstantiated(writeObjectQuery.getObject())) {
            return;
        }
        if (!this.isForeignKeyRelationship()) {
            this.update(writeObjectQuery);
        }
        if ((object = writeObjectQuery.getProperty(this)) == null) {
            return;
        }
        writeObjectQuery.removeProperty(this);
        if (writeObjectQuery.getObjectChangeSet() == null) {
            Object object2 = this.getRealAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
            if (object != object2) {
                CacheKey cacheKey = null;
                CacheKey cacheKey2 = new CacheKey(new Vector());
                cacheKey = new CacheKey(this.getPrimaryKeyForObject(object, writeObjectQuery.getSession()));
                if (object2 != null) {
                    cacheKey2 = new CacheKey(this.getPrimaryKeyForObject(object2, writeObjectQuery.getSession()));
                }
                if (this.cacheKeysAreEqual(cacheKey, cacheKey2)) {
                    return;
                }
            } else {
                return;
            }
        }
        if (writeObjectQuery.shouldCascadeOnlyDependentParts()) {
            writeObjectQuery.getSession().getCommitManager().addObjectToDelete(object);
        } else {
            writeObjectQuery.getSession().deleteObject(object);
        }
    }

    public void preDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        Cloneable cloneable;
        if (!this.shouldObjectModifyCascadeToParts(deleteObjectQuery)) {
            return;
        }
        Object object = this.getRealAttributeValueFromObject(deleteObjectQuery.getObject(), deleteObjectQuery.getSession());
        Object object2 = null;
        object2 = this.readPrivateOwnedForObject(deleteObjectQuery);
        if (object2 != null && object2 != object) {
            cloneable = null;
            CacheKey cacheKey = new CacheKey(new Vector());
            cloneable = new CacheKey(this.getPrimaryKeyForObject(object2, deleteObjectQuery.getSession()));
            if (object != null) {
                cacheKey = new CacheKey(this.getPrimaryKeyForObject(object, deleteObjectQuery.getSession()));
            }
            if (!this.cacheKeysAreEqual(cacheKey, (CacheKey)cloneable) && object2 != null) {
                DeleteObjectQuery deleteObjectQuery2 = new DeleteObjectQuery();
                deleteObjectQuery2.setIsExecutionClone(true);
                deleteObjectQuery2.setObject(object2);
                deleteObjectQuery2.setCascadePolicy(deleteObjectQuery.getCascadePolicy());
                deleteObjectQuery.getSession().executeQuery(deleteObjectQuery2);
            }
        }
        if (!this.isForeignKeyRelationship()) {
            if (object != null) {
                cloneable = new DeleteObjectQuery();
                cloneable.setIsExecutionClone(true);
                cloneable.setObject(object);
                cloneable.setCascadePolicy(deleteObjectQuery.getCascadePolicy());
                deleteObjectQuery.getSession().executeQuery((DatabaseQuery)cloneable);
            }
        } else if (object != null) {
            deleteObjectQuery.setProperty(this, object);
        }
    }

    public void cascadePerformRemoveIfRequired(Object object, UnitOfWork unitOfWork, IdentityHashtable identityHashtable) {
        Object object2;
        Object object3 = this.getAttributeValueFromObject(object);
        if (object3 != null && this.isCascadeRemove() && (object2 = this.getIndirectionPolicy().getRealAttributeValueFromObject(object3)) != null && !identityHashtable.contains(object2)) {
            identityHashtable.put(object2, object2);
            unitOfWork.performRemove(object2, identityHashtable);
        }
    }

    public void cascadeRegisterNewIfRequired(Object object, UnitOfWork unitOfWork, IdentityHashtable identityHashtable) {
        Object object2;
        Object object3 = this.getAttributeValueFromObject(object);
        if (object3 != null && this.isCascadePersist() && this.getIndirectionPolicy().objectIsInstantiated(object3) && (object2 = this.getIndirectionPolicy().getRealAttributeValueFromObject(object3)) != null && !identityHashtable.contains(object2)) {
            identityHashtable.put(object2, object2);
            unitOfWork.registerNewObjectForPersist(object2, identityHashtable);
        }
    }

    protected boolean cacheKeysAreEqual(CacheKey cacheKey, CacheKey cacheKey2) {
        return cacheKey.equals(cacheKey2);
    }

    protected Vector getPrimaryKeyForObject(Object object, Session session) {
        return this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object, session);
    }

    public boolean hasConstraintDependency() {
        return this.isForeignKeyRelationship();
    }

    public UnitOfWorkValueHolder createUnitOfWorkValueHolder(ValueHolderInterface valueHolderInterface, Object object, Object object2, DatabaseRow databaseRow, UnitOfWork unitOfWork, boolean bl) {
        Object object3;
        UnitOfWorkQueryValueHolder unitOfWorkQueryValueHolder = null;
        if (databaseRow == null && this.isPrimaryKeyMapping()) {
            object3 = this.extractPrimaryKeyRowForSourceObject(object, unitOfWork);
            unitOfWorkQueryValueHolder = new UnitOfWorkQueryValueHolder(valueHolderInterface, object2, this, (DatabaseRow)object3, unitOfWork);
        } else {
            unitOfWorkQueryValueHolder = new UnitOfWorkQueryValueHolder(valueHolderInterface, object2, this, databaseRow, unitOfWork);
        }
        if (bl && valueHolderInterface.isInstantiated()) {
            object3 = valueHolderInterface.getValue();
            unitOfWorkQueryValueHolder.privilegedSetValue(object3);
            unitOfWorkQueryValueHolder.setInstantiated();
        }
        return unitOfWorkQueryValueHolder;
    }

    public DatabaseRow extractPrimaryKeyRowForSourceObject(Object object, Session session) {
        DatabaseRow databaseRow = this.getDescriptor().getObjectBuilder().createRecord();
        this.writeFromObjectIntoRow(object, databaseRow, session);
        return databaseRow;
    }

    public Vector extractPrimaryKeysForReferenceObject(Object object, Session session) {
        return this.getIndirectionPolicy().extractPrimaryKeyForReferenceObject(this.getAttributeValueFromObject(object), session);
    }

    public Vector extractPrimaryKeysForReferenceObjectFromRow(DatabaseRow databaseRow) {
        return new Vector(1);
    }

    public Vector extractPrimaryKeysFromRealReferenceObject(Object object, Session session) {
        if (object == null) {
            return new Vector(1);
        }
        Object object2 = this.getReferenceDescriptor().getObjectBuilder().unwrapObject(object, session);
        return this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object2, session);
    }

    public void preInitialize(Session session) throws DescriptorException {
        super.preInitialize(session);
        if (this.getIndirectionPolicy() instanceof ProxyIndirectionPolicy && !((ProxyIndirectionPolicy)this.getIndirectionPolicy()).hasTargetInterfaces()) {
            this.useProxyIndirection();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void insert(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        Serializable serializable;
        if (!this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        Object object = this.getRealAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        if (object == null) {
            return;
        }
        ObjectChangeSet objectChangeSet = writeObjectQuery.getObjectChangeSet();
        if (objectChangeSet != null) {
            serializable = (ObjectReferenceChangeRecord)writeObjectQuery.getObjectChangeSet().getChangesForAttributeNamed(this.getAttributeName());
            if (serializable == null) return;
            objectChangeSet = (ObjectChangeSet)((ObjectReferenceChangeRecord)serializable).getNewValue();
        } else {
            serializable = null;
            if (writeObjectQuery.getSession().isUnitOfWork() && ((UnitOfWork)writeObjectQuery.getSession()).getUnitOfWorkChangeSet() != null) {
                serializable = (UnitOfWorkChangeSet)((UnitOfWork)writeObjectQuery.getSession()).getUnitOfWorkChangeSet();
                objectChangeSet = (ObjectChangeSet)((UnitOfWorkChangeSet)serializable).getObjectChangeSetForClone(object);
            }
        }
        serializable = null;
        serializable = this.isPrivateOwned() && (objectChangeSet == null || objectChangeSet.isNew()) ? new InsertObjectQuery() : new WriteObjectQuery();
        ((DatabaseQuery)serializable).setIsExecutionClone(true);
        ((ObjectLevelModifyQuery)serializable).setObject(object);
        ((ObjectLevelModifyQuery)serializable).setObjectChangeSet(objectChangeSet);
        ((DatabaseQuery)serializable).setCascadePolicy(writeObjectQuery.getCascadePolicy());
        writeObjectQuery.getSession().executeQuery((DatabaseQuery)serializable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void update(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        Serializable serializable;
        if (!this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        if (!this.isAttributeValueInstantiated(writeObjectQuery.getObject())) {
            return;
        }
        Object object = this.getRealAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        if (object == null) return;
        ObjectChangeSet objectChangeSet = writeObjectQuery.getObjectChangeSet();
        if (objectChangeSet != null) {
            serializable = (ObjectReferenceChangeRecord)writeObjectQuery.getObjectChangeSet().getChangesForAttributeNamed(this.getAttributeName());
            if (serializable == null) return;
            objectChangeSet = (ObjectChangeSet)((ObjectReferenceChangeRecord)serializable).getNewValue();
        } else {
            serializable = null;
            if (writeObjectQuery.getSession().isUnitOfWork() && ((UnitOfWork)writeObjectQuery.getSession()).getUnitOfWorkChangeSet() != null) {
                serializable = (UnitOfWorkChangeSet)((UnitOfWork)writeObjectQuery.getSession()).getUnitOfWorkChangeSet();
                objectChangeSet = (ObjectChangeSet)((UnitOfWorkChangeSet)serializable).getObjectChangeSetForClone(object);
            }
        }
        if (writeObjectQuery.shouldCascadeOnlyDependentParts() && objectChangeSet != null && !objectChangeSet.isNew()) return;
        serializable = new WriteObjectQuery();
        ((DatabaseQuery)serializable).setIsExecutionClone(true);
        ((ObjectLevelModifyQuery)serializable).setObject(object);
        ((ObjectLevelModifyQuery)serializable).setObjectChangeSet(objectChangeSet);
        ((DatabaseQuery)serializable).setCascadePolicy(writeObjectQuery.getCascadePolicy());
        writeObjectQuery.getSession().executeQuery((DatabaseQuery)serializable);
    }

    public void useProxyIndirection() {
        Class[] classArray = this.getReferenceClass().getInterfaces();
        if (!this.getReferenceClass().isInterface() && this.getReferenceClass().getSuperclass() == null) {
            this.setIndirectionPolicy(new ProxyIndirectionPolicy(classArray));
        } else {
            HashSet<Class> hashSet = new HashSet<Class>();
            if (this.getReferenceClass().getSuperclass() != null) {
                this.buildTargetInterfaces(this.getReferenceClass(), hashSet);
            }
            if (this.getReferenceClass().isInterface()) {
                hashSet.add(this.getReferenceClass());
            }
            classArray = hashSet.toArray(classArray);
            this.setIndirectionPolicy(new ProxyIndirectionPolicy(classArray));
        }
    }

    public Collection buildTargetInterfaces(Class clazz, Collection collection) {
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            collection.add(classArray[i]);
        }
        if (clazz.getSuperclass() == null) {
            return collection;
        }
        return this.buildTargetInterfaces(clazz.getSuperclass(), collection);
    }

    public void useProxyIndirection(Class[] classArray) {
        this.setIndirectionPolicy(new ProxyIndirectionPolicy(classArray));
    }

    public void useProxyIndirection(Class clazz) {
        Class[] classArray = new Class[]{clazz};
        this.setIndirectionPolicy(new ProxyIndirectionPolicy(classArray));
    }

    public boolean verifyDelete(Object object, Session session) throws DatabaseException {
        Object object2;
        if (this.isPrivateOwned() && (object2 = this.getRealAttributeValueFromObject(object, session)) != null) {
            return session.verifyDelete(object2);
        }
        return true;
    }

    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery writeObjectQuery, DatabaseRow databaseRow) {
        Object object = writeObjectQuery.getObject();
        Session session = writeObjectQuery.getSession();
        if (!this.isAttributeValueInstantiated(object)) {
            return;
        }
        if (session.isUnitOfWork() && this.compareObjectsWithoutPrivateOwned(writeObjectQuery.getBackupClone(), object, session)) {
            return;
        }
        this.writeFromObjectIntoRow(object, databaseRow, session);
    }

    public void writeFromObjectIntoRowForWhereClause(ObjectLevelModifyQuery objectLevelModifyQuery, DatabaseRow databaseRow) {
        if (this.isReadOnly()) {
            return;
        }
        if (objectLevelModifyQuery.isDeleteObjectQuery()) {
            this.writeFromObjectIntoRow(objectLevelModifyQuery.getObject(), databaseRow, objectLevelModifyQuery.getSession());
        } else if (this.isAttributeValueInstantiated(objectLevelModifyQuery.getObject())) {
            this.writeFromObjectIntoRow(objectLevelModifyQuery.getBackupClone(), databaseRow, objectLevelModifyQuery.getSession());
        } else {
            this.writeFromObjectIntoRow(objectLevelModifyQuery.getObject(), databaseRow, objectLevelModifyQuery.getSession());
        }
    }

    public boolean isChangeTrackingSupported() {
        return true;
    }

    public void updateChangeRecord(Object object, Object object2, Object object3, ObjectChangeSet objectChangeSet, UnitOfWork unitOfWork) {
        ObjectReferenceChangeRecord objectReferenceChangeRecord;
        Object object4 = object2;
        Object object5 = object3;
        if (object2 != null) {
            object4 = this.getReferenceDescriptor().getObjectBuilder().unwrapObject(object2, unitOfWork);
        }
        if (object3 != null) {
            object5 = this.getReferenceDescriptor().getObjectBuilder().unwrapObject(object3, unitOfWork);
        }
        if ((objectReferenceChangeRecord = (ObjectReferenceChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName())) == null) {
            objectReferenceChangeRecord = this.internalBuildChangeRecord(object4, objectChangeSet, unitOfWork);
            objectReferenceChangeRecord.setOldValue(object5);
            objectChangeSet.addChange(objectReferenceChangeRecord);
        } else {
            this.setNewValueInChangeRecord(object4, objectReferenceChangeRecord, objectChangeSet, unitOfWork);
        }
    }

    public ChangeRecord buildChangeRecord(Object object, ObjectChangeSet objectChangeSet, Session session) {
        return this.internalBuildChangeRecord(this.getRealAttributeValueFromObject(object, session), objectChangeSet, session);
    }
}

