/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.logging;

import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.XMLFormatter;
import oracle.toplink.logging.TopLinkLogRecord;

public class TopLinkXMLFormatter
extends XMLFormatter {
    private void a2(StringBuffer stringBuffer, int n) {
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
    }

    private void appendISO8601(StringBuffer stringBuffer, long l) {
        Date date = new Date(l);
        stringBuffer.append(date.getYear() + 1900);
        stringBuffer.append('-');
        this.a2(stringBuffer, date.getMonth() + 1);
        stringBuffer.append('-');
        this.a2(stringBuffer, date.getDate());
        stringBuffer.append('T');
        this.a2(stringBuffer, date.getHours());
        stringBuffer.append(':');
        this.a2(stringBuffer, date.getMinutes());
        stringBuffer.append(':');
        this.a2(stringBuffer, date.getSeconds());
    }

    private void escape(StringBuffer stringBuffer, String string) {
        if (string == null) {
            string = "<null>";
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            stringBuffer.append(c);
        }
    }

    public String format(LogRecord logRecord) {
        Object[] objectArray;
        StringBuffer stringBuffer;
        TopLinkLogRecord topLinkLogRecord;
        block18: {
            Object object;
            if (!(logRecord instanceof TopLinkLogRecord)) {
                return super.format(logRecord);
            }
            topLinkLogRecord = (TopLinkLogRecord)logRecord;
            stringBuffer = new StringBuffer(500);
            stringBuffer.append("<record>\n");
            if (topLinkLogRecord.shouldPrintDate()) {
                stringBuffer.append("  <date>");
                this.appendISO8601(stringBuffer, topLinkLogRecord.getMillis());
                stringBuffer.append("</date>\n");
                stringBuffer.append("  <millis>");
                stringBuffer.append(topLinkLogRecord.getMillis());
                stringBuffer.append("</millis>\n");
            }
            stringBuffer.append("  <sequence>");
            stringBuffer.append(topLinkLogRecord.getSequenceNumber());
            stringBuffer.append("</sequence>\n");
            String string = topLinkLogRecord.getLoggerName();
            if (string != null) {
                stringBuffer.append("  <logger>");
                this.escape(stringBuffer, string);
                stringBuffer.append("</logger>\n");
            }
            stringBuffer.append("  <level>");
            this.escape(stringBuffer, topLinkLogRecord.getLevel().toString());
            stringBuffer.append("</level>\n");
            if (topLinkLogRecord.getSourceClassName() != null) {
                stringBuffer.append("  <class>");
                this.escape(stringBuffer, topLinkLogRecord.getSourceClassName());
                stringBuffer.append("</class>\n");
            }
            if (topLinkLogRecord.getSourceMethodName() != null) {
                stringBuffer.append("  <method>");
                this.escape(stringBuffer, topLinkLogRecord.getSourceMethodName());
                stringBuffer.append("</method>\n");
            }
            if (topLinkLogRecord.getSessionString() != null) {
                stringBuffer.append("  <session>");
                stringBuffer.append(topLinkLogRecord.getSessionString());
                stringBuffer.append("</session>\n");
            }
            if (topLinkLogRecord.getConnection() != null) {
                stringBuffer.append("  <connection>");
                stringBuffer.append(String.valueOf(System.identityHashCode(topLinkLogRecord.getConnection())));
                stringBuffer.append("</connection>\n");
            }
            if (topLinkLogRecord.shouldPrintThread()) {
                stringBuffer.append("  <thread>");
                stringBuffer.append(topLinkLogRecord.getThreadID());
                stringBuffer.append("</thread>\n");
            }
            if (topLinkLogRecord.getMessage() != null) {
                object = this.formatMessage(topLinkLogRecord);
                stringBuffer.append("  <message>");
                this.escape(stringBuffer, (String)object);
                stringBuffer.append("</message>");
                stringBuffer.append("\n");
            }
            object = topLinkLogRecord.getResourceBundle();
            try {
                if (object == null || ((ResourceBundle)object).getString(topLinkLogRecord.getMessage()) == null) break block18;
                stringBuffer.append("  <key>");
                this.escape(stringBuffer, topLinkLogRecord.getMessage());
                stringBuffer.append("</key>\n");
                stringBuffer.append("  <catalog>");
                this.escape(stringBuffer, topLinkLogRecord.getResourceBundleName());
                stringBuffer.append("</catalog>\n");
                objectArray = topLinkLogRecord.getParameters();
                for (int i = 0; i < objectArray.length; ++i) {
                    stringBuffer.append("  <param>");
                    try {
                        this.escape(stringBuffer, objectArray[i].toString());
                    }
                    catch (Exception exception) {
                        stringBuffer.append("???");
                    }
                    stringBuffer.append("</param>\n");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (topLinkLogRecord.getThrown() != null) {
            objectArray = topLinkLogRecord.getThrown();
            stringBuffer.append("  <exception>\n");
            stringBuffer.append("    <message>");
            this.escape(stringBuffer, objectArray.toString());
            stringBuffer.append("</message>\n");
            if (topLinkLogRecord.getLevel().intValue() == Level.SEVERE.intValue() || topLinkLogRecord.getLevel().intValue() <= Level.WARNING.intValue() && topLinkLogRecord.shouldLogExceptionStackTrace()) {
                StackTraceElement[] stackTraceElementArray = objectArray.getStackTrace();
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    StackTraceElement stackTraceElement = stackTraceElementArray[i];
                    stringBuffer.append("    <frame>\n");
                    stringBuffer.append("      <class>");
                    this.escape(stringBuffer, stackTraceElement.getClassName());
                    stringBuffer.append("</class>\n");
                    stringBuffer.append("      <method>");
                    this.escape(stringBuffer, stackTraceElement.getMethodName());
                    stringBuffer.append("</method>\n");
                    if (stackTraceElement.getLineNumber() >= 0) {
                        stringBuffer.append("      <line>");
                        stringBuffer.append(stackTraceElement.getLineNumber());
                        stringBuffer.append("</line>\n");
                    }
                    stringBuffer.append("    </frame>\n");
                }
            }
            stringBuffer.append("  </exception>\n");
        }
        stringBuffer.append("</record>\n");
        return stringBuffer.toString();
    }
}

