/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.jts.was;

import com.ibm.ejs.jts.jts.Current;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.jts.AbstractExternalTransactionController;
import oracle.toplink.jts.was.WebSphereJTSSynchronization;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.sessions.ExternalTransactionController;
import org.omg.CosTransactions.Control;

public class WebSphereJTSExternalTransactionController
extends AbstractExternalTransactionController
implements ExternalTransactionController {
    protected static InitialContext context;
    protected Hashtable unitsOfWorkToTransactions = new Hashtable();

    public void beginTransaction(Session session) {
        InitialContext initialContext = null;
        UserTransaction userTransaction = null;
        try {
            initialContext = WebSphereJTSExternalTransactionController.getInitialContext();
            userTransaction = (UserTransaction)initialContext.lookup("jta/usertransaction");
            if (userTransaction.getStatus() == 6) {
                session.log(2, "transaction", "JTS_begin");
                session.setWasJTSTransactionInternallyStarted(true);
                userTransaction.begin();
            }
        }
        catch (Exception exception) {
            throw ValidationException.jtsExceptionRaised(exception);
        }
    }

    public void commitTransaction(Session session) {
        InitialContext initialContext = null;
        UserTransaction userTransaction = null;
        try {
            initialContext = WebSphereJTSExternalTransactionController.getInitialContext();
            userTransaction = (UserTransaction)initialContext.lookup("jta/usertransaction");
            if (userTransaction.getStatus() == 0) {
                session.log(2, "transaction", "JTS_commit");
                session.setWasJTSTransactionInternallyStarted(false);
                userTransaction.commit();
            }
        }
        catch (Exception exception) {
            throw ValidationException.jtsExceptionRaised(exception);
        }
    }

    public Object getExternalTransaction() throws Exception {
        Control control = Current.getCurrent().get_control();
        if (control == null) {
            return null;
        }
        return control.get_coordinator().get_transaction_name();
    }

    protected static InitialContext getInitialContext() {
        return WebSphereJTSSynchronization.getInitialContext();
    }

    public void markTransactionForRollback() {
        InitialContext initialContext = null;
        UserTransaction userTransaction = null;
        try {
            initialContext = WebSphereJTSExternalTransactionController.getInitialContext();
            userTransaction = (UserTransaction)initialContext.lookup("jta/usertransaction");
            userTransaction.setRollbackOnly();
        }
        catch (Exception exception) {
            throw ValidationException.jtsExceptionRaised(exception);
        }
    }

    public void register(UnitOfWork unitOfWork, Session session) throws Exception {
        WebSphereJTSSynchronization.register(unitOfWork, session);
    }

    public void rollbackTransaction(Session session) {
        InitialContext initialContext = null;
        try {
            initialContext = WebSphereJTSExternalTransactionController.getInitialContext();
            UserTransaction userTransaction = (UserTransaction)initialContext.lookup("jta/usertransaction");
            session.log(2, "transaction", "JTS_rollback");
            session.setWasJTSTransactionInternallyStarted(false);
            userTransaction.rollback();
        }
        catch (Exception exception) {
            throw ValidationException.jtsExceptionRaised(exception);
        }
    }

    protected void addUnitOfWork(Object object, UnitOfWork unitOfWork) {
        super.addUnitOfWork(object, unitOfWork);
        this.getUnitsOfWorkToTransactions().put(unitOfWork, object);
    }

    public Hashtable getUnitsOfWorkToTransactions() {
        return this.unitsOfWorkToTransactions;
    }

    public void removeActiveUnitOfWork(UnitOfWork unitOfWork) {
        Object v = this.getUnitsOfWorkToTransactions().get(unitOfWork);
        this.getUnitsOfWorkToTransactions().remove(unitOfWork);
        this.getUnitsOfWork().remove(v);
    }

    void setUnitsOfWorkToTransactions(Hashtable hashtable) {
        this.unitsOfWorkToTransactions = hashtable;
    }
}

