/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.jts;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.jts.AbstractExternalTransactionController;
import oracle.toplink.jts.JTSSynchronizationListener;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;

public class JTSExternalTransactionController
extends AbstractExternalTransactionController {
    public void beginTransaction(Session session) {
        try {
            if (this.getTransactionManager().getStatus() == 6) {
                session.log(2, "transaction", "JTS_begin");
                this.getTransactionManager().begin();
                session.setWasJTSTransactionInternallyStarted(true);
            }
        }
        catch (Exception exception) {
            throw ValidationException.jtsExceptionRaised(exception);
        }
    }

    public void commitTransaction(Session session) {
        try {
            if (this.getTransactionManager().getStatus() == 0) {
                session.log(2, "transaction", "JTS_commit");
                session.setWasJTSTransactionInternallyStarted(false);
                this.getTransactionManager().commit();
            }
        }
        catch (Exception exception) {
            throw ValidationException.jtsExceptionRaised(exception);
        }
    }

    public Object getExternalTransaction() throws Exception {
        if (this.getTransactionManager().getStatus() == 6) {
            return null;
        }
        return this.getTransactionManager().getTransaction();
    }

    public static Object getFromJNDI(String string) {
        InitialContext initialContext = null;
        Object object = null;
        try {
            initialContext = new InitialContext();
            object = initialContext.lookup(string);
        }
        catch (NamingException namingException) {
            throw ValidationException.jtsExceptionRaised(namingException);
        }
        finally {
            try {
                initialContext.close();
            }
            catch (NamingException namingException) {}
        }
        return object;
    }

    public void markTransactionForRollback() {
        try {
            this.getTransactionManager().setRollbackOnly();
        }
        catch (Exception exception) {
            throw ValidationException.jtsExceptionRaised(exception);
        }
    }

    public void register(UnitOfWork unitOfWork, Session session) throws Exception {
        if (this.getTransactionManager() == null) {
            throw DatabaseException.transactionManagerNotSetForJTSDriver();
        }
        JTSSynchronizationListener.register(unitOfWork, session);
    }

    public void rollbackTransaction(Session session) {
        try {
            session.log(2, "transaction", "JTS_rollback");
            session.setWasJTSTransactionInternallyStarted(false);
            if (this.getTransactionManager().getTransaction() == null) {
                return;
            }
            this.getTransactionManager().getTransaction().rollback();
        }
        catch (Exception exception) {
            throw ValidationException.jtsExceptionRaised(exception);
        }
    }

    public TransactionManager getTransactionManager() {
        return JTSSynchronizationListener.getTransactionManager();
    }
}

