/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.jndi;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.CompositeName;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.localization.ToStringLocalization;
import oracle.toplink.sessions.Connector;

public class JNDIConnector
implements Connector {
    protected DataSource dataSource;
    protected Context context;
    protected String name;
    public static final int STRING_LOOKUP = 1;
    public static final int COMPOSITE_NAME_LOOKUP = 2;
    public static final int COMPOUND_NAME_LOOKUP = 3;
    protected int lookupType = 2;

    public JNDIConnector() {
    }

    public JNDIConnector(Context context, String string) throws ValidationException {
        this(string);
        this.context = context;
    }

    public JNDIConnector(String string) {
        this.name = string;
    }

    public JNDIConnector(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            throw new InternalError("Clone failed");
        }
    }

    public Connection connect(Properties properties) throws DatabaseException, ValidationException {
        String string = properties.getProperty("user");
        String string2 = properties.getProperty("password");
        DataSource dataSource = this.getDataSource();
        if (dataSource == null) {
            try {
                dataSource = this.lookupType == 1 ? (DataSource)this.getContext().lookup(this.getName()) : (this.lookupType == 2 ? (DataSource)this.getContext().lookup(new CompositeName(this.name)) : (DataSource)this.getContext().lookup(new CompoundName(this.name, new Properties())));
                this.setDataSource(dataSource);
            }
            catch (NamingException namingException) {
                throw ValidationException.cannotAcquireDataSource(this.getName(), namingException);
            }
        }
        try {
            if (string == null || string.equalsIgnoreCase("")) {
                return dataSource.getConnection();
            }
            return dataSource.getConnection(string, string2);
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException);
        }
    }

    public Context getContext() {
        if (this.context == null) {
            try {
                this.context = new InitialContext();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return this.context;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String getName() {
        return this.name;
    }

    public String getConnectionDetails() {
        return this.getName();
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setName(String string) throws ValidationException {
        this.name = string;
    }

    public void setLookupType(int n) {
        this.lookupType = n;
    }

    public int getLookupType() {
        return this.lookupType;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + ToStringLocalization.buildMessage("datasource_name", null) + "=>" + this.getName();
    }

    public void toString(PrintWriter printWriter) {
        printWriter.print(ToStringLocalization.buildMessage("connector", null) + "=>" + Helper.getShortClassName(this.getClass()));
        printWriter.print(" ");
        printWriter.println(ToStringLocalization.buildMessage("datasource_name", null) + "=>" + this.getName());
    }
}

