/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.sequencing;

import java.util.Iterator;
import oracle.toplink.internal.sequencing.Sequencing;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.sessionbroker.SessionBroker;

class SessionBrokerSequencing
implements Sequencing {
    protected SessionBroker broker;
    protected int whenShouldAcquireValueForAll;

    public static boolean atLeastOneSessionHasSequencing(SessionBroker sessionBroker) {
        boolean bl = false;
        Iterator iterator = sessionBroker.getSessionsByName().values().iterator();
        while (iterator.hasNext() && !bl) {
            Session session = (Session)iterator.next();
            bl = session.getSequencing() != null;
        }
        return bl;
    }

    public SessionBrokerSequencing(SessionBroker sessionBroker) {
        this.broker = sessionBroker;
        this.initialize();
    }

    protected void initialize() {
        this.whenShouldAcquireValueForAll = 0;
        boolean bl = true;
        Iterator iterator = this.broker.getSessionsByName().values().iterator();
        while ((bl || this.whenShouldAcquireValueForAll != 0) && iterator.hasNext()) {
            Session session = (Session)iterator.next();
            Sequencing sequencing = session.getSequencing();
            if (sequencing == null) continue;
            if (bl) {
                this.whenShouldAcquireValueForAll = sequencing.whenShouldAcquireValueForAll();
                bl = false;
                continue;
            }
            if (this.whenShouldAcquireValueForAll == sequencing.whenShouldAcquireValueForAll()) continue;
            this.whenShouldAcquireValueForAll = 0;
        }
    }

    protected Sequencing get(Class clazz) {
        return this.broker.getSessionForClass(clazz).getSequencing();
    }

    public boolean shouldAcquireValueAfterInsert(Class clazz) {
        if (this.whenShouldAcquireValueForAll == -1) {
            return false;
        }
        if (this.whenShouldAcquireValueForAll == 1) {
            return true;
        }
        return this.get(clazz).shouldAcquireValueAfterInsert(clazz);
    }

    public int whenShouldAcquireValueForAll() {
        return this.whenShouldAcquireValueForAll;
    }

    public boolean shouldOverrideExistingValue(Class clazz, Object object) {
        return this.get(clazz).shouldOverrideExistingValue(clazz, object);
    }

    public Object getNextValue(Class clazz) {
        return this.get(clazz).getNextValue(clazz);
    }
}

