/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.sequencing;

import java.util.Hashtable;
import oracle.toplink.internal.remote.RemoteConnection;
import oracle.toplink.internal.remote.RemoteFunctionCall;
import oracle.toplink.internal.remote.SequencingFunctionCall;
import oracle.toplink.internal.sequencing.Sequencing;

class RemoteConnectionSequencing
implements Sequencing {
    protected RemoteConnection remoteConnection;
    protected Hashtable classToShouldAcquireValueAfterInsert;
    protected int whenShouldAcquireValueForAll;

    public static boolean masterSequencingExists(RemoteConnection remoteConnection) {
        return (Boolean)remoteConnection.getSequenceNumberNamed(new SequencingFunctionCall.DoesExist());
    }

    public RemoteConnectionSequencing(RemoteConnection remoteConnection) {
        this.remoteConnection = remoteConnection;
        this.whenShouldAcquireValueForAll = (Integer)this.processFunctionCall(new SequencingFunctionCall.WhenShouldAcquireValueForAll());
        if (this.whenShouldAcquireValueForAll == 0) {
            this.classToShouldAcquireValueAfterInsert = new Hashtable(20);
        }
    }

    public int whenShouldAcquireValueForAll() {
        return this.whenShouldAcquireValueForAll;
    }

    public boolean shouldAcquireValueAfterInsert(Class clazz) {
        if (this.whenShouldAcquireValueForAll == -1) {
            return false;
        }
        if (this.whenShouldAcquireValueForAll == 1) {
            return true;
        }
        Boolean bl = (Boolean)this.classToShouldAcquireValueAfterInsert.get(clazz);
        if (bl == null) {
            bl = (Boolean)this.processFunctionCall(new SequencingFunctionCall.ShouldAcquireValueAfterInsert(clazz));
            this.classToShouldAcquireValueAfterInsert.put(clazz, bl);
        }
        return bl;
    }

    public boolean shouldOverrideExistingValue(Class clazz, Object object) {
        Boolean bl = (Boolean)this.processFunctionCall(new SequencingFunctionCall.ShouldOverrideExistingValue(clazz, object));
        return bl;
    }

    public Object getNextValue(Class clazz) {
        return this.processFunctionCall(new SequencingFunctionCall.GetNextValue(clazz));
    }

    protected Object processFunctionCall(RemoteFunctionCall remoteFunctionCall) {
        return this.remoteConnection.getSequenceNumberNamed(remoteFunctionCall);
    }
}

