/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.remotecommand.jms;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import oracle.toplink.exceptions.CommunicationException;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.remotecommand.RemoteConnection;
import oracle.toplink.remotecommand.Command;
import oracle.toplink.remotecommand.RemoteCommandManager;
import oracle.toplink.remotecommand.jms.JMSTopicTransportManager;

public class JMSTopicRemoteConnection
extends RemoteConnection
implements MessageListener {
    protected RemoteCommandManager rcm;
    protected TopicPublisher publisher;
    protected TopicSession publiserSession;
    protected TopicConnection listeningConnection;

    public JMSTopicRemoteConnection(RemoteCommandManager remoteCommandManager, TopicPublisher topicPublisher, TopicSession topicSession) {
        this.serviceId = remoteCommandManager.getServiceId();
        this.rcm = remoteCommandManager;
        this.publisher = topicPublisher;
        this.publiserSession = topicSession;
    }

    public Object executeCommand(Command command) throws CommunicationException {
        try {
            ObjectMessage objectMessage = this.publiserSession.createObjectMessage();
            objectMessage.setObject((Serializable)command);
            this.publisher.publish((Message)objectMessage);
        }
        catch (JMSException jMSException) {
            if (!this.rcm.getTransportManager().shouldRemoveConnectionOnError()) {
                this.reconnect();
            }
            throw new CommunicationException(Helper.printStackTraceToString(jMSException));
        }
        return null;
    }

    public void onMessage(Message message) {
        ObjectMessage objectMessage = null;
        Command command = null;
        try {
            String string = ((Topic)message.getJMSDestination()).getTopicName();
            Object[] objectArray = new Object[]{string};
            this.rcm.logDebug("retreived_remote_message_from_JMS_topic", objectArray);
            if (message instanceof ObjectMessage) {
                objectMessage = (ObjectMessage)message;
                Serializable serializable = objectMessage.getObject();
                if (serializable instanceof Command) {
                    command = (Command)serializable;
                    if (command.getServiceId().getChannel().equals(this.serviceId.getChannel())) {
                        this.rcm.processCommandFromRemoteConnection(command);
                    }
                } else if (serializable == null) {
                    this.rcm.logWarning("retreived_null_message", objectArray);
                } else {
                    Object[] objectArray2 = new Object[]{serializable.getClass(), string};
                    this.rcm.logWarning("retreived_unknown_message_type", objectArray2);
                }
            } else {
                Object[] objectArray3 = new Object[]{message.getClass().getName(), string};
                this.rcm.logWarning("received_unexpected_message_type", objectArray3);
            }
        }
        catch (Exception exception) {
            String string = null;
            if (command != null) {
                string = Helper.getShortClassName(command);
            }
            Object[] objectArray = new Object[]{string, Helper.printStackTraceToString(exception)};
            this.rcm.logWarning("error_executing_remote_command", objectArray);
        }
    }

    public void open() throws Exception {
        this.listeningConnection.start();
    }

    public void close() {
        Object[] objectArray;
        try {
            this.publisher.close();
        }
        catch (JMSException jMSException) {
            objectArray = new Object[]{jMSException};
            this.rcm.logWarning("exception_thrown_when_attempting_to_close_connection", objectArray);
        }
        try {
            this.publiserSession.close();
        }
        catch (Exception exception) {
            objectArray = new Object[]{exception};
            this.rcm.logWarning("exception_thrown_when_attempting_to_close_connection", objectArray);
        }
        try {
            this.listeningConnection.close();
        }
        catch (Exception exception) {
            objectArray = new Object[]{exception};
            this.rcm.logWarning("exception_thrown_when_attempting_to_close_connection", objectArray);
        }
    }

    public void setListeningConnection(TopicConnection topicConnection) {
        this.listeningConnection = topicConnection;
    }

    protected void reconnect() {
        String string = ((JMSTopicTransportManager)this.rcm.getTransportManager()).getTopicName();
        Object[] objectArray = new Object[]{string};
        this.rcm.logDebug("reconnect_to_jms", objectArray);
        try {
            this.rcm.getTransportManager().createLocalConnection();
        }
        catch (Exception exception) {
            Object[] objectArray2 = new Object[]{string, exception};
            this.rcm.logWarning("problem_reconnect_to_jms", objectArray2);
        }
    }
}

