/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.parsing;

import oracle.toplink.exceptions.EJBQLException;
import oracle.toplink.internal.parsing.GenerationContext;
import oracle.toplink.internal.parsing.Node;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.publicinterface.Descriptor;

public class VariableNode
extends Node {
    public String variableName;
    public boolean isOneToManyAttribute;

    public VariableNode() {
        this.setIsOneToManyAttribute(false);
    }

    public VariableNode(String string) {
        this.setVariableName(string);
        this.setIsOneToManyAttribute(false);
    }

    public String getVariableName() {
        return this.variableName;
    }

    public boolean isVariableNode() {
        return true;
    }

    public boolean isComplete() {
        return true;
    }

    public boolean isOneToManyAttribute() {
        return this.isOneToManyAttribute;
    }

    public boolean isAlias(GenerationContext generationContext) {
        String string = generationContext.getParseTreeContext().aliasForVariableName(this.getVariableName());
        return string != null;
    }

    public Class resolveClass(GenerationContext generationContext) {
        String string = generationContext.getParseTreeContext().aliasForVariableName(this.getVariableName());
        if (string == null) {
            Node node = generationContext.getParseTreeContext().nodeForIdentifier(this.getVariableName());
            if (node == null) {
                throw EJBQLException.aliasResolutionException(this.getVariableName());
            }
            return node.resolveClass(generationContext);
        }
        Descriptor descriptor = generationContext.getSession().getDescriptorForAlias(string);
        if (descriptor == null) {
            throw EJBQLException.missingDescriptorException(string);
        }
        Class clazz = descriptor.getJavaClass();
        if (clazz == null) {
            throw EJBQLException.resolutionClassNotFoundException(string);
        }
        return clazz;
    }

    public Class resolveClass(GenerationContext generationContext, Class clazz) {
        DatabaseMapping databaseMapping = this.resolveMapping(generationContext, clazz);
        if (databaseMapping == null || databaseMapping.isDirectToFieldMapping()) {
            return clazz;
        }
        return databaseMapping.getReferenceDescriptor().getJavaClass();
    }

    public DatabaseMapping resolveMapping(GenerationContext generationContext, Class clazz) {
        return generationContext.getSession().getDescriptor(clazz).getMappingForAttributeName(this.getVariableName());
    }

    public void setIsOneToManyAttribute(boolean bl) {
        this.isOneToManyAttribute = bl;
    }

    public void setVariableName(String string) {
        this.variableName = string;
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        this.toStringIndent(n, stringBuffer);
        stringBuffer.append(this.toStringDisplayName() + "[" + this.getVariableName() + "]");
        return stringBuffer.toString();
    }
}

