/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.parsing;

import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.parsing.GenerationContext;
import oracle.toplink.internal.parsing.Node;
import oracle.toplink.internal.parsing.StringFunctionNode;

public class SubstringNode
extends StringFunctionNode {
    private Node startPosition = null;
    private Node stringLength = null;

    public boolean containsNode(Node node) {
        boolean bl = false;
        if (this.hasLeft()) {
            boolean bl2 = bl = this.getLeft() == node;
        }
        if (this.hasRight() && !bl) {
            bl = this.getRight() == node;
        }
        return bl;
    }

    public Expression generateExpression(GenerationContext generationContext) {
        Expression expression = this.getLeft().generateExpression(generationContext);
        Expression expression2 = this.getStartPosition().generateExpression(generationContext);
        Expression expression3 = this.getStringLength().generateExpression(generationContext);
        expression = expression.substring(expression2, expression3);
        return expression;
    }

    private Node getStartPosition() {
        return this.startPosition;
    }

    private Node getStringLength() {
        return this.stringLength;
    }

    public boolean isComplete() {
        return this.hasLeft() && this.getLeft().isComplete() && this.getStartPosition() != null && this.getStringLength() != null;
    }

    public void placeNode(Node node) {
        if (!this.hasLeft()) {
            this.setLeft(node);
        } else if (!this.getLeft().isComplete()) {
            this.getLeft().placeNode(node);
        } else if (this.getStartPosition() == null) {
            this.setStartPosition(node);
        } else if (this.getStringLength() == null) {
            this.setStringLength(node);
        } else {
            node.placeNode(this);
        }
    }

    private void setStartPosition(Node node) {
        this.startPosition = node;
    }

    private void setStringLength(Node node) {
        this.stringLength = node;
    }
}

