/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.parsing;

import oracle.toplink.internal.parsing.AbsNode;
import oracle.toplink.internal.parsing.AggregateNode;
import oracle.toplink.internal.parsing.AndNode;
import oracle.toplink.internal.parsing.BetweenNode;
import oracle.toplink.internal.parsing.BooleanLiteralNode;
import oracle.toplink.internal.parsing.ConcatNode;
import oracle.toplink.internal.parsing.CountNode;
import oracle.toplink.internal.parsing.DivideNode;
import oracle.toplink.internal.parsing.DotNode;
import oracle.toplink.internal.parsing.EJBQLParseTree;
import oracle.toplink.internal.parsing.EmptyCollectionComparisonNode;
import oracle.toplink.internal.parsing.EqualsAssignmentNode;
import oracle.toplink.internal.parsing.EqualsNode;
import oracle.toplink.internal.parsing.EscapeNode;
import oracle.toplink.internal.parsing.FloatLiteralNode;
import oracle.toplink.internal.parsing.FromNode;
import oracle.toplink.internal.parsing.GreaterThanEqualToNode;
import oracle.toplink.internal.parsing.GreaterThanNode;
import oracle.toplink.internal.parsing.InNode;
import oracle.toplink.internal.parsing.IntegerLiteralNode;
import oracle.toplink.internal.parsing.LengthNode;
import oracle.toplink.internal.parsing.LessThanEqualToNode;
import oracle.toplink.internal.parsing.LessThanNode;
import oracle.toplink.internal.parsing.LikeNode;
import oracle.toplink.internal.parsing.LocalVariableNode;
import oracle.toplink.internal.parsing.LocateNode;
import oracle.toplink.internal.parsing.MemberOfNode;
import oracle.toplink.internal.parsing.MinusNode;
import oracle.toplink.internal.parsing.ModNode;
import oracle.toplink.internal.parsing.MultiplyNode;
import oracle.toplink.internal.parsing.Node;
import oracle.toplink.internal.parsing.NotNode;
import oracle.toplink.internal.parsing.NullComparisonNode;
import oracle.toplink.internal.parsing.OrNode;
import oracle.toplink.internal.parsing.OrderByItemNode;
import oracle.toplink.internal.parsing.OrderByNode;
import oracle.toplink.internal.parsing.ParameterNode;
import oracle.toplink.internal.parsing.ParseTreeConstructor;
import oracle.toplink.internal.parsing.ParseTreeContext;
import oracle.toplink.internal.parsing.PlusNode;
import oracle.toplink.internal.parsing.SelectNode;
import oracle.toplink.internal.parsing.SetNode;
import oracle.toplink.internal.parsing.SortDirectionNode;
import oracle.toplink.internal.parsing.SqrtNode;
import oracle.toplink.internal.parsing.StringLiteralNode;
import oracle.toplink.internal.parsing.SubstringNode;
import oracle.toplink.internal.parsing.UpdateNode;

public class ParseTreeNodeConstructor {
    public ParseTreeConstructor treeConstructor;
    protected Node currentNode;
    public ParseTreeNodeConstructor parentConstructor;
    private NotNode notNode = null;
    public Node schemaIdentifierNode;
    public Node lastPlacedNode;
    public boolean bracketsOverrideMultiplyOrDivide = false;

    public ParseTreeNodeConstructor() {
    }

    public ParseTreeNodeConstructor(ParseTreeConstructor parseTreeConstructor) {
        this.setTreeConstructor(parseTreeConstructor);
    }

    public void addParameter(String string) {
        this.getParseTree().addParameter(string);
    }

    public Node buildLeftMostLocalVariableNode(String string) {
        return new LocalVariableNode(string);
    }

    public Node buildLocalVariableNode(String string) {
        return new LocalVariableNode(string);
    }

    public ParseTreeNodeConstructor createHelper() {
        ParseTreeNodeConstructor parseTreeNodeConstructor = new ParseTreeNodeConstructor(this.getTreeConstructor());
        this.getTreeConstructor().setNodeConstructor(parseTreeNodeConstructor);
        parseTreeNodeConstructor.setParentConstructor(this);
        return parseTreeNodeConstructor;
    }

    public void finishedAbs() {
        this.finishedExpression();
    }

    public void finishedAbsVariable() {
        this.finishedExpression();
    }

    public void finishedAnd() {
        this.finishedExpression();
    }

    public void finishedAggregate() {
        this.finishedExpression();
    }

    public void finishedFirstArithmeticExpressionInMOD() {
        this.finishedConstructingNode();
    }

    public void finishedSecondArithmeticExpressionInMOD() {
        this.finishedConstructingNode();
    }

    public void finishedExpression() {
        this.finishedConstructingNode();
        if (this.hasParentConstructor()) {
            this.getParentConstructor().finishPendingNodes();
        } else {
            this.finishPendingNodes();
        }
    }

    public void finishedBetweenAnd() {
        this.finishedExpression();
    }

    public void finishedComparisonExpression() {
        this.finishedExpression();
    }

    public void finishedConcat() {
        this.finishedExpression();
    }

    public void finishedConstructingNode() {
        if (!this.hasParentConstructor()) {
            return;
        }
        this.getParentConstructor().helperDone(this);
    }

    public void finishedEscape() {
        this.finishedExpression();
    }

    public void finishedMultiplyOrDivide() {
        if (this.getCurrentNode().isMultiplyNode() || this.getCurrentNode().isDivideNode()) {
            this.finishedExpression();
        }
        this.bracketsOverrideMultiplyOrDivide = false;
    }

    public void finishedLocate() {
        this.finishedExpression();
    }

    public void finishedLocateLiteral() {
        this.createHelper();
    }

    public void finishedLocateVariable() {
        this.finishedExpression();
    }

    public void finishedNumericOther() {
        this.finishedExpression();
    }

    public void finishedIn() {
        this.getCurrentNode().setComplete(true);
        this.finishedExpression();
    }

    public void finishedInClauseInFrom() {
    }

    public void finishedLength() {
        this.finishedExpression();
    }

    public void finishedLengthVariable() {
        this.finishedExpression();
    }

    public void finishedLike() {
        this.finishedExpression();
    }

    public void finishedMemberOf() {
        this.finishedExpression();
    }

    public void finishedNull() {
        this.finishedExpression();
    }

    public void finishedOr() {
        this.finishedExpression();
    }

    public void finishedOrderByItem() {
        this.getParentConstructor().placeNode(this.getCurrentNode());
        this.setCurrentNode(null);
    }

    public void finishedSelect() {
        this.finishedExpression();
    }

    public void finishedEqualsAssignment() {
        this.finishedExpression();
    }

    public void finishedModSingleValuedPathExpression() {
        this.finishedExpression();
    }

    public void finishedSqrtVariable() {
        this.finishedExpression();
    }

    public void finishedSubstring() {
        this.finishedExpression();
    }

    public void finishedSubstringVariable() {
        this.finishedExpression();
    }

    public ParseTreeContext getParseTreeContext() {
        return this.getTreeConstructor().getContext();
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    private NotNode getNotNode() {
        return this.notNode;
    }

    public ParseTreeNodeConstructor getParentConstructor() {
        return this.parentConstructor;
    }

    public EJBQLParseTree getParseTree() {
        if (this.hasParentConstructor()) {
            return this.getParentConstructor().getParseTree();
        }
        return (EJBQLParseTree)this.getTreeConstructor().getParseTree();
    }

    public Node getSchemaIdentifierNode() {
        return this.schemaIdentifierNode;
    }

    public ParseTreeConstructor getTreeConstructor() {
        return this.treeConstructor;
    }

    public void handleAbs() {
        AbsNode absNode = new AbsNode();
        this.placeNode(absNode);
        this.createHelper();
    }

    public void handleAnd() {
        AndNode andNode = new AndNode();
        this.placeNode(andNode);
        this.createHelper();
    }

    public void handleAndAfterBetween() {
        this.finishedConstructingNode();
    }

    public void handleAsc() {
        SortDirectionNode sortDirectionNode = new SortDirectionNode();
        sortDirectionNode.useAscending();
        this.placeNode(sortDirectionNode);
    }

    public void handleAvg() {
        AggregateNode aggregateNode = new AggregateNode();
        aggregateNode.useAvg();
        this.placeNode(aggregateNode);
        this.createHelper();
    }

    public void handleBetween() {
        BetweenNode betweenNode = new BetweenNode();
        this.placeNode(betweenNode);
        this.createHelper();
    }

    public void handleConcat() {
        ConcatNode concatNode = new ConcatNode();
        this.placeNode(concatNode);
        this.createHelper();
    }

    public void handleCount() {
        CountNode countNode = new CountNode();
        this.placeNode(countNode);
        this.createHelper();
    }

    public void handleCommaAfterConcat() {
        this.finishedConstructingNode();
    }

    public void handleDesc() {
        SortDirectionNode sortDirectionNode = new SortDirectionNode();
        sortDirectionNode.useDescending();
        this.placeNode(sortDirectionNode);
    }

    public void handleDistinct() {
        this.getParseTree().setDistinctState((short)1);
    }

    public void handleDivide() {
        this.placeMultiplyOrDivideNode(new DivideNode());
    }

    public void handleDot() {
        DotNode dotNode = new DotNode();
        this.placeNode(dotNode);
    }

    public void handleEqualsComparison() {
        EqualsNode equalsNode = new EqualsNode();
        this.placeNode(equalsNode);
        this.createHelper();
    }

    public void handleEscape() {
        EscapeNode escapeNode = new EscapeNode();
        this.placeNode(escapeNode);
        this.createHelper();
    }

    public void handleEmpty() {
        EmptyCollectionComparisonNode emptyCollectionComparisonNode = new EmptyCollectionComparisonNode();
        if (this.hasNotNode()) {
            this.setNotNode(null);
            emptyCollectionComparisonNode.indicateNot();
        }
        this.placeNode(emptyCollectionComparisonNode);
    }

    public void handleFalse() {
        BooleanLiteralNode booleanLiteralNode = new BooleanLiteralNode(false);
        this.placeNode(booleanLiteralNode);
    }

    public void handleFloat(Object object) {
        FloatLiteralNode floatLiteralNode = new FloatLiteralNode(object);
        this.placeNode(floatLiteralNode);
    }

    public void handleFrom() {
        FromNode fromNode = new FromNode();
        fromNode.setContext(this.getParseTreeContext());
        this.placeNode(fromNode);
    }

    public void handleGreaterThan() {
        GreaterThanNode greaterThanNode = new GreaterThanNode();
        this.placeNode(greaterThanNode);
        this.createHelper();
    }

    public void handleGreaterThanEqualTo() {
        GreaterThanEqualToNode greaterThanEqualToNode = new GreaterThanEqualToNode();
        this.placeNode(greaterThanEqualToNode);
        this.createHelper();
    }

    public void handleIn() {
        InNode inNode = new InNode();
        if (this.hasNotNode()) {
            inNode.indicateNot();
            this.clearNotNode();
        }
        this.placeNode(inNode);
    }

    public void handleInputParameter(String string) {
        ParameterNode parameterNode = new ParameterNode(string);
        this.placeNode(parameterNode);
        parameterNode.addParameterToTree();
    }

    public void handleInteger(Integer n) {
        IntegerLiteralNode integerLiteralNode = new IntegerLiteralNode(n);
        this.placeNode(integerLiteralNode);
    }

    public void handleLeftMostLocalVariable(String string) {
        this.placeNode(this.buildLeftMostLocalVariableNode(string));
    }

    public void handleLeftRoundBracket() {
        this.createHelper();
    }

    public void handleLength() {
        LengthNode lengthNode = new LengthNode();
        this.placeNode(lengthNode);
        this.createHelper();
    }

    public void handleLessThan() {
        LessThanNode lessThanNode = new LessThanNode();
        this.placeNode(lessThanNode);
        this.createHelper();
    }

    public void handleLessThanEqualTo() {
        LessThanEqualToNode lessThanEqualToNode = new LessThanEqualToNode();
        this.placeNode(lessThanEqualToNode);
        this.createHelper();
    }

    public void handleLike() {
        LikeNode likeNode = new LikeNode();
        this.placeNode(likeNode);
    }

    public void handleLocalVariable(String string) {
        this.placeNode(this.buildLocalVariableNode(string));
    }

    public void handleLocate() {
        LocateNode locateNode = new LocateNode();
        this.placeNode(locateNode);
    }

    public void handleMax() {
        AggregateNode aggregateNode = new AggregateNode();
        aggregateNode.useMax();
        this.placeNode(aggregateNode);
        this.createHelper();
    }

    public void handleMemberOf() {
        MemberOfNode memberOfNode = new MemberOfNode();
        if (this.hasNotNode()) {
            this.setNotNode(null);
            memberOfNode.indicateNot();
        }
        this.placeNode(memberOfNode);
        this.createHelper();
    }

    public void handleMin() {
        AggregateNode aggregateNode = new AggregateNode();
        aggregateNode.useMin();
        this.placeNode(aggregateNode);
        this.createHelper();
    }

    public void handleMinus() {
        this.placeNode(new MinusNode());
    }

    public void handleMod() {
        ModNode modNode = new ModNode();
        this.placeNode(modNode);
        this.createHelper();
    }

    public void handleMultiply() {
        this.placeMultiplyOrDivideNode(new MultiplyNode());
    }

    public void handleNot() {
        NotNode notNode = new NotNode();
        this.setNotNode(notNode);
    }

    public void handleNull() {
        NullComparisonNode nullComparisonNode = new NullComparisonNode();
        this.placeNode(nullComparisonNode);
        if (this.hasNotNode()) {
            this.placeNode(this.getNotNode());
            this.setNotNode(null);
        }
    }

    public void handleOr() {
        OrNode orNode = new OrNode();
        this.placeNode(orNode);
        this.createHelper();
    }

    public void handleOrderBy() {
        OrderByNode orderByNode = new OrderByNode();
        this.placeNode(orderByNode);
        this.createHelper();
    }

    public void handleOrderByItem() {
        OrderByItemNode orderByItemNode = new OrderByItemNode();
        this.placeNode(orderByItemNode);
    }

    public void handlePlus() {
        this.placeNode(new PlusNode());
    }

    public void handleRightRoundBracket() {
        this.finishedConstructingNode();
    }

    public void handleSelect() {
        SelectNode selectNode = new SelectNode();
        this.placeNode(selectNode);
        this.createHelper();
    }

    public void handleSet() {
        SetNode setNode = new SetNode();
        setNode.placeNodeOnTree(this.getTreeConstructor().getParseTree());
        this.createHelper();
    }

    public void handleEqualsAssignment() {
        EqualsAssignmentNode equalsAssignmentNode = new EqualsAssignmentNode();
        this.placeNode(equalsAssignmentNode);
        this.createHelper();
    }

    public void handleSqrt() {
        SqrtNode sqrtNode = new SqrtNode();
        this.placeNode(sqrtNode);
        this.createHelper();
    }

    public void handleStartEqualsAssignment() {
        this.createHelper();
    }

    public void handleSum() {
        AggregateNode aggregateNode = new AggregateNode();
        aggregateNode.useSum();
        this.placeNode(aggregateNode);
        this.createHelper();
    }

    public void handleString(String string) {
        StringLiteralNode stringLiteralNode = new StringLiteralNode(string);
        this.placeNode(stringLiteralNode);
    }

    public void handleSubstring() {
        SubstringNode substringNode = new SubstringNode();
        this.placeNode(substringNode);
        this.createHelper();
    }

    public void handleTrue() {
        BooleanLiteralNode booleanLiteralNode = new BooleanLiteralNode(true);
        this.placeNode(booleanLiteralNode);
    }

    public void handleUpdate() {
        UpdateNode updateNode = new UpdateNode();
        updateNode.setContext(this.getParseTreeContext());
        this.placeNode(updateNode);
        this.createHelper();
    }

    public void handleWhere() {
        this.setCurrentNode(null);
    }

    public boolean hasNotNode() {
        return this.getNotNode() != null;
    }

    public boolean hasParentConstructor() {
        return this.parentConstructor != null;
    }

    public void helperDone(ParseTreeNodeConstructor parseTreeNodeConstructor) {
        this.placeNode(parseTreeNodeConstructor.getCurrentNode());
        this.getTreeConstructor().setNodeConstructor(this);
        this.checkForBracketsOverridingMultiplyOrDivide();
    }

    public void finishPendingNodes() {
        if (this.hasNotNode()) {
            this.placeNode(this.getNotNode());
            this.clearNotNode();
        }
    }

    public void placeNode(Node node) {
        this.setLastPlacedNode(node);
        node.setNodeConstructor(this);
        if (this.getCurrentNode() != null) {
            this.getCurrentNode().placeNode(node);
        }
        if (this.shouldReplaceCurrent(node)) {
            this.setCurrentNode(node);
            this.setRoot(node);
        }
    }

    public void checkForBracketsOverridingMultiplyOrDivide() {
        if (this.getCurrentNode().isPlusNode() || this.getCurrentNode().isMinusNode()) {
            this.bracketsOverrideMultiplyOrDivide = true;
        }
    }

    public void placeMultiplyOrDivideNode(Node node) {
        if (this.bracketsOverrideMultiplyOrDivide) {
            this.placeNode(node);
            return;
        }
        if (this.getCurrentNode().isPlusNode() || this.getCurrentNode().isMinusNode()) {
            node.stealNodeFrom(this.getCurrentNode());
            this.createHelper().placeNode(node);
        } else {
            this.placeNode(node);
        }
    }

    public void setCurrentNode(Node node) {
        this.currentNode = node;
    }

    public void setLastPlacedNode(Node node) {
        this.lastPlacedNode = node;
    }

    private void clearNotNode() {
        this.notNode = null;
    }

    private void setNotNode(NotNode notNode) {
        this.notNode = notNode;
    }

    public void setParentConstructor(ParseTreeNodeConstructor parseTreeNodeConstructor) {
        this.parentConstructor = parseTreeNodeConstructor;
    }

    public void setRoot(Node node) {
        if (this.hasParentConstructor()) {
            return;
        }
        this.getTreeConstructor().setRoot(node);
    }

    public void setTreeConstructor(ParseTreeConstructor parseTreeConstructor) {
        this.treeConstructor = parseTreeConstructor;
    }

    public boolean shouldReplaceCurrent(Node node) {
        return this.getCurrentNode() == null || node.containsNode(this.getCurrentNode());
    }
}

