/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.parsing;

import java.util.Iterator;
import java.util.Vector;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.internal.helper.ConversionManager;
import oracle.toplink.internal.localization.ToStringLocalization;
import oracle.toplink.internal.parsing.FromNode;
import oracle.toplink.internal.parsing.GenerationContext;
import oracle.toplink.internal.parsing.OrderByNode;
import oracle.toplink.internal.parsing.ParseTreeContext;
import oracle.toplink.internal.parsing.QueryNode;
import oracle.toplink.internal.parsing.SelectGenerationContext;
import oracle.toplink.internal.parsing.SelectNode;
import oracle.toplink.internal.parsing.SetNode;
import oracle.toplink.internal.parsing.WhereNode;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadQuery;
import oracle.toplink.queryframework.UpdateAllQuery;

public class ParseTree {
    private ParseTreeContext context;
    private QueryNode queryNode;
    private FromNode fromNode;
    private SetNode setNode;
    private WhereNode whereNode;
    private OrderByNode orderByNode = null;
    public static ClassLoader classLoader = null;
    protected Vector parameters;
    private short distinctState = 0;

    public void adjustReferenceClassForQuery(DatabaseQuery databaseQuery, Session session) {
        Class clazz = this.getReferenceClass(databaseQuery, session);
        if (clazz != null && clazz != databaseQuery.getReferenceClass()) {
            if (databaseQuery.isObjectLevelReadQuery()) {
                ((ObjectLevelReadQuery)databaseQuery).setReferenceClass(clazz);
                ((ObjectLevelReadQuery)databaseQuery).changeDescriptor(session);
            } else if (databaseQuery.isUpdateAllQuery()) {
                ((UpdateAllQuery)databaseQuery).setReferenceClass(clazz);
            }
        }
    }

    public void addOrderingToQuery(ObjectLevelReadQuery objectLevelReadQuery, Session session) {
        if (this.hasOrderBy()) {
            GenerationContext generationContext = this.buildContext(objectLevelReadQuery, session);
            this.getOrderByNode().addOrderingToQuery(objectLevelReadQuery, generationContext);
        }
    }

    public void addUpdatesToQuery(UpdateAllQuery updateAllQuery, Session session) {
        if (this.getSetNode() != null) {
            GenerationContext generationContext = this.buildContext(updateAllQuery, session);
            this.getSetNode().addUpdatesToQuery(updateAllQuery, generationContext);
        }
    }

    public void addParameter(String string) {
        this.getParameters().add(string);
    }

    public void addParametersToQuery(DatabaseQuery databaseQuery) {
        if (this.hasParameters()) {
            Iterator iterator = this.getParameters().iterator();
            while (iterator.hasNext()) {
                databaseQuery.addArgument((String)iterator.next());
            }
        }
    }

    public void applyQueryNodeToQuery(DatabaseQuery databaseQuery, Session session) {
        GenerationContext generationContext = this.buildContext(databaseQuery, session);
        this.getQueryNode().applyToQuery(databaseQuery, generationContext);
    }

    public GenerationContext buildContext(DatabaseQuery databaseQuery, Session session) {
        if (databaseQuery.isObjectLevelReadQuery()) {
            return new SelectGenerationContext(this.getContext(), session, this);
        }
        if (databaseQuery.isUpdateAllQuery()) {
            return new GenerationContext(this.getContext(), session, this);
        }
        return null;
    }

    public Expression generateExpression(DatabaseQuery databaseQuery, Session session) {
        Expression expression = null;
        GenerationContext generationContext = this.buildContext(databaseQuery, session);
        if (this.getWhereNode() == null) {
            expression = this.getQueryNode().generateExpression(generationContext);
            if (expression == null) {
                return null;
            }
            return new ExpressionBuilder(this.getQueryNode().resolveClass(generationContext)).equal(expression);
        }
        Expression expression2 = this.getWhereNode().generateExpression(generationContext);
        expression = this.getQueryNode().generateExpression(generationContext);
        if (expression != null) {
            expression2 = new ExpressionBuilder(this.getQueryNode().resolveClass(generationContext)).equal(expression).and(expression2);
        }
        return expression2;
    }

    public ParseTreeContext getContext() {
        return this.context;
    }

    public FromNode getFromNode() {
        return this.fromNode;
    }

    public ClassLoader getMyClassLoader() {
        if (classLoader == null) {
            return ConversionManager.getDefaultManager().getLoader();
        }
        return classLoader;
    }

    public OrderByNode getOrderByNode() {
        return this.orderByNode;
    }

    public Vector getParameters() {
        if (this.parameters == null) {
            this.setParameters(new Vector());
        }
        return this.parameters;
    }

    public Class getReferenceClass(DatabaseQuery databaseQuery, Session session) {
        GenerationContext generationContext = this.buildContext(databaseQuery, session);
        if (this.getQueryNode() == null) {
            return null;
        }
        return this.getQueryNode().resolveClass(generationContext);
    }

    public QueryNode getQueryNode() {
        return this.queryNode;
    }

    public SetNode getSetNode() {
        return this.setNode;
    }

    public WhereNode getWhereNode() {
        return this.whereNode;
    }

    public short getDistinctState() {
        return this.distinctState;
    }

    public boolean hasAttributeSelected(ReadQuery readQuery, Session session) {
        GenerationContext generationContext = this.buildContext(readQuery, session);
        return ((SelectNode)this.getQueryNode()).hasAttributeSelected(generationContext);
    }

    public boolean hasCountSelected(ReadQuery readQuery, Session session) {
        GenerationContext generationContext = this.buildContext(readQuery, session);
        return ((SelectNode)this.getQueryNode()).hasCountSelected(generationContext);
    }

    public boolean hasOrderBy() {
        return this.getOrderByNode() != null;
    }

    public boolean hasParameters() {
        return this.getParameters().size() > 0;
    }

    public void setContext(ParseTreeContext parseTreeContext) {
        this.context = parseTreeContext;
    }

    public void setFromNode(FromNode fromNode) {
        this.fromNode = fromNode;
    }

    public void setParameters(Vector vector) {
        this.parameters = vector;
    }

    public void setOrderByNode(OrderByNode orderByNode) {
        this.orderByNode = orderByNode;
    }

    public void setSelectionCriteriaForQuery(DatabaseQuery databaseQuery, Session session) {
        databaseQuery.setSelectionCriteria(this.generateExpression(databaseQuery, session));
    }

    public void setQueryNode(QueryNode queryNode) {
        this.queryNode = queryNode;
    }

    public void setSetNode(SetNode setNode) {
        this.setNode = setNode;
    }

    public void setWhereNode(WhereNode whereNode) {
        this.whereNode = whereNode;
    }

    public void setDistinctState(short s) {
        this.distinctState = s;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getContext().toString());
        return ToStringLocalization.buildMessage("context", null) + " " + stringBuffer.toString();
    }

    public void verifySelect(DatabaseQuery databaseQuery, Session session) {
        if (databaseQuery.isObjectLevelReadQuery()) {
            ((SelectNode)this.getQueryNode()).verifySelectedAlias(this.buildContext(databaseQuery, session));
        }
    }

    public boolean usesDistinct() {
        return this.distinctState == 1;
    }
}

