/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ox;

import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import oracle.toplink.descriptors.InheritancePolicy;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.ox.NamespaceResolver;
import oracle.toplink.ox.XMLField;
import oracle.toplink.ox.record.XMLRecord;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;

public class QNameInheritancePolicy
extends InheritancePolicy {
    private NamespaceResolver namespaceResolver;

    public QNameInheritancePolicy() {
    }

    public QNameInheritancePolicy(Descriptor descriptor) {
        super(descriptor);
    }

    public void initialize(Session session) {
        super.initialize(session);
        if (!this.shouldUseClassNameAsIndicator() && this.namespaceResolver != null) {
            Iterator iterator = new HashMap(this.getClassIndicatorMapping()).keySet().iterator();
            while (iterator.hasNext()) {
                String string;
                int n;
                Object k = iterator.next();
                Object v = this.getClassIndicatorMapping().get(k);
                if (!(k instanceof String) || (n = (string = (String)k).indexOf(":")) == -1) continue;
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                String string4 = this.namespaceResolver.resolveNamespacePrefix(string2);
                QName qName = new QName(string4, string3);
                this.getClassIndicatorMapping().put(qName, v);
            }
        }
    }

    public Class classFromRow(DatabaseRow databaseRow, Session session) throws DescriptorException {
        Class clazz;
        if (this.hasClassExtractor() || this.shouldUseClassNameAsIndicator()) {
            return super.classFromRow(databaseRow, session);
        }
        Object object = session.getDatasourcePlatform().getConversionManager().convertObject(databaseRow.get(this.getClassIndicatorField()), this.getClassIndicatorField().getType());
        if (object == null) {
            throw DescriptorException.missingClassIndicatorField(databaseRow, this.getDescriptor());
        }
        if (object instanceof String) {
            String string = (String)object;
            int n = string.indexOf(":");
            if (n == -1) {
                clazz = (Class)this.classIndicatorMapping.get(object);
            } else {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                String string4 = ((XMLRecord)databaseRow).resolveNamespacePrefix(string2);
                if (string4 != null) {
                    QName qName = new QName(string4, string3);
                    clazz = (Class)this.classIndicatorMapping.get(qName);
                } else {
                    clazz = (Class)this.classIndicatorMapping.get(string);
                }
            }
        } else {
            clazz = (Class)this.classIndicatorMapping.get(object);
        }
        if (clazz == null) {
            throw DescriptorException.missingClassForIndicatorFieldValue(object, this.getDescriptor());
        }
        return clazz;
    }

    public void setNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.namespaceResolver = namespaceResolver;
    }

    public void setClassIndicatorFieldName(String string) {
        if (string == null) {
            this.setClassIndicatorField(null);
        } else {
            this.setClassIndicatorField(new XMLField(string));
        }
    }
}

