/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import oracle.toplink.exceptions.ValidationException;

public class SerializationHelper {
    public static Object clone(Serializable serializable) throws IOException, ClassNotFoundException {
        return SerializationHelper.deserialize(SerializationHelper.serialize(serializable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(Serializable serializable, OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw ValidationException.invalidNullMethodArguments();
        }
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(serializable);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static byte[] serialize(Serializable serializable) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        SerializationHelper.serialize(serializable, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserialize(InputStream inputStream) throws IOException, ClassNotFoundException {
        Object object;
        if (inputStream == null) {
            throw new IllegalArgumentException("The inputStream argument cannot be null");
        }
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(inputStream);
            object = objectInputStream.readObject();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (objectInputStream != null) {
                objectInputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return object;
    }

    public static Object deserialize(byte[] byArray) throws IOException, ClassNotFoundException {
        if (byArray == null) {
            throw ValidationException.invalidNullMethodArguments();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return SerializationHelper.deserialize(byteArrayInputStream);
    }
}

