/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.helper;

import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.internal.helper.ConcurrencyManager;

public class DeferredLockManager {
    protected Vector deferredLocks = new Vector(1);
    protected Vector activeLocks = new Vector(1);
    protected int threadDepth = 0;
    protected boolean isThreadComplete = false;
    public static boolean SHOULD_USE_DEFERRED_LOCKS = true;

    public void addActiveLock(Object object) {
        this.getActiveLocks().addElement(object);
    }

    public void addDeferredLock(Object object) {
        this.getDeferredLocks().addElement(object);
    }

    public void decrementDepth() {
        --this.threadDepth;
    }

    public Vector getActiveLocks() {
        return this.activeLocks;
    }

    public Vector getDeferredLocks() {
        return this.deferredLocks;
    }

    public int getThreadDepth() {
        return this.threadDepth;
    }

    public boolean hasDeferredLock() {
        return !this.getDeferredLocks().isEmpty();
    }

    public void incrementDepth() {
        ++this.threadDepth;
    }

    public boolean isThreadComplete() {
        return this.isThreadComplete;
    }

    public void releaseActiveLocksOnThread() {
        Vector vector = this.getActiveLocks();
        if (!vector.isEmpty()) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ConcurrencyManager concurrencyManager = (ConcurrencyManager)enumeration.nextElement();
                concurrencyManager.release();
            }
        }
        this.setIsThreadComplete(true);
    }

    public void setActiveLocks(Vector vector) {
        this.activeLocks = vector;
    }

    public void setDeferredLocks(Vector vector) {
        this.deferredLocks = vector;
    }

    public void setIsThreadComplete(boolean bl) {
        this.isThreadComplete = bl;
    }
}

