/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Vector;
import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.expressions.DataExpression;
import oracle.toplink.internal.expressions.ExpressionNormalizer;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.DatabaseTable;

public class TableExpression
extends DataExpression {
    protected DatabaseTable table;

    public TableExpression() {
    }

    public TableExpression(DatabaseTable databaseTable) {
        this.table = databaseTable;
    }

    public String descriptionOfNodeType() {
        return "Table";
    }

    public Expression getField(String string) {
        DatabaseField databaseField = new DatabaseField(string);
        if (!databaseField.hasTableName()) {
            databaseField.setTable(this.getTable());
        }
        return this.getField(databaseField);
    }

    public Vector getOwnedTables() {
        Vector<DatabaseTable> vector = new Vector<DatabaseTable>(1);
        vector.addElement(this.getTable());
        return vector;
    }

    public DatabaseTable getTable() {
        return this.table;
    }

    public boolean isTableExpression() {
        return true;
    }

    public Expression normalize(ExpressionNormalizer expressionNormalizer) {
        if (this.getTable().getTableQualifier().length() == 0 && expressionNormalizer.getSession().getDatasourceLogin().getTableQualifier().length() != 0) {
            this.getTable().setTableQualifier(expressionNormalizer.getSession().getDatasourceLogin().getTableQualifier());
        }
        return super.normalize(expressionNormalizer);
    }

    public Expression rebuildOn(Expression expression) {
        Expression expression2 = this.getBaseExpression().rebuildOn(expression);
        return expression2.getTable(this.getTable());
    }

    public void setTable(DatabaseTable databaseTable) {
        this.table = databaseTable;
    }

    public Expression twistedForBaseAndContext(Expression expression, Expression expression2) {
        Expression expression3 = this.getBaseExpression().twistedForBaseAndContext(expression, expression2);
        return expression3.getTable(this.getTable());
    }

    public void writeDescriptionOn(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(this.getTable().toString());
        bufferedWriter.write(this.tableAliasesDescription());
    }
}

