/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.expressions;

import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.internal.expressions.ForUpdateClause;
import oracle.toplink.internal.expressions.ObjectExpression;
import oracle.toplink.internal.expressions.SQLSelectStatement;
import oracle.toplink.internal.helper.NonSynchronizedVector;

public class ForUpdateOfClause
extends ForUpdateClause {
    protected Vector lockedExpressions;

    public void addLockedExpression(ObjectExpression objectExpression) {
        this.getLockedExpressions().addElement(objectExpression);
    }

    public Vector getLockedExpressions() {
        if (this.lockedExpressions == null) {
            this.lockedExpressions = NonSynchronizedVector.newInstance();
        }
        return this.lockedExpressions;
    }

    public boolean isForUpdateOfClause() {
        return true;
    }

    public boolean isReferenceClassLocked() {
        if (this.lockedExpressions == null) {
            return false;
        }
        for (int i = 0; i < this.lockedExpressions.size(); ++i) {
            if (!((Expression)this.lockedExpressions.elementAt(i)).isExpressionBuilder()) continue;
            return true;
        }
        return false;
    }

    public void setLockedExpressions(Vector vector) {
        this.lockedExpressions = vector;
    }

    public void setLockMode(short s) {
        this.lockMode = s;
    }

    public void printSQL(ExpressionSQLPrinter expressionSQLPrinter, SQLSelectStatement sQLSelectStatement) {
        ExpressionBuilder expressionBuilder = sQLSelectStatement.getBuilder();
        expressionSQLPrinter.printString(expressionSQLPrinter.getSession().getPlatform().getSelectForUpdateOfString());
        expressionSQLPrinter.setIsFirstElementPrinted(false);
        Enumeration enumeration = this.getLockedExpressions().elements();
        while (enumeration.hasMoreElements()) {
            ObjectExpression objectExpression = (ObjectExpression)enumeration.nextElement();
            objectExpression = (ObjectExpression)objectExpression.rebuildOn(expressionBuilder);
            objectExpression.writeForUpdateOfFields(expressionSQLPrinter, sQLSelectStatement);
        }
        if (this.lockMode == 2) {
            expressionSQLPrinter.printString(expressionSQLPrinter.getSession().getPlatform().getSelectForUpdateNoWaitString());
        }
    }
}

