/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.expressions;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.internal.expressions.ParameterExpression;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.SQLCall;

public class ExpressionSQLPrinter {
    protected Session session;
    protected SQLCall call;
    protected DatabaseRow translationRow;
    protected boolean shouldPrintQualifiedNames;
    protected Writer writer;
    protected boolean requiresDistinct;
    protected boolean isFirstElementPrinted;

    public ExpressionSQLPrinter(Session session, DatabaseRow databaseRow, SQLCall sQLCall, boolean bl) {
        this.session = session;
        this.translationRow = databaseRow;
        this.call = sQLCall;
        this.shouldPrintQualifiedNames = bl;
        this.requiresDistinct = false;
        this.isFirstElementPrinted = false;
    }

    protected SQLCall getCall() {
        return this.call;
    }

    public DatabasePlatform getPlatform() {
        return this.session.getPlatform();
    }

    protected Session getSession() {
        return this.session;
    }

    protected DatabaseRow getTranslationRow() {
        return this.translationRow;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public boolean isFirstElementPrinted() {
        return this.isFirstElementPrinted;
    }

    public void printExpression(Expression expression) {
        this.translateExpression(expression);
    }

    public void printField(DatabaseField databaseField) {
        if (databaseField == null) {
            return;
        }
        try {
            if (this.shouldPrintQualifiedNames()) {
                this.getWriter().write(databaseField.getQualifiedName());
            } else {
                this.getWriter().write(databaseField.getName());
            }
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public void printParameter(ParameterExpression parameterExpression) {
        try {
            this.getCall().appendTranslationParameter(this.getWriter(), parameterExpression);
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public void printParameter(DatabaseField databaseField) {
        this.getCall().appendTranslation(this.getWriter(), databaseField);
    }

    public void printPrimitive(Object object) {
        if (object instanceof Vector) {
            this.printValuelist((Vector)object);
            return;
        }
        this.getCall().appendLiteral(this.getWriter(), object);
    }

    public void printString(String string) {
        try {
            this.getWriter().write(string);
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public void printValuelist(Vector vector) {
        try {
            this.getWriter().write("(");
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                this.getCall().appendLiteral(this.getWriter(), e);
                if (!enumeration.hasMoreElements()) continue;
                this.getWriter().write(", ");
            }
            this.getWriter().write(")");
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public boolean requiresDistinct() {
        return this.requiresDistinct;
    }

    protected void setCall(SQLCall sQLCall) {
        this.call = sQLCall;
    }

    public void setIsFirstElementPrinted(boolean bl) {
        this.isFirstElementPrinted = bl;
    }

    public void setRequiresDistinct(boolean bl) {
        this.requiresDistinct = bl;
    }

    protected void setSession(Session session) {
        this.session = session;
    }

    protected void setShouldPrintQualifiedNames(boolean bl) {
        this.shouldPrintQualifiedNames = bl;
    }

    protected void setTranslationRow(DatabaseRow databaseRow) {
        this.translationRow = databaseRow;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public boolean shouldPrintParameterValues() {
        return this.getTranslationRow() != null;
    }

    protected boolean shouldPrintQualifiedNames() {
        return this.shouldPrintQualifiedNames;
    }

    protected void translateExpression(Expression expression) {
        expression.printSQL(this);
    }
}

