/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.expressions;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.expressions.SQLSelectStatement;
import oracle.toplink.internal.expressions.SubSelectExpression;
import oracle.toplink.publicinterface.Session;

public class ExpressionNormalizer {
    protected Expression additionalExpression;
    protected SQLSelectStatement statement;
    protected Vector subSelectExpressions;
    protected Session session;

    public ExpressionNormalizer(SQLSelectStatement sQLSelectStatement) {
        this.statement = sQLSelectStatement;
    }

    public void addAdditionalExpression(Expression expression) {
        this.additionalExpression = this.additionalExpression == null ? expression : this.additionalExpression.and(expression);
    }

    public void addSubSelectExpression(SubSelectExpression subSelectExpression) {
        if (this.subSelectExpressions == null) {
            this.subSelectExpressions = new Vector(1);
        }
        this.subSelectExpressions.add(subSelectExpression);
    }

    public Expression getAdditionalExpression() {
        return this.additionalExpression;
    }

    public Session getSession() {
        return this.session;
    }

    public SQLSelectStatement getStatement() {
        return this.statement;
    }

    public boolean encounteredSubSelectExpressions() {
        return this.subSelectExpressions != null;
    }

    public void normalizeSubSelects(Dictionary dictionary) {
        Enumeration enumeration = this.subSelectExpressions.elements();
        while (enumeration.hasMoreElements()) {
            SubSelectExpression subSelectExpression = (SubSelectExpression)enumeration.nextElement();
            subSelectExpression.normalizeSubSelect(this, dictionary);
        }
    }

    public void setAdditionalExpression(Expression expression) {
        this.additionalExpression = expression;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void setStatement(SQLSelectStatement sQLSelectStatement) {
        this.statement = sQLSelectStatement;
    }
}

