/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp3.base;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.ejb.cmp3.base.EntityManagerImpl;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.localization.ExceptionLocalization;
import oracle.toplink.internal.parsing.EJBQLParseTree;
import oracle.toplink.internal.parsing.ejbql.EJBQLCallQueryMechanism;
import oracle.toplink.internal.parsing.ejbql.EJBQLParser;
import oracle.toplink.internal.parsing.ejbql.EJBQLParserBase;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ModifyQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadAllQuery;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.queryframework.ReadQuery;
import oracle.toplink.queryframework.UpdateAllQuery;

public abstract class EJBQueryImpl {
    protected DatabaseQuery databaseQuery = null;
    protected EntityManagerImpl entityManager = null;
    protected String queryName = null;
    protected Vector parameters = NonSynchronizedVector.newInstance();
    protected Vector parameterValues = NonSynchronizedVector.newInstance();
    protected int firstResultIndex = 0;
    protected int maxResults = 0;
    static /* synthetic */ Class class$oracle$toplink$queryframework$ModifyQuery;
    static /* synthetic */ Class class$oracle$toplink$queryframework$ReadAllQuery;

    protected abstract void throwObjectNotFoundException(String var1);

    protected abstract void throwNonUniqueResultException(String var1);

    protected EJBQueryImpl(EntityManagerImpl entityManagerImpl) {
        this.entityManager = entityManagerImpl;
    }

    public EJBQueryImpl(DatabaseQuery databaseQuery, EntityManagerImpl entityManagerImpl) {
        this(entityManagerImpl);
        this.databaseQuery = databaseQuery;
    }

    public EJBQueryImpl(String string, EntityManagerImpl entityManagerImpl) {
        this(string, entityManagerImpl, false);
    }

    public EJBQueryImpl(String string, EntityManagerImpl entityManagerImpl, boolean bl) {
        this(entityManagerImpl);
        if (bl) {
            this.queryName = string;
        } else if (this.databaseQuery == null) {
            this.databaseQuery = EJBQueryImpl.buildDatabaseQuery(string, (Session)this.getActiveSession());
        }
    }

    public static DatabaseQuery buildDatabaseQuery(String string, oracle.toplink.sessions.Session session) {
        DatabaseQuery databaseQuery = null;
        EJBQLParser eJBQLParser = EJBQLParserBase.parseEJBQLString(string);
        EJBQLParseTree eJBQLParseTree = (EJBQLParseTree)eJBQLParser.getParseTree();
        if (eJBQLParseTree.getQueryNode() != null && eJBQLParseTree.getQueryNode().isSelectNode()) {
            databaseQuery = new ReadAllQuery();
            databaseQuery.setEJBQLString(string);
            ((ObjectLevelReadQuery)databaseQuery).conformResultsInUnitOfWork();
        } else if (eJBQLParseTree.getQueryNode() != null && eJBQLParseTree.getQueryNode().isUpdateNode()) {
            databaseQuery = new UpdateAllQuery();
            databaseQuery.setEJBQLString(string);
            ((UpdateAllQuery)databaseQuery).setShouldDeferExecutionInUOW(false);
        }
        eJBQLParseTree.populateQuery(databaseQuery, (Session)session);
        eJBQLParseTree.addParametersToQuery(databaseQuery);
        ((EJBQLCallQueryMechanism)databaseQuery.getQueryMechanism()).getEJBQLCall().setIsParsed(true);
        return databaseQuery;
    }

    protected Object executeReadQuery() {
        this.processParameters();
        return this.getActiveSession().executeQuery(this.getDatabaseQuery(), this.parameterValues);
    }

    public int executeUpdate() {
        if (!(this.getDatabaseQuery() instanceof ModifyQuery)) {
            throw QueryException.incorrectQueryObjectFound(this.getDatabaseQuery(), class$oracle$toplink$queryframework$ModifyQuery == null ? (class$oracle$toplink$queryframework$ModifyQuery = EJBQueryImpl.class$("oracle.toplink.queryframework.ModifyQuery")) : class$oracle$toplink$queryframework$ModifyQuery);
        }
        this.processParameters();
        Integer n = (Integer)this.getActiveSession().executeQuery(this.databaseQuery, this.parameterValues);
        return n;
    }

    public DatabaseQuery getDatabaseQuery() {
        if (this.queryName != null && this.databaseQuery == null) {
            this.databaseQuery = this.getActiveSession().getQuery(this.queryName);
            if (this.databaseQuery == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("unable_to_find_named_query", new Object[]{this.queryName}));
            }
        }
        return this.databaseQuery;
    }

    public Collection getResultCollection() {
        Object object;
        if (this.getDatabaseQuery() instanceof ReadAllQuery) {
            object = ((ReadAllQuery)this.getDatabaseQuery()).getContainerPolicy().getContainerClass();
            if (!Helper.classImplementsInterface((Class)object, ClassConstants.Collection_Class)) {
                throw QueryException.invalidContainerClass((Class)object, ClassConstants.Collection_Class);
            }
        } else if (this.getDatabaseQuery() instanceof ReadObjectQuery) {
            throw QueryException.incorrectQueryObjectFound(this.getDatabaseQuery(), class$oracle$toplink$queryframework$ReadAllQuery == null ? (class$oracle$toplink$queryframework$ReadAllQuery = EJBQueryImpl.class$("oracle.toplink.queryframework.ReadAllQuery")) : class$oracle$toplink$queryframework$ReadAllQuery);
        }
        object = this.executeReadQuery();
        return (Collection)object;
    }

    public List getResultList() {
        Object object;
        if (this.getDatabaseQuery() instanceof ReadAllQuery) {
            object = ((ReadAllQuery)this.getDatabaseQuery()).getContainerPolicy().getContainerClass();
            if (!Helper.classImplementsInterface((Class)object, ClassConstants.List_Class)) {
                throw QueryException.invalidContainerClass((Class)object, ClassConstants.List_Class);
            }
        } else if (this.getDatabaseQuery() instanceof ReadObjectQuery) {
            throw QueryException.incorrectQueryObjectFound(this.getDatabaseQuery(), class$oracle$toplink$queryframework$ReadAllQuery == null ? (class$oracle$toplink$queryframework$ReadAllQuery = EJBQueryImpl.class$("oracle.toplink.queryframework.ReadAllQuery")) : class$oracle$toplink$queryframework$ReadAllQuery);
        }
        object = this.executeReadQuery();
        return (List)object;
    }

    public Object getSingleResult() {
        Object object;
        if (this.getDatabaseQuery() instanceof ReadAllQuery && !Helper.classImplementsInterface((Class)(object = ((ReadAllQuery)this.getDatabaseQuery()).getContainerPolicy().getContainerClass()), ClassConstants.List_Class)) {
            throw QueryException.invalidContainerClass((Class)object, ClassConstants.List_Class);
        }
        object = this.executeReadQuery();
        if (object instanceof List) {
            List list = (List)object;
            if (list.isEmpty()) {
                this.throwObjectNotFoundException(ExceptionLocalization.buildMessage("no_objects_retrieved_for_get_single_result", null));
            } else if (list.size() > 1) {
                this.throwNonUniqueResultException(ExceptionLocalization.buildMessage("too_many_results_for_get_single_result", null));
            }
            return list.get(0);
        }
        if (object == null) {
            this.throwObjectNotFoundException(ExceptionLocalization.buildMessage("no_objects_retrieved_for_get_single_result", null));
        }
        return object;
    }

    protected void processParameters() {
        if (this.databaseQuery == null) {
            this.getDatabaseQuery();
        }
        if (this.databaseQuery.getArguments().isEmpty()) {
            Iterator iterator = this.parameters.iterator();
            while (iterator.hasNext()) {
                this.databaseQuery.addArgument((String)iterator.next());
            }
        }
    }

    public void setDatabaseQuery(DatabaseQuery databaseQuery) {
        this.databaseQuery = databaseQuery;
    }

    protected void setFirstResultInternal(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("negative_start_position", null));
        }
        if (this.getDatabaseQuery().isReadQuery()) {
            ((ReadQuery)this.getDatabaseQuery()).setFirstResult(n);
        }
    }

    protected void throwFlushModeNotSupportedException() {
        throw ValidationException.flushModeNotSupported();
    }

    protected void setHintInternal(String string, Object object) {
        this.getDatabaseQuery();
        try {
            if (string.equals("fetchSize")) {
                if (this.databaseQuery.isReadQuery()) {
                    ((ReadQuery)this.databaseQuery).setFetchSize((Integer)object);
                }
            } else if (string.equals("referenceClass")) {
                if (this.databaseQuery.isObjectLevelReadQuery()) {
                    ((ObjectLevelReadQuery)this.databaseQuery).setReferenceClass((Class)object);
                }
            } else if (string.equals("exampleObject")) {
                if (this.databaseQuery.isObjectLevelReadQuery()) {
                    ((ObjectLevelReadQuery)this.databaseQuery).setExampleObject(object);
                }
            } else if (string.equals("cacheUsage")) {
                if (this.databaseQuery.isObjectLevelReadQuery()) {
                    ((ObjectLevelReadQuery)this.databaseQuery).setCacheUsage((Integer)object);
                }
            } else if (string.equals("refresh")) {
                if (this.databaseQuery.isObjectLevelReadQuery()) {
                    ((ObjectLevelReadQuery)this.databaseQuery).setShouldRefreshIdentityMapResult((Boolean)object);
                }
            } else if (string.equals("lockMode")) {
                if (this.databaseQuery.isObjectLevelReadQuery()) {
                    ((ObjectLevelReadQuery)this.databaseQuery).setLockMode((Short)object);
                }
            } else if (string.equals("expression")) {
                this.databaseQuery.setSelectionCriteria((Expression)object);
            } else if (string.equals("call")) {
                this.databaseQuery.setCall((Call)object);
            } else if (string.equals("timeout")) {
                this.databaseQuery.setQueryTimeout((Integer)object);
            } else if (string.equals("cascadeLevel")) {
                this.databaseQuery.setCascadePolicy((Integer)object);
            }
        }
        catch (ClassCastException classCastException) {
            Object[] objectArray = new Object[]{string};
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("incorrect_hint", objectArray));
        }
    }

    public void setMaxResultsInternal(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("negative_max_result", null));
        }
        if (this.getDatabaseQuery().isReadQuery()) {
            ((ReadQuery)this.getDatabaseQuery()).setMaxRows(n);
        }
    }

    protected void setParameterInternal(String string, Object object) {
        this.parameters.add(string);
        this.parameterValues.add(object);
    }

    protected void setParameterInternal(int n, Object object) {
        this.parameters.ensureCapacity(n + 1);
        this.parameterValues.ensureCapacity(n + 1);
        this.parameters.add(n, new Integer(n + 1).toString());
        this.parameterValues.add(n, object);
    }

    protected oracle.toplink.sessions.Session getActiveSession() {
        return this.entityManager.getActiveSession();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

