/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp.wls;

import java.util.List;
import java.util.Map;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import oracle.toplink.internal.ejb.cmp.ProjectDeployment;
import oracle.toplink.internal.ejb.cmp.wls.WlsCmpDom;
import oracle.toplink.internal.ejb.cmp.wls.WlsDescriptorBuilder;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.logging.AbstractSessionLog;
import oracle.toplink.platform.server.wls.WebLogicPlatform;
import oracle.toplink.platform.server.wls.WebLogic_6_1_Platform;
import oracle.toplink.platform.server.wls.WebLogic_7_0_Platform;
import oracle.toplink.platform.server.wls.WebLogic_8_1_Platform;
import oracle.toplink.publicinterface.DatabaseSession;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.remote.CacheSynchronizationManager;
import oracle.toplink.remote.rmi.wls.WLSClusteringService;
import oracle.toplink.services.mbean.MBeanDevelopmentServices;
import oracle.toplink.services.mbean.MBeanRuntimeServices;
import oracle.toplink.sessions.DatabaseLogin;
import weblogic.ejb20.persistence.spi.Relationships;
import weblogic.management.MBeanHome;
import weblogic.management.RemoteMBeanServer;

public class WlsProjectDeployment
extends ProjectDeployment {
    public static final String JTS_URL = "jdbc:weblogic:jts:";
    public static final String JTS_DRIVER = "weblogic.jdbc.jts.Driver";
    public static final String NON_JTS_URL = "jdbc:weblogic:pool:";
    public static final String NON_JTS_DRIVER = "weblogic.jdbc.pool.Driver";
    private int totalBeanCount = 0;
    private WlsDescriptorBuilder builder = null;
    protected static Class descriptorBuilderClass = class$oracle$toplink$internal$ejb$cmp$wls$WlsDescriptorBuilder == null ? (class$oracle$toplink$internal$ejb$cmp$wls$WlsDescriptorBuilder = WlsProjectDeployment.class$("oracle.toplink.internal.ejb.cmp.wls.WlsDescriptorBuilder")) : class$oracle$toplink$internal$ejb$cmp$wls$WlsDescriptorBuilder;
    static /* synthetic */ Class class$oracle$toplink$internal$ejb$cmp$wls$WlsDescriptorBuilder;

    public void convertOldEntityDescriptors(Object object) {
        Relationships relationships = (Relationships)((List)object).get(0);
        Map map = (Map)((List)object).get(1);
        if (this.entityDescriptors == null || !this.entityDescriptors.containsKey(map.keySet().iterator().next())) {
            this.getDescriptorBuilder().addOldDescriptors(relationships, map);
            this.entityDescriptors = this.getDescriptorBuilder().getEntityDescriptors();
        }
    }

    private WlsDescriptorBuilder getDescriptorBuilder() {
        if (this.builder == null) {
            try {
                this.builder = (WlsDescriptorBuilder)PrivilegedAccessController.newInstanceFromClass(WlsProjectDeployment.getDescriptorBuilderClass());
                this.builder.setConversionManager(this.conversionManager);
                this.builder.shouldUseRemoteRelationships = this.getCmpDom().shouldUseRemoteRelationships();
            }
            catch (Exception exception) {
                AbstractSessionLog.getLog().logThrowable(6, exception);
            }
        }
        return this.builder;
    }

    private static Class getDescriptorBuilderClass() {
        return descriptorBuilderClass;
    }

    public void setTotalBeanCount(int n) {
        this.totalBeanCount = n;
    }

    protected int getTotalBeanCount() {
        return this.totalBeanCount;
    }

    public void sessionLogin() {
        super.sessionLogin();
        this.builder = null;
    }

    protected void setServerPlatform(Session session) {
        WebLogicPlatform webLogicPlatform = new WebLogicPlatform((DatabaseSession)session);
        String string = webLogicPlatform.getServerNameAndVersion().substring(16, 19);
        if (string.equals("6.1")) {
            webLogicPlatform = new WebLogic_6_1_Platform((DatabaseSession)session);
        } else if (string.equals("8.1")) {
            webLogicPlatform = new WebLogic_8_1_Platform((DatabaseSession)session);
        } else if (string.equals("7.0")) {
            webLogicPlatform = new WebLogic_7_0_Platform((DatabaseSession)session);
        }
        webLogicPlatform.setIsCMP(true);
        ((DatabaseSession)session).setServerPlatform(webLogicPlatform);
    }

    protected void configureLogin(DatabaseLogin databaseLogin) {
        super.configureLogin(databaseLogin);
        WlsCmpDom wlsCmpDom = (WlsCmpDom)this.getCmpDom();
        String string = wlsCmpDom.getConnectionPoolName();
        if (string != null) {
            databaseLogin.useDirectDriverConnect(JTS_DRIVER, JTS_URL + wlsCmpDom.getConnectionPoolName(), "");
        } else {
            this.configureDataSource(databaseLogin, this.getCmpDom().getProjectDataSource());
        }
    }

    protected void configureReadLogin(DatabaseLogin databaseLogin) {
        super.configureReadLogin(databaseLogin);
        WlsCmpDom wlsCmpDom = (WlsCmpDom)this.getCmpDom();
        String string = wlsCmpDom.getConnectionPoolName();
        if (string != null) {
            databaseLogin.setDriverClassName(NON_JTS_DRIVER);
            databaseLogin.setConnectionString(NON_JTS_URL + wlsCmpDom.getConnectionPoolName());
        } else {
            this.configureDataSource(databaseLogin, this.getCmpDom().getNonJtsDataSource());
        }
    }

    protected void configureLoginFromDescriptor(DatabaseLogin databaseLogin) {
        Boolean bl;
        Boolean bl2;
        WlsCmpDom wlsCmpDom = (WlsCmpDom)this.getCmpDom();
        Boolean bl3 = wlsCmpDom.shouldBindAllParameters();
        if (bl3 != null) {
            if (bl3.booleanValue()) {
                databaseLogin.bindAllParameters();
            } else {
                databaseLogin.dontBindAllParameters();
            }
        }
        if ((bl2 = wlsCmpDom.shouldUseByteArrayBinding()) != null) {
            if (bl2.booleanValue()) {
                databaseLogin.useByteArrayBinding();
            } else {
                databaseLogin.dontUseByteArrayBinding();
            }
        }
        if ((bl = wlsCmpDom.shouldUseStringBinding()) != null) {
            if (bl.booleanValue()) {
                databaseLogin.useStringBinding();
            } else {
                databaseLogin.dontUseStringBinding();
            }
        }
    }

    public void initializeCacheSynchronization() {
        if (this.getCmpDom().cacheSyncEnabled()) {
            CacheSynchronizationManager cacheSynchronizationManager = new CacheSynchronizationManager();
            cacheSynchronizationManager.setClusteringService(new WLSClusteringService(this.getSession()));
            Boolean bl = this.getCmpDom().isAsynchronous();
            if (bl != null) {
                cacheSynchronizationManager.setIsAsynchronous(bl);
            }
            if ((bl = ((WlsCmpDom)this.getCmpDom()).removeConnectionOnError()) != null) {
                cacheSynchronizationManager.setShouldRemoveConnectionOnError(bl);
            }
            this.getSession().setCacheSynchronizationManager(cacheSynchronizationManager);
        }
    }

    protected void registerMBeans() {
        ObjectInstance objectInstance;
        Object object;
        AbstractSessionLog.getLog().finest("ProjectDeployment_registeringMBeans_enter");
        boolean bl = System.getProperty("toplink.register.dev.mbean") != null;
        boolean bl2 = System.getProperty("toplink.register.run.mbean") != null;
        RemoteMBeanServer remoteMBeanServer = null;
        InitialContext initialContext = null;
        if (bl || bl2) {
            try {
                initialContext = new InitialContext();
                remoteMBeanServer = ((MBeanHome)initialContext.lookup("weblogic.management.home.localhome")).getMBeanServer();
            }
            catch (Exception exception) {
                AbstractSessionLog.getLog().log(6, "failed_to_find_mbean_server", exception);
            }
        }
        ObjectName objectName = null;
        if (bl) {
            try {
                objectName = new ObjectName("TopLink_Domain:Name=Development_" + this.getSession().getName() + ",Type=Configuration");
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = new MBeanDevelopmentServices(this.getSession());
            objectInstance = null;
            try {
                objectInstance = remoteMBeanServer.registerMBean(object, objectName);
            }
            catch (Exception exception) {
                AbstractSessionLog.getLog().log(6, "problem_while_registering", exception);
            }
        }
        if (bl2) {
            try {
                objectName = new ObjectName("TopLink_Domain:Name=Runtime_" + this.getSession().getName() + ",Type=Reporting");
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = new MBeanRuntimeServices(this.getSession());
            objectInstance = null;
            try {
                objectInstance = remoteMBeanServer.registerMBean(object, objectName);
            }
            catch (Exception exception) {
                AbstractSessionLog.getLog().log(6, "problem_while_registering", exception);
            }
        }
        AbstractSessionLog.getLog().finest("ProjectDeployment_registeringMBeans_return");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

