/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.ejb.cmp.finders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import oracle.toplink.internal.ejb.cmp.finders.Finder;
import oracle.toplink.internal.ejb.cmp.finders.FinderManager;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;

public class DynamicFinder
extends Finder {
    public static final String FIND_ONE_BY_EJBQL = "findOneByEJBQL";
    public static final String FIND_MANY_BY_EJBQL = "findManyByEJBQL";
    public static final String FIND_ONE_BY_SQL = "findOneBySQL";
    public static final String FIND_MANY_BY_SQL = "findManyBySQL";
    public static final String FIND_ONE_BY_QUERY = "findOneByQuery";
    public static final String FIND_MANY_BY_QUERY = "findManyByQuery";
    private static Collection dynamicFinders = null;

    public DynamicFinder(String string, FinderManager finderManager) {
        super(null, finderManager);
        this.queryName = string;
    }

    public DynamicFinder(DatabaseQuery databaseQuery, FinderManager finderManager) {
        super(databaseQuery, finderManager);
    }

    protected DatabaseQuery getQuery() {
        if (this.query == null) {
            if (DynamicFinder.isDynamicQueryFinder(this.getQueryName())) {
                this.query = (DatabaseQuery)((Vector)this.getInputParams()).get(0);
            }
        }
        return this.query;
    }

    protected void prepareArgs() {
        Vector vector = (Vector)this.getInputParams();
        if (vector.size() > 1) {
            this.args = (Vector)vector.get(1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean shouldCloneQuery() {
        if (super.shouldCloneQuery()) return true;
        if (DynamicFinder.isDynamicEjbqlFinder(this.getQueryName())) return true;
        if (!DynamicFinder.isDynamicSqlFinder(this.getQueryName())) return false;
        return true;
    }

    protected void prepareQuery(boolean bl) {
        this.checkLockQuery();
        super.prepareQuery(bl);
        DatabaseQuery databaseQuery = this.getQuery();
        if (DynamicFinder.isDynamicQueryFinder(this.getQueryName())) {
            databaseQuery.setShouldUseWrapperPolicy(false);
            if (databaseQuery.isObjectLevelReadQuery()) {
                ((ObjectLevelReadQuery)databaseQuery).setReferenceClass(this.getFinderManager().getDescriptor().getJavaClass());
            }
        } else {
            String string = (String)((Vector)this.getInputParams()).get(0);
            if (DynamicFinder.isDynamicEjbqlFinder(this.getQueryName())) {
                databaseQuery.setEJBQLString(string);
            } else {
                databaseQuery.setSQLString(string);
            }
            if (this.getArgs() != null) {
                Iterator iterator = this.getArgs().iterator();
                int n = 1;
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    databaseQuery.addArgument(String.valueOf(n));
                    ++n;
                }
            }
        }
        this.checkLockQuery();
    }

    public static Collection getDynamicFindersList() {
        if (dynamicFinders == null) {
            dynamicFinders = new ArrayList();
            dynamicFinders.add(FIND_ONE_BY_EJBQL);
            dynamicFinders.add(FIND_MANY_BY_EJBQL);
            dynamicFinders.add(FIND_ONE_BY_SQL);
            dynamicFinders.add(FIND_MANY_BY_SQL);
            dynamicFinders.add(FIND_ONE_BY_QUERY);
            dynamicFinders.add(FIND_MANY_BY_QUERY);
        }
        return dynamicFinders;
    }

    public static boolean isDynamicFinder(String string) {
        return DynamicFinder.getDynamicFindersList().contains(string);
    }

    public static boolean isDynamicSqlFinder(String string) {
        return string.equalsIgnoreCase(FIND_ONE_BY_SQL) || string.equalsIgnoreCase(FIND_MANY_BY_SQL);
    }

    public static boolean isDynamicEjbqlFinder(String string) {
        return string.equalsIgnoreCase(FIND_ONE_BY_EJBQL) || string.equalsIgnoreCase(FIND_MANY_BY_EJBQL);
    }

    public static boolean isDynamicQueryFinder(String string) {
        return string.equalsIgnoreCase(FIND_ONE_BY_QUERY) || string.equalsIgnoreCase(FIND_MANY_BY_QUERY);
    }
}

