/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.descriptors;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ReadObjectQuery;

public class CascadeLockingPolicy {
    protected Class m_parentClass;
    protected ReadObjectQuery m_query;
    protected Descriptor m_descriptor;
    protected Descriptor m_parentDescriptor;
    protected Map m_queryKeyFields;
    protected Vector m_mappingLookupFields;
    protected DatabaseMapping m_parentMapping;

    public CascadeLockingPolicy(Descriptor descriptor, Descriptor descriptor2) {
        this.m_descriptor = descriptor2;
        this.m_parentDescriptor = descriptor;
        this.m_parentClass = this.m_parentDescriptor.getJavaClass();
    }

    protected ReadObjectQuery getQuery() {
        if (this.m_query == null) {
            this.m_query = new ReadObjectQuery(this.m_parentClass);
            Expression expression = null;
            Iterator iterator = this.m_queryKeyFields.keySet().iterator();
            ExpressionBuilder expressionBuilder = new ExpressionBuilder();
            while (iterator.hasNext()) {
                String string = ((DatabaseField)iterator.next()).getQualifiedName();
                if (expression == null) {
                    expression = expressionBuilder.getField(string).equal(expressionBuilder.getParameter(string));
                } else {
                    expression.and(expressionBuilder.getField(string).equal(expressionBuilder.getParameter(string)));
                }
                this.m_query.addArgument(string);
            }
            this.m_query.setSelectionCriteria(expression);
            this.m_query.setShouldUseWrapperPolicy(false);
        }
        return this.m_query;
    }

    protected DatabaseMapping getParentMapping() {
        if (this.m_parentMapping == null && this.m_mappingLookupFields != null && this.m_query == null) {
            boolean bl = true;
            Enumeration enumeration = this.m_mappingLookupFields.elements();
            while (enumeration.hasMoreElements()) {
                DatabaseMapping databaseMapping = this.m_descriptor.getObjectBuilder().getMappingForField((DatabaseField)enumeration.nextElement());
                if (!databaseMapping.isObjectReferenceMapping()) continue;
                this.m_parentMapping = databaseMapping;
                break;
            }
        }
        return this.m_parentMapping;
    }

    protected DatabaseRow getTranslationRow(Object object, UnitOfWork unitOfWork) {
        DatabaseRow databaseRow = new DatabaseRow();
        Iterator iterator = this.m_queryKeyFields.keySet().iterator();
        while (iterator.hasNext()) {
            DatabaseField databaseField = (DatabaseField)iterator.next();
            DatabaseField databaseField2 = (DatabaseField)this.m_queryKeyFields.get(databaseField);
            Object object2 = this.m_descriptor.getObjectBuilder().extractValueFromObjectForField(object, databaseField2, unitOfWork);
            databaseRow.add(databaseField, object2);
        }
        return databaseRow;
    }

    public void lockNotifyParent(Object object, UnitOfWorkChangeSet unitOfWorkChangeSet, UnitOfWork unitOfWork) {
        Object object2 = null;
        DatabaseMapping databaseMapping = this.getParentMapping();
        if (databaseMapping != null && databaseMapping.isObjectReferenceMapping()) {
            object2 = databaseMapping.getRealAttributeValueFromObject(object, unitOfWork);
        }
        if (object2 == null) {
            object2 = unitOfWork.executeQuery((DatabaseQuery)this.getQuery(), this.getTranslationRow(object, unitOfWork));
        } else if (this.m_parentDescriptor.hasWrapperPolicy()) {
            this.m_parentDescriptor.getWrapperPolicy().unwrapObject(object2, unitOfWork);
        }
        if (object2 != null) {
            Object object3;
            if (this.m_parentDescriptor.usesOptimisticLocking() && this.m_parentDescriptor.getOptimisticLockingPolicy().isCascaded() && !((ObjectChangeSet)(object3 = this.m_parentDescriptor.getObjectBuilder().createObjectChangeSet(object2, unitOfWorkChangeSet, unitOfWork))).hasForcedChangesFromCascadeLocking()) {
                ((ObjectChangeSet)object3).setHasForcedChangesFromCascadeLocking(true);
                unitOfWorkChangeSet.addObjectChangeSet((ObjectChangeSet)object3);
            }
            if (this.m_parentDescriptor.hasCascadeLockingPolicies()) {
                object3 = this.m_parentDescriptor.getCascadeLockingPolicies().elements();
                while (object3.hasMoreElements()) {
                    CascadeLockingPolicy cascadeLockingPolicy = (CascadeLockingPolicy)object3.nextElement();
                    cascadeLockingPolicy.lockNotifyParent(object2, unitOfWorkChangeSet, unitOfWork);
                }
            }
        }
    }

    public void setQueryKeyFields(Map map) {
        this.setQueryKeyFields(map, true);
    }

    public void setQueryKeyFields(Map map, boolean bl) {
        this.m_queryKeyFields = map;
        if (bl) {
            this.m_mappingLookupFields = NonSynchronizedVector.newInstance();
            Iterator iterator = this.m_queryKeyFields.keySet().iterator();
            while (iterator.hasNext()) {
                this.m_mappingLookupFields.add((DatabaseField)this.m_queryKeyFields.get(iterator.next()));
            }
        }
    }
}

