/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.databaseaccess;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.toplink.internal.databaseaccess.BindCallCustomParameter;
import oracle.toplink.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.objectrelational.ObjectRelationalDatabaseField;
import oracle.toplink.publicinterface.Session;

public class OutputParameterForCallableStatement
extends BindCallCustomParameter {
    protected boolean isCursor;
    protected int jdbcType;
    protected String typeName;
    protected boolean isTypeNameRequired;

    public OutputParameterForCallableStatement(DatabaseField databaseField) {
        super(databaseField);
    }

    public OutputParameterForCallableStatement(DatabaseField databaseField, DatabasePlatform databasePlatform) {
        this(databaseField, databasePlatform, false);
    }

    public OutputParameterForCallableStatement(DatabaseField databaseField, DatabasePlatform databasePlatform, boolean bl) {
        this(databaseField);
        this.isCursor = bl;
        this.prepare(databasePlatform);
    }

    public OutputParameterForCallableStatement(OutputParameterForCallableStatement outputParameterForCallableStatement) {
        super(outputParameterForCallableStatement.obj);
        this.isCursor = outputParameterForCallableStatement.isCursor;
        this.jdbcType = outputParameterForCallableStatement.jdbcType;
        this.typeName = outputParameterForCallableStatement.typeName;
        this.isTypeNameRequired = outputParameterForCallableStatement.isTypeNameRequired;
    }

    protected OutputParameterForCallableStatement() {
    }

    public void setIsCursor(boolean bl) {
        this.isCursor = bl;
    }

    public boolean isCursor() {
        return this.isCursor;
    }

    public boolean isTypeNameRequired() {
        return this.isTypeNameRequired;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public DatabaseField getOutputField() {
        return (DatabaseField)this.obj;
    }

    public void prepare(DatabasePlatform databasePlatform) {
        if (this.isCursor()) {
            this.jdbcType = databasePlatform.getCursorCode();
        } else {
            this.jdbcType = databasePlatform.getJDBCType(this.getOutputField());
            if (this.obj instanceof ObjectRelationalDatabaseField) {
                this.isTypeNameRequired = true;
                this.typeName = ((ObjectRelationalDatabaseField)this.obj).getSqlTypeName();
            } else {
                this.isTypeNameRequired = databasePlatform.requiresTypeNameToRegisterOutputParameter();
                if (this.isTypeNameRequired) {
                    this.typeName = databasePlatform.getJdbcTypeName(this.jdbcType);
                }
            }
        }
    }

    public void set(DatabasePlatform databasePlatform, PreparedStatement preparedStatement, int n, Session session) throws SQLException {
        if (this.isTypeNameRequired) {
            ((CallableStatement)preparedStatement).registerOutParameter(n, this.jdbcType, this.typeName);
        } else {
            ((CallableStatement)preparedStatement).registerOutParameter(n, this.jdbcType);
        }
    }

    public String toString() {
        return "=> " + this.getOutputField().getName();
    }
}

