/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.databaseaccess;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.expressions.ParameterExpression;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.queryframework.DatabaseQueryMechanism;
import oracle.toplink.internal.queryframework.DatasourceCallQueryMechanism;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.DatabaseQuery;

public abstract class DatasourceCall
implements Call {
    protected DatabaseQuery query;
    protected transient Vector parameters;
    protected transient Vector parameterTypes;
    public static final Integer LITERAL = new Integer(1);
    public static final Integer MODIFY = new Integer(2);
    public static final Integer TRANSLATION = new Integer(3);
    public static final Integer CUSTOM_MODIFY = new Integer(4);
    public static final Integer OUT = new Integer(5);
    public static final Integer INOUT = new Integer(6);
    public static final Integer IN = new Integer(7);
    public static final Integer OUT_CURSOR = new Integer(8);
    protected boolean isPrepared = false;
    protected int returnType = 3;
    protected static final int NO_RETURN = 1;
    protected static final int RETURN_ONE_ROW = 2;
    protected static final int RETURN_MANY_ROWS = 3;
    protected static final int RETURN_CURSOR = 4;

    public Vector getParameters() {
        if (this.parameters == null) {
            this.parameters = NonSynchronizedVector.newInstance();
        }
        return this.parameters;
    }

    public Vector getParameterTypes() {
        if (this.parameterTypes == null) {
            this.parameterTypes = NonSynchronizedVector.newInstance();
        }
        return this.parameterTypes;
    }

    public void setParameters(Vector vector) {
        this.parameters = vector;
    }

    public void setParameterTypes(Vector vector) {
        this.parameterTypes = vector;
    }

    public boolean hasParameters() {
        return this.parameters != null && !this.getParameters().isEmpty();
    }

    public boolean areManyRowsReturned() {
        return this.getReturnType() == 3;
    }

    public boolean isOutputParameterType(Integer n) {
        return n == OUT || n == INOUT || n == OUT_CURSOR;
    }

    protected boolean isPrepared() {
        return this.isPrepared;
    }

    protected void setIsPrepared(boolean bl) {
        this.isPrepared = bl;
    }

    public DatabaseQueryMechanism buildNewQueryMechanism(DatabaseQuery databaseQuery) {
        return new DatasourceCallQueryMechanism(databaseQuery, this);
    }

    public DatabaseQueryMechanism buildQueryMechanism(DatabaseQuery databaseQuery, DatabaseQueryMechanism databaseQueryMechanism) {
        if (databaseQueryMechanism.isCallQueryMechanism() && databaseQueryMechanism instanceof DatasourceCallQueryMechanism) {
            DatasourceCallQueryMechanism datasourceCallQueryMechanism = (DatasourceCallQueryMechanism)databaseQueryMechanism;
            if (!datasourceCallQueryMechanism.hasMultipleCalls()) {
                datasourceCallQueryMechanism.addCall(datasourceCallQueryMechanism.getCall());
                datasourceCallQueryMechanism.setCall(null);
            }
            datasourceCallQueryMechanism.addCall(this);
            return databaseQueryMechanism;
        }
        return this.buildNewQueryMechanism(databaseQuery);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public abstract String getLogString(Accessor var1);

    public DatabaseQuery getQuery() {
        return this.query;
    }

    public int getReturnType() {
        return this.returnType;
    }

    public boolean isCursorReturned() {
        return this.getReturnType() == 4;
    }

    public boolean isFinished() {
        return !this.isCursorReturned();
    }

    public boolean isNothingReturned() {
        return this.getReturnType() == 1;
    }

    public boolean isOneRowReturned() {
        return this.getReturnType() == 2;
    }

    public boolean isSQLCall() {
        return false;
    }

    public boolean isStoredFunctionCall() {
        return false;
    }

    public boolean isStoredProcedureCall() {
        return false;
    }

    public boolean isEJBQLCall() {
        return false;
    }

    public boolean isEISInteraction() {
        return false;
    }

    public boolean isQueryStringCall() {
        return false;
    }

    public void prepare(Session session) {
        this.setIsPrepared(true);
    }

    public void returnCursor() {
        this.setReturnType(4);
    }

    public void returnManyRows() {
        this.setReturnType(3);
    }

    public void returnNothing() {
        this.setReturnType(1);
    }

    public void returnOneRow() {
        this.setReturnType(2);
    }

    public void setQuery(DatabaseQuery databaseQuery) {
        this.query = databaseQuery;
    }

    public void setReturnType(int n) {
        this.returnType = n;
    }

    public void translate(DatabaseRow databaseRow, DatabaseRow databaseRow2, Session session) {
    }

    public String getQueryString() {
        return "";
    }

    public void setQueryString(String string) {
    }

    public void translateCustomQuery() {
        if (this.getQueryString().indexOf("#") == -1) {
            return;
        }
        int n = 0;
        boolean bl = false;
        String string = this.getQueryString();
        CharArrayWriter charArrayWriter = new CharArrayWriter(string.length() + 50);
        try {
            while (n != -1) {
                DatabaseField databaseField;
                String string2;
                int n2;
                String string3;
                int n3 = string.indexOf(35, n);
                if (n3 == -1) {
                    string3 = string.substring(n, string.length());
                    n = -1;
                } else {
                    string3 = string.substring(n, n3);
                }
                charArrayWriter.write(string3);
                if (n3 == -1) continue;
                for (n2 = n3 + 1; n2 < string.length() && this.whitespace().indexOf(string.charAt(n2)) == -1; ++n2) {
                }
                if (string.charAt(n3 + 1) == '#') {
                    if (string.charAt(n3 + 2) == '#') {
                        if (string.charAt(n3 + 3) == '#') {
                            string2 = string.substring(n3 + 4, n2);
                            databaseField = this.createField(string2);
                            this.appendInOut(charArrayWriter, databaseField);
                        } else {
                            string2 = string.substring(n3 + 3, n2);
                            databaseField = this.createField(string2);
                            this.appendOut(charArrayWriter, databaseField);
                        }
                    } else {
                        string2 = string.substring(n3 + 2, n2);
                        databaseField = this.createField(string2);
                        this.appendModify(charArrayWriter, databaseField);
                    }
                } else {
                    string2 = string.substring(n3 + 1, n2);
                    databaseField = this.createField(string2);
                    this.appendIn(charArrayWriter, databaseField);
                }
                n = n2;
            }
            this.setQueryString(((Object)charArrayWriter).toString());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    protected DatabaseField createField(String string) {
        return new DatabaseField(string);
    }

    public void appendLiteral(Writer writer, Object object) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        this.getParameters().addElement(object);
        this.getParameterTypes().addElement(LITERAL);
    }

    public void appendTranslation(Writer writer, DatabaseField databaseField) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        this.getParameters().addElement(databaseField);
        this.getParameterTypes().addElement(TRANSLATION);
    }

    public void appendModify(Writer writer, DatabaseField databaseField) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        this.getParameters().addElement(databaseField);
        this.getParameterTypes().addElement(MODIFY);
    }

    public void appendIn(Writer writer, DatabaseField databaseField) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        this.getParameters().addElement(databaseField);
        this.getParameterTypes().addElement(IN);
    }

    public void appendInOut(Writer writer, DatabaseField databaseField) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        Object[] objectArray = new Object[]{databaseField, databaseField};
        this.getParameters().addElement(objectArray);
        this.getParameterTypes().addElement(INOUT);
    }

    public void appendOut(Writer writer, DatabaseField databaseField) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        this.getParameters().addElement(databaseField);
        this.getParameterTypes().addElement(OUT);
    }

    public void appendParameter(Writer writer, Object object, Session session) {
        session.getDatasourcePlatform().appendParameter(this, writer, object);
    }

    protected char argumentMarker() {
        return '?';
    }

    protected String whitespace() {
        return ",); \n\t:";
    }

    public void translateQueryString(DatabaseRow databaseRow, DatabaseRow databaseRow2, Session session) {
        if (this.getQueryString().indexOf(this.argumentMarker()) == -1) {
            return;
        }
        if (this.getParameters().isEmpty()) {
            return;
        }
        int n = 0;
        int n2 = 0;
        String string = this.getQueryString();
        CharArrayWriter charArrayWriter = new CharArrayWriter(string.length() + 50);
        try {
            Vector vector = this.getParameters();
            this.setParameters(null);
            while (n != -1) {
                Object object;
                DatabaseField databaseField;
                String string2;
                int n3 = string.indexOf(this.argumentMarker(), n);
                if (n3 == -1) {
                    string2 = string.substring(n, string.length());
                    n = -1;
                } else {
                    string2 = string.substring(n, n3);
                }
                charArrayWriter.write(string2);
                if (n3 == -1) continue;
                Integer n4 = (Integer)this.getParameterTypes().elementAt(n2);
                if (n4 == MODIFY) {
                    databaseField = (DatabaseField)vector.elementAt(n2);
                    object = databaseRow2.get(databaseField);
                    this.appendParameter(charArrayWriter, object, session);
                } else if (n4 == CUSTOM_MODIFY) {
                    databaseField = (DatabaseField)vector.elementAt(n2);
                    object = databaseRow2.get(databaseField);
                    if (object != null) {
                        object = session.getDatasourcePlatform().getCustomModifyValueForCall(this, object, databaseField, false);
                    }
                    this.appendParameter(charArrayWriter, object, session);
                } else if (n4 == TRANSLATION) {
                    databaseField = vector.elementAt(n2);
                    object = null;
                    if (databaseField instanceof ParameterExpression) {
                        object = ((ParameterExpression)((Object)databaseField)).getValue(databaseRow, session);
                    } else {
                        DatabaseField databaseField2 = databaseField;
                        object = databaseRow.get(databaseField2);
                        if (object == null && databaseRow2 != null) {
                            object = databaseRow2.get(databaseField2);
                        }
                    }
                    this.appendParameter(charArrayWriter, object, session);
                } else if (n4 == LITERAL) {
                    databaseField = vector.elementAt(n2);
                    this.appendParameter(charArrayWriter, databaseField, session);
                } else if (n4 == IN) {
                    databaseField = vector.elementAt(n2);
                    object = this.getValueForInParameter(databaseField, databaseRow, databaseRow2, session, false);
                    this.appendParameter(charArrayWriter, object, session);
                } else if (n4 == INOUT) {
                    databaseField = vector.elementAt(n2);
                    object = this.getValueForInOutParameter(databaseField, databaseRow, databaseRow2, session);
                    this.appendParameter(charArrayWriter, object, session);
                }
                n = n3 + 1;
                ++n2;
            }
            this.setQueryString(((Object)charArrayWriter).toString());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    protected Object getValueForInParameter(Object object, DatabaseRow databaseRow, DatabaseRow databaseRow2, Session session, boolean bl) {
        Object object2 = object;
        if (object instanceof ParameterExpression) {
            object2 = ((ParameterExpression)object).getValue(databaseRow, session);
        } else if (object instanceof DatabaseField) {
            DatabaseField databaseField;
            DatabaseField databaseField2 = (DatabaseField)object;
            object2 = databaseRow.get(databaseField2);
            if (databaseRow2 != null) {
                if (object2 == null) {
                    object2 = databaseRow2.get(databaseField2);
                }
                if (object2 != null && (databaseField = databaseRow2.getField(databaseField2)) != null && session.getDatasourcePlatform().shouldUseCustomModifyForCall(databaseField)) {
                    object2 = session.getDatasourcePlatform().getCustomModifyValueForCall(this, object2, databaseField, bl);
                }
            }
            if (object2 == null && bl) {
                if (databaseField2.getType() != null) {
                    object2 = databaseField2;
                } else if (databaseRow2 != null && (databaseField = databaseRow2.getField(databaseField2)) != null && databaseField.getType() != null) {
                    object2 = databaseField;
                }
                if (object2 == null && (databaseField = databaseRow.getField(databaseField2)).getType() != null) {
                    object2 = databaseField;
                }
            }
        }
        return object2;
    }

    protected Object getValueForInOutParameter(Object object, DatabaseRow databaseRow, DatabaseRow databaseRow2, Session session) {
        Object object2 = ((Object[])object)[0];
        Object object3 = this.getValueForInParameter(object2, databaseRow, databaseRow2, session, true);
        Object object4 = ((Object[])object)[1];
        return this.createInOutParameter(object3, object4, session);
    }

    protected Object createInOutParameter(Object object, Object object2, Session session) {
        Object[] objectArray = new Object[]{object, object2};
        return objectArray;
    }
}

