/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.annotations;

import java.util.ArrayList;
import oracle.toplink.publicinterface.Session;

public class EJBAnnotationsLogger {
    private Session m_session;
    private ArrayList<String> m_ctxStrings;
    public static final int ALIAS = 0;
    public static final int COLUMN = 1;
    public static final int PK_COLUMN = 2;
    public static final int FK_COLUMN = 3;
    public static final int TABLE_NAME = 4;
    public static final int SOURCE_PK_COLUMN = 5;
    public static final int SOURCE_FK_COLUMN = 6;
    public static final int TARGET_PK_COLUMN = 7;
    public static final int TARGET_FK_COLUMN = 8;
    public static final int ONE_TO_ONE_MAPPING = 9;
    public static final int ONE_TO_MANY_MAPPING = 10;
    public static final int INHERITANCE_PK_COLUMN = 11;
    public static final int INHERITANCE_FK_COLUMN = 12;
    public static final int ASSOCIATION_TABLE_NAME = 13;
    public static final int SECONDARY_TABLE_PK_COLUMN = 14;
    public static final int SECONDARY_TABLE_FK_COLUMN = 15;
    public static final int ONE_TO_ONE_MAPPING_REFERENCE_CLASS = 16;
    public static final int ONE_TO_MANY_MAPPING_REFERENCE_CLASS = 17;
    public static final int MANY_TO_ONE_MAPPING_REFERENCE_CLASS = 18;
    public static final int MANY_TO_MANY_MAPPING_REFERENCE_CLASS = 19;
    public static final int IGNORE_MAPPING = 20;
    public static final int IGNORE_PRIMARY_KEY = 21;
    public static final int IGNORE_EMBEDDED_ID = 22;
    public static final int IGNORE_ID_CLASS = 23;
    public static final int IGNORE_VERSION_LOCKING = 24;
    public static final int IGNORE_TABLE = 25;
    public static final int IGNORE_SECONDARY_TABLE = 26;
    public static final int IGNORE_INHERITANCE = 27;
    public static final int IGNORE_GET_METHOD = 28;
    public static final int IGNORE_QUERY = 29;

    public EJBAnnotationsLogger(Session session) {
        this.m_session = session;
        this.m_ctxStrings = new ArrayList();
        this.populateContextStrings();
    }

    protected String getLoggingContextString(int n) {
        return this.m_ctxStrings.get(n);
    }

    public void log(int n, int n2, Object[] objectArray) {
        this.m_session.log(n, "ejb_annotation", this.getLoggingContextString(n2), objectArray);
    }

    public void logConfigMessage(int n, Object object) {
        this.log(4, n, new Object[]{object});
    }

    public void logConfigMessage(int n, Object object, Object object2) {
        this.log(4, n, new Object[]{object, object2});
    }

    public void logWarningMessage(int n, Object object) {
        this.log(6, n, new Object[]{object});
    }

    public void logWarningMessage(int n, Object object, Object object2) {
        this.log(6, n, new Object[]{object, object2});
    }

    protected void populateContextStrings() {
        this.m_ctxStrings.add(0, "annotation_default_alias");
        this.m_ctxStrings.add(1, "annotation_default_column");
        this.m_ctxStrings.add(2, "annotation_default_pk_column");
        this.m_ctxStrings.add(3, "annotation_default_fk_column");
        this.m_ctxStrings.add(4, "annotation_default_table_name");
        this.m_ctxStrings.add(5, "annotation_default_source_pk_column");
        this.m_ctxStrings.add(6, "annotation_default_source_fk_column");
        this.m_ctxStrings.add(7, "annotation_default_target_pk_column");
        this.m_ctxStrings.add(8, "annotation_default_target_fk_column");
        this.m_ctxStrings.add(9, "annotation_default_one_to_one_mapping");
        this.m_ctxStrings.add(10, "annotation_default_one_to_many_mapping");
        this.m_ctxStrings.add(11, "annotation_default_inheritance_pk_column");
        this.m_ctxStrings.add(12, "annotation_default_inheritance_fk_column");
        this.m_ctxStrings.add(13, "annotation_default_association_table_name");
        this.m_ctxStrings.add(14, "annotation_default_secondary_table_pk_column");
        this.m_ctxStrings.add(15, "annotation_default_secondary_table_fk_column");
        this.m_ctxStrings.add(16, "annotation_default_one_to_one_reference_class");
        this.m_ctxStrings.add(17, "annotation_default_one_to_many_reference_class");
        this.m_ctxStrings.add(18, "annotation_default_many_to_one_reference_class");
        this.m_ctxStrings.add(19, "annotation_default_many_to_many_reference_class");
        this.m_ctxStrings.add(20, "annotation_warning_ignore_mapping");
        this.m_ctxStrings.add(21, "annotation_warning_ignore_primary_key");
        this.m_ctxStrings.add(22, "annotation_warning_ignore_embedded_id");
        this.m_ctxStrings.add(23, "annotation_warning_ignore_id_class");
        this.m_ctxStrings.add(24, "annotation_warning_ignore_version_locking");
        this.m_ctxStrings.add(25, "annotation_warning_ignore_table");
        this.m_ctxStrings.add(26, "annotation_warning_ignore_secondary_table");
        this.m_ctxStrings.add(27, "annotation_warning_ignore_inheritance");
        this.m_ctxStrings.add(28, "annotation_warning_ignore_get_method");
        this.m_ctxStrings.add(29, "annotation_warning_ignore_query");
    }

    public void setSession(Session session) {
        this.m_session = session;
    }
}

