/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.ejb.cmp3.persistence;

import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.sql.DataSource;
import oracle.toplink.ejb.cmp3.persistence.PersistenceProject;
import oracle.toplink.ejb.cmp3.persistence.Property;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.ox.XMLContext;
import oracle.toplink.ox.XMLUnmarshaller;

public class PersistenceInfo {
    protected String entityManagerName;
    protected String persistenceProviderClassName;
    protected String jtaDataSourceJndiName;
    protected String nonJtaDataSourceJndiName;
    protected List mappingFiles = new Vector();
    protected List jarFiles = new Vector();
    protected List entityClassNames = new Vector();
    protected List propertiesFromXML = new Vector();
    protected Properties properties;
    protected ClassLoader loader;
    protected URL persistenceXmlFileUrl;
    protected URL entityMappingsXmlFileUrl;

    public static PersistenceInfo getPersistenceInfo(InputStream inputStream) {
        XMLContext xMLContext = new XMLContext(new PersistenceProject());
        XMLUnmarshaller xMLUnmarshaller = xMLContext.createUnmarshaller();
        PersistenceInfo persistenceInfo = (PersistenceInfo)xMLUnmarshaller.unmarshal(inputStream);
        if (!persistenceInfo.getJarFiles().isEmpty()) {
            throw ValidationException.jarFilesInPersistenceXmlNotSupported();
        }
        return persistenceInfo;
    }

    public String getEntityManagerName() {
        return this.entityManagerName;
    }

    public String getPersistenceProviderClassName() {
        return this.persistenceProviderClassName;
    }

    public DataSource getJtaDataSource() {
        return null;
    }

    public String getJtaDataSourceJndiName() {
        return this.jtaDataSourceJndiName;
    }

    public DataSource getNonJtaDataSource() {
        return null;
    }

    public String getNonJtaDataSourceJndiName() {
        return this.nonJtaDataSourceJndiName;
    }

    public List getMappingFileNames() {
        return this.mappingFiles;
    }

    public List getJarFiles() {
        return this.jarFiles;
    }

    public List getEntityClassNames() {
        return this.entityClassNames;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
            Iterator iterator = this.propertiesFromXML.iterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                this.properties.put(property.name, property.value);
            }
        }
        return this.properties;
    }

    public List getPropertiesFromXML() {
        return this.propertiesFromXML;
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public URL getPersistenceXmlFileUrl() {
        return null;
    }

    public URL getEntityMappingsXmlFileUrl() {
        return null;
    }

    public void setEntityManagerName(String string) {
        this.entityManagerName = string;
    }

    public void setPersistenceProviderClassName(String string) {
        this.persistenceProviderClassName = string;
    }

    public void setJtaDataSource(DataSource dataSource) {
    }

    public void setJtaDataSourceJndiName(String string) {
        this.jtaDataSourceJndiName = string;
    }

    public void setNonJtaDataSource(DataSource dataSource) {
    }

    public void setNonJtaDataSourceJndiName(String string) {
        this.nonJtaDataSourceJndiName = string;
    }

    public void setMappingFileNames(List list) {
        this.mappingFiles = list;
    }

    public void setJarFiles(List list) {
        this.jarFiles = list;
    }

    public void setEntityClassNames(List list) {
        this.entityClassNames = list;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setPropertiesFromXML(List list) {
        this.propertiesFromXML = list;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    public void setPersistenceXmlFileUrl(URL uRL) {
        this.persistenceXmlFileUrl = uRL;
    }

    public void setEntityMappingsXmlFileUrl(URL uRL) {
        this.entityMappingsXmlFileUrl = uRL;
    }
}

