/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.ejb.cmp.was.deploy;

import com.ibm.ivj.ejb.tools.analyzer.EJBean;
import com.ibm.ivj.ejb.tools.codeGenerator.EJBCodegenException;
import com.ibm.ivj.ejb.tools.codeGenerator.EJBGenFinderIntf;
import com.ibm.ivj.ejb.tools.codeGenerator.EJBGenHomeSession;
import com.ibm.ivj.ejb.tools.codeGenerator.EJBGenRemoteSession;
import com.ibm.ivj.ejb.tools.codeGenerator.EJBGenerator;
import com.ibm.ivj.ejb.tools.deployment.EJBDeploy;
import com.ibm.ivj.ejb.tools.deployment.EJBDeployException;
import com.ibm.ivj.ejb.tools.deployment.EJBDeployResourceHandler;
import com.ibm.ivj.ejb.tools.deployment.EJBJar;
import com.ibm.ivj.ejb.tools.utilities.FileUtils;
import com.ibm.ivj.ejb.tools.utilities.JarEntry;
import com.ibm.ivj.ejb.tools.utilities.JarUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.ejb.deployment.DeploymentDescriptor;
import oracle.toplink.ejb.cmp.was.deploy.CodeGenHomeEntity;
import oracle.toplink.ejb.cmp.was.deploy.CodeGenPersister;
import oracle.toplink.ejb.cmp.was.deploy.CodeGenRemoteEntity;
import oracle.toplink.ejb.cmp.was.deploy.CodeGenRemoteHome;
import oracle.toplink.ejb.cmp.was.deploy.DeployHelper;
import oracle.toplink.ejb.cmp.was.deploy.TopLinkEJBean;
import oracle.toplink.ejb.cmp.was.deploy.TopLinkEntityDescriptor;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.localization.ExceptionLocalization;
import oracle.toplink.tools.ejbjar.EjbJar;
import oracle.toplink.tools.ejbjar.EnterpriseObject;
import oracle.toplink.tools.ejbjar.XMLManager;
import oracle.toplink.tools.file.FileUtil;
import sun.tools.javac.Main;

public class Deploy
extends EJBDeploy {
    String classpath = "";
    private Vector tlremoteImplClasses = new Vector();
    private String tlJVMOptions = "";
    private Hashtable srcFiles = new Hashtable();
    private Vector ejsJarEntries = new Vector();
    private boolean ejsJarCreated = false;
    private Hashtable ejsJarEntryNames = new Hashtable();
    private boolean ejbJarProcessed = false;
    protected static final String ROOTDIR = "__ejbjar";
    protected static boolean statusOK = true;
    private EJBean[] ejbeans = null;
    public Vector messages = new Vector();
    protected static Vector packages = new Vector();
    private static EJBDeployResourceHandler resourceHandler = new EJBDeployResourceHandler(Locale.getDefault());
    String wsHome;
    String wsJDKHome;
    String extraClasspath = "";
    boolean traceFlag = false;
    String copySourceDir;
    private EjbJar ejbJarXml;

    private void addEJSJarEntry(JarEntry jarEntry) {
        String string = jarEntry.getZipEntry().getName();
        if (this.ejsJarEntryNames.containsKey(string)) {
            for (int i = 0; i < this.ejsJarEntries.size(); ++i) {
                String string2 = ((JarEntry)this.ejsJarEntries.elementAt(i)).getZipEntry().getName();
                if (!string2.equals(string)) continue;
                this.ejsJarEntries.setElementAt(jarEntry, i);
            }
        } else {
            this.ejsJarEntryNames.put(string, "");
            this.ejsJarEntries.addElement(jarEntry);
        }
    }

    private void addEJSJarEntry(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.addEJSJarEntry((JarEntry)vector.elementAt(i));
        }
    }

    public void addMessage(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.messages.addElement(stringArray[i]);
        }
    }

    private static String assembleFilePath(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer(20);
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(File.separatorChar);
        }
        stringBuffer.append(stringArray[stringArray.length - 1]);
        return string + File.separatorChar + stringBuffer.toString();
    }

    public void close() {
        if (!this.ejbJarProcessed || !this.ejsJarCreated || this.doNotClean) {
            return;
        }
        String string = this.getWorkingDir();
        Deploy.trace("\nEJBDeploy: close(): Cleaning up working directory " + string);
        try {
            File file = new File(string);
            FileUtils.deleteDirTree((File)file);
        }
        catch (IOException iOException) {
            Deploy.trace("EJBDeploy: close(): Exception during removal of working directory " + string, iOException);
        }
        this.ejbJarProcessed = false;
        this.ejsJarCreated = false;
    }

    private void compileClasses() throws EJBDeployException {
        Deploy.trace("\nEJBDeploy: compileClasses(): Searching for source files...");
        try {
            this.findSrcFiles(new File(this.getWorkingDir()), null);
        }
        catch (Exception exception) {
            Deploy.trace("EJBDeploy: compileClasses(): Exception occured while searching for source files", exception);
        }
        if (this.srcFiles.size() == 0) {
            return;
        }
        Deploy.trace("\nEJBDeploy: compileClasses(): Compiling generated classes...");
        String[] stringArray = new String[]{"-d", this.getWorkingDir(), "-classpath", this.processOSPath(this.getClasspath())};
        String[] stringArray2 = new String[stringArray.length + this.srcFiles.size()];
        String string = "sun.tools.javac.Main";
        int n = stringArray.length;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
            string = string + " " + stringArray[i];
        }
        Main main = this.srcFiles.keys();
        while (main.hasMoreElements()) {
            stringArray2[n] = (String)main.nextElement();
            string = string + "\n          " + stringArray2[n];
            ++n;
        }
        Deploy.trace("     javac command line:");
        Deploy.trace("          " + string);
        try {
            main = new Main((OutputStream)System.err, "javac");
            if (!main.compile(stringArray2)) {
                throw new EJBDeployException("DP_COMPILE_ERROR");
            }
        }
        catch (Exception exception) {
            throw new EJBDeployException("DP_COMPILE_ERROR");
        }
    }

    private boolean copyGeneratedSourcesToDir() {
        if (this.copySourceDir == null) {
            return true;
        }
        try {
            Deploy.trace("   Copy sources to " + this.copySourceDir + " ...");
            FileUtil.copy(this.getWorkingDir(), this.copySourceDir, new String[]{".java"});
        }
        catch (Exception exception) {
            Deploy.trace("   Copy sources: error");
            exception.printStackTrace(System.err);
            return false;
        }
        Deploy.trace("   Copy session bean generated sources: succeed");
        return true;
    }

    public boolean createEJSJar() {
        try {
            if (!this.getReDeployJar()) {
                try {
                    FileUtils.copyFile((String)this.getEJBJarFilename(), (String)this.getEJSJarFilename());
                }
                catch (Exception exception) {
                    Deploy.trace("EJBDeploy: createEJSJar(): Exception occured during jar copy", exception);
                    throw new EJBDeployException("DP_JAR_CREATION_FAILED", this.getEJSJarFilename());
                }
                return true;
            }
            if (!this.ejbJarProcessed) {
                return false;
            }
            if (this.codegenOnly) {
                this.generateClasses();
                return true;
            }
            this.generateClasses();
            this.compileClasses();
            if (!this.skipStubsGeneration) {
                this.generateTies();
            }
            this.compileClasses();
            try {
                JarUtils.createJar((String)this.getEJSJarFilename(), (Vector)this.ejsJarEntries, (String)this.getWorkingDir(), (boolean)this.noCompressJar);
            }
            catch (Exception exception) {
                Deploy.trace("EJBDeploy: createEJSJar(): Exception occured during jar creation", exception);
                throw new EJBDeployException("DP_JAR_CREATION_FAILED", this.getEJSJarFilename());
            }
            this.ejsJarCreated = true;
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean deploySessionBeans(String string) {
        if (this.ejbJarXml.getSessions() == null || this.ejbJarXml.getSessions().isEmpty()) {
            return true;
        }
        Deploy.trace("\nSession bean code generation: ...");
        String string2 = string + File.separator + "_toplink_sessionBeanTemp.jar";
        String string3 = string + File.separator + "_toplink_deploy_sessionBean.jar";
        Vector vector = this.ejbJarXml.getEnterpriseObjects();
        this.ejbJarXml.setEnterpriseObjects(this.ejbJarXml.getSessions());
        File file = (File)FileUtil.findFiles(this.getWorkingDir(), new String[]{"ejb-jar.xml"}).firstElement();
        File file2 = new File(string + File.separator + "temp_ejb_jar.xml");
        boolean bl = false;
        try {
            FileUtil.copy(file.getAbsolutePath(), file2.getAbsolutePath(), null);
            XMLManager.writeEjbXmlFileFromEjbJar(this.ejbJarXml, file.getAbsolutePath(), false);
            this.ejbJarXml.setEnterpriseObjects(vector);
            this.invokeJar(string2, this.getWorkingDir());
            this.invokeWASEjbDeploy(string2, string3, string);
            if (new File(string3).exists()) {
                bl = true;
            }
            FileUtil.copy(file2.getAbsolutePath(), file.getAbsolutePath(), null);
            String string4 = string + File.separator + "_._toplink_deploy_sessionBean.jar._";
            String string5 = string4 + File.separator + "_toplink_deploy_sessionBean.jar" + File.separator + "ejbModule";
            FileUtil.copy(string5, this.getWorkingDir(), new String[]{".java"});
            FileUtil.delete(file2);
            FileUtil.delete(new File(string2));
            FileUtil.delete(new File(string3));
            FileUtil.delete(new File(string4));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return bl;
    }

    private void findSrcFiles(File file, String string) throws IOException {
        if (!file.exists()) {
            return;
        }
        String string2 = file.getName();
        if (file.isDirectory()) {
            string = string == null ? " @ " : (string.equals(" @ ") ? string2 : string + "/" + string2);
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                this.findSrcFiles(new File(file, stringArray[i]), string);
            }
        } else if (string2.endsWith(".java")) {
            String string3 = file.getAbsolutePath();
            Deploy.trace("     Found " + string3);
            this.srcFiles.put(string3, "");
            string2 = string2.substring(0, string2.lastIndexOf(".java")) + ".class";
            string3 = string3.substring(0, string3.lastIndexOf(".java")) + ".class";
            this.addEJSJarEntry(new JarEntry(string + "/" + string2, string3));
        }
    }

    private void generateClasses() throws EJBCodegenException {
        String string = this.getWorkingDir();
        for (int i = 0; i < this.ejbeans.length; ++i) {
            DeploymentDescriptor deploymentDescriptor = this.ejbeans[i].getDeploymentDescriptor();
            String string2 = deploymentDescriptor.getEnterpriseBeanClassName();
            String string3 = deploymentDescriptor.getHomeInterfaceClassName();
            String string4 = deploymentDescriptor.getRemoteInterfaceClassName();
            EJBGenerator.getPackageName((String)string3);
            String string5 = EJBGenerator.getPackageName((String)string4);
            String string6 = string + File.separator + EJBGenerator.getPackageName((String)string2).replace('.', File.separatorChar);
            String string7 = string + File.separator + EJBGenerator.getPackageName((String)string3).replace('.', File.separatorChar);
            String string8 = string + File.separator + EJBGenerator.getPackageName((String)string4).replace('.', File.separatorChar);
            Deploy.trace("\nEJBDeploy: generateClasses(): Generating home remote implementation class for bean " + string2);
            Object object = new CodeGenRemoteHome(this.ejbeans[i], string8);
            object.generate();
            this.tlremoteImplClasses.addElement(string5 + "." + object.getEJSClassName());
            Deploy.trace("     Class name: " + object.getEJSClassName());
            if (this.ejbeans[i].isSessionBean()) {
                Deploy.trace("\nEJBDeploy: generateClasses(): Generating home implementation class for session bean " + string2);
                object = new EJBGenHomeSession(this.ejbeans[i], string7);
                object.generate();
                Deploy.trace("     Class name: " + object.getEJSClassName());
                Deploy.trace("\nEJBDeploy: generateClasses(): Generating remote implementation class for session bean " + string2);
                object = new EJBGenRemoteSession(this.ejbeans[i], string8);
                object.generate();
                this.tlremoteImplClasses.addElement(string5 + "." + object.getEJSClassName());
                Deploy.trace("     Class name: " + object.getEJSClassName());
                continue;
            }
            if (!this.ejbeans[i].isEntityBean()) continue;
            Deploy.trace("\nEJBDeploy: generateClasses(): Generating home implementation class for entity bean " + string2);
            object = new CodeGenHomeEntity(this.ejbeans[i], string7);
            object.generate();
            Deploy.trace("     Class name: " + object.getEJSClassName());
            Deploy.trace("\nEJBDeploy: generateClasses(): Generating remote implementation class for entity bean " + string2);
            object = new CodeGenRemoteEntity(this.ejbeans[i], string8);
            object.generate();
            this.tlremoteImplClasses.addElement(string5 + "." + object.getEJSClassName());
            Deploy.trace("     Class name: " + object.getEJSClassName());
            if (!this.ejbeans[i].hasCMPFields()) continue;
            Deploy.trace("\nEJBDeploy: generateClasses(): Generating finder interface class for entity bean " + string2);
            object = new EJBGenFinderIntf(this.ejbeans[i], string6);
            object.generate();
            Deploy.trace("     Class name: " + object.getEJSClassName());
            Deploy.trace("\nEJBDeploy: generateClasses(): Generating persistance manager class for entity bean " + string2);
            object = new CodeGenPersister(this.ejbeans[i], string6);
            object.generate();
            Deploy.trace("     Class name: " + object.getEJSClassName());
        }
    }

    private void generateTies() throws EJBDeployException {
        if (this.tlremoteImplClasses.size() == 0) {
            return;
        }
        Deploy.trace("\nEJBDeploy: generateTies(): Generating ties for implementation classes...");
        this.invokeStubCompiler(this.tlremoteImplClasses);
    }

    public static String getWASRuntimeClasspath(String string) {
        String string2 = "";
        String string3 = System.getProperty("path.separator");
        String[][] stringArrayArray = new String[][]{{"lib", "ejbcontainer.jar"}, {"lib", "j2ee.jar"}, {"lib", "ujc.jar"}, {"lib", "vaprt.jar"}, {"lib", "csicpi.jar"}, {"lib", "ras.jar"}, {"lib", "utils.jar"}, {"java", "lib", "tools.jar"}};
        for (int i = 0; i < stringArrayArray.length; ++i) {
            string2 = string2 + Deploy.assembleFilePath(stringArrayArray[i], string);
            if (i >= stringArrayArray.length - 1) continue;
            string2 = string2 + string3;
        }
        return string2;
    }

    private String getClasspath() {
        String string = "";
        String string2 = System.getProperty("path.separator");
        string = string + this.getEJBJarFilename() + string2;
        string = string + this.extraClasspath + string2;
        string = string + this.getWorkingDir() + string2;
        string = string + Deploy.getWASRuntimeClasspath(this.wsHome);
        return string;
    }

    public String[] getMessages() {
        String[] stringArray = super.getMessages();
        this.addMessage(stringArray);
        Object[] objectArray = new String[this.messages.size() + stringArray.length];
        this.messages.trimToSize();
        this.messages.copyInto(objectArray);
        return objectArray;
    }

    private void handleUsageError() {
        System.err.println("\nUSAGE:   Deploy SourceJarFile [WorkingDir] [DeployedJarFile] [WASHome] [WASJdkHome] [Classpath] [OPTIONS]");
        System.err.println("i.e  java Deploy  C:\\EJB.jar  C:\\temp  C:\\DeployedEJB.jar  C:\\WebSphere\\AppServer  C:\\WebSphere\\AppServer\\java  %TopLinkClasspath%;resource.jar  -trace\n");
        System.err.println("\tSourceJarFile\t\tFilename of EJB .jar file to be deployed");
        System.err.println("\tWorkingDir\t\tDirectory name for temporary storage of extracted files and generated classes");
        System.err.println("\t\t\t\t(not required for -analyze option)");
        System.err.println("\tDeployedJarFile\t\tFilename of deployed .jar file");
        System.err.println("\t\t\t\t(not required for -analyze or -codegen options)");
        System.err.println("\tWASHome\t\tDirectory name for WebSphere Application Server home (i.e C:\\WebSphere\\AppServer)");
        System.err.println("\tWASJdkHome\t\tDirectory name for WebSphere Application Server JDK home (i.e C:\\WebSphere\\AppServer\\java)");
        System.err.println("\t\t\t\t(not required for -analyze or -codegen options)");
        System.err.println("\tClasspath\t\tTopLink's classpath and other resources ");
        System.err.println("\t\t\t\t(not required for -analyze or -codegen options)");
        System.err.println("OPTIONS:");
        System.err.println("\t-copySourceToDir<dir>\t\tCopy to a directory name all .java files from the extracted files and generated files");
        System.err.println("\t-analyze\t\tAnalyze/Verify enterprise beans only");
        System.err.println("\t-codegen\t\tGenerate EJB server implementation classes only");
        System.err.println("\t-force\t\t\tIgnore verification errors");
        System.err.println("\t-J<option>\t\t\tPass options to the Java VM used to invoke the");
        System.err.println("\t\t\t\tRMIC compiler (i.e. -Jmx128m to set maximum heap size)");
        System.err.println("\t-noclean\t\tPreserve the working directory and generated classes");
        System.err.println("\t-nodeploy\t\tDon't deploy if EJB .jar already deployed");
        System.err.println("\t-nocompress\t\tDon't compress deployed .jar file");
        System.err.println("\t-skipstubs\t\tSkip RMIC stubs/ties generation");
        System.err.println("\t-trace\t\t\tTurn on tracing");
    }

    private void invokeJar(String string, String string2) throws Exception {
        String string3;
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        File file = (File)FileUtil.findFiles(string2, new String[]{".MF", ".mf"}).firstElement();
        String string4 = "";
        string4 = this.wsJDKHome + File.separator + "bin" + File.separator + "jar cvfm " + this.processOSPath(string) + " " + this.processOSPath(file.getAbsolutePath()) + " " + "-C " + this.processOSPath(string2) + " " + ".";
        Deploy.trace("\njar command line: ");
        Deploy.trace("     " + string4);
        process = runtime.exec(string4);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((string3 = bufferedReader.readLine()) != null) {
            if (string3 == null) continue;
            Deploy.trace(string3);
        }
        bufferedReader.close();
        process.waitFor();
        int n = process.exitValue();
        Deploy.trace("     jar return code = " + n);
        if (n != 0) {
            throw new RuntimeException(ExceptionLocalization.buildMessage("error_executing_jar_process"));
        }
    }

    private void invokeWASEjbDeploy(String string, String string2, String string3) throws Exception {
        String string4;
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        String string5 = "";
        string5 = this.wsHome + File.separator + "bin" + File.separator;
        String string6 = System.getProperty("os.name");
        string5 = string6 != null && string6.startsWith("Windows") ? string5 + "ejbdeploy.bat " : string5 + "ejbdeploy.sh ";
        string5 = string5 + this.processOSPath(string) + " " + this.processOSPath(string3) + " " + this.processOSPath(string2) + " " + "-cp " + this.processOSPath(this.extraClasspath) + " " + "-keep ";
        if (this.traceFlag) {
            string5 = string5 + "-trace";
        }
        Deploy.trace("\nejbdeploy.bat command line: ");
        Deploy.trace("     " + string5);
        process = runtime.exec(string5);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((string4 = bufferedReader.readLine()) != null) {
            if (string4 == null) continue;
            Deploy.trace(string4);
        }
        bufferedReader.close();
        process.waitFor();
        int n = process.exitValue();
        Deploy.trace("     ejbdeploy.bat return code = " + n);
        if (n != 0) {
            throw new RuntimeException("Error executing jar process");
        }
    }

    private void invokeStubCompiler(Vector vector) throws EJBDeployException {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        String string = "";
        string = this.wsJDKHome + File.separator + "bin" + File.separator + "java " + " -classpath " + this.processOSPath(this.getClasspath()) + " " + this.tlJVMOptions + " sun.rmi.rmic.Main " + " -classpath " + this.processOSPath(this.getClasspath()) + " -keep -iiop -g -d " + this.processOSPath(this.getWorkingDir());
        for (int i = 0; i < vector.size(); ++i) {
            try {
                String string2;
                String string3 = string + " " + (String)vector.elementAt(i);
                Deploy.trace("     rmic command line: ");
                Deploy.trace("     " + string3);
                process = runtime.exec(string3);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2 == null) continue;
                    Deploy.trace(string2);
                }
                bufferedReader.close();
                process.waitFor();
                process.waitFor();
                int n = process.exitValue();
                Deploy.trace("     rmic return code = " + n);
                if (n == 0) continue;
                throw new EJBDeployException("DP_STUBSGEN_ERROR");
            }
            catch (InterruptedException interruptedException) {
                if (process != null) {
                    process.destroy();
                }
                Deploy.trace("EJBDeploy: generateTies(): InterruptedException occured during rmic execution", interruptedException);
                throw new EJBDeployException("DP_TOOL_EXCEPTION", "rmic");
            }
            catch (IOException iOException) {
                if (process != null) {
                    process.destroy();
                }
                Deploy.trace("EJBDeploy: generateTies(): IOException occured during rmic execution", iOException);
                throw new EJBDeployException("DP_TOOL_EXCEPTION", "rmic");
            }
            catch (Throwable throwable) {
                if (process != null) {
                    process.destroy();
                }
                Deploy.trace("EJBDeploy: generateTies(): Error occured during rmic execution:" + throwable.getClass(), throwable);
                throw new EJBDeployException("DP_TOOL_EXCEPTION", "rmic");
            }
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2;
        int n;
        Deploy deploy = new Deploy();
        boolean bl = true;
        String string = null;
        String string2 = null;
        String string3 = null;
        for (n = 0; n < stringArray.length; ++n) {
            if (n == 0) {
                string = stringArray[n];
                continue;
            }
            if (n == 1) {
                string2 = DeployHelper.removeTrailingFileSeparator(stringArray[n]);
                continue;
            }
            if (n == 2) {
                string3 = stringArray[n];
                continue;
            }
            if (n == 3) {
                deploy.wsHome = DeployHelper.removeTrailingFileSeparator(stringArray[n]);
                continue;
            }
            if (n == 4) {
                deploy.wsJDKHome = DeployHelper.removeTrailingFileSeparator(stringArray[n]);
                continue;
            }
            if (n == 5) {
                deploy.extraClasspath = stringArray[n];
                continue;
            }
            if (stringArray[n].startsWith("-trace")) {
                EJBDeploy.traceOn((boolean)true);
                deploy.traceFlag = true;
                continue;
            }
            if (stringArray[n].startsWith("-analyze")) {
                deploy.analyzeOnly = true;
                deploy.codegenOnly = false;
                continue;
            }
            if (stringArray[n].startsWith("-codegen")) {
                deploy.codegenOnly = true;
                deploy.analyzeOnly = false;
                continue;
            }
            if (stringArray[n].startsWith("-noclean")) {
                deploy.doNotClean = true;
                continue;
            }
            if (stringArray[n].startsWith("-force")) {
                deploy.ignoreErrors = true;
                continue;
            }
            if (stringArray[n].startsWith("-nodeploy")) {
                bl = false;
                continue;
            }
            if (stringArray[n].startsWith("-nocompress")) {
                deploy.noCompressJar = true;
                continue;
            }
            if (stringArray[n].startsWith("-J")) {
                deploy.tlJVMOptions = deploy.tlJVMOptions + "-" + stringArray[n].substring(2) + " ";
                continue;
            }
            if (stringArray[n].startsWith("-skipstubs")) {
                deploy.skipStubsGeneration = true;
                continue;
            }
            if (stringArray[n].startsWith("-droptables")) {
                deploy.dropTables = true;
                continue;
            }
            if (!stringArray[n].startsWith("-copySourceToDir")) continue;
            deploy.copySourceDir = DeployHelper.removeTrailingFileSeparator(stringArray[n + 1]);
        }
        deploy.setJVMOptions(deploy.tlJVMOptions);
        for (n = 0; n < stringArray.length; ++n) {
            if (!(deploy.analyzeOnly && n <= 0 && stringArray[n].startsWith("-") || deploy.codegenOnly && n <= 1 && stringArray[n].startsWith("-")) && (deploy.analyzeOnly || deploy.codegenOnly || n > 4 || !stringArray[n].startsWith("-"))) continue;
            deploy.handleUsageError();
            return;
        }
        if (deploy.analyzeOnly && stringArray.length < 1 || deploy.codegenOnly && stringArray.length < 2 || !deploy.analyzeOnly && !deploy.codegenOnly && stringArray.length < 6) {
            deploy.handleUsageError();
            return;
        }
        deploy.setEJBJarFilename(string);
        deploy.setWorkingDir(string2);
        deploy.setEJSJarFilename(string3);
        try {
            deploy.ejbJarXml = DeployHelper.getEjbJar(deploy.getEJBJarFilename());
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return;
        }
        String string4 = deploy.getWorkingDir();
        statusOK = deploy.open();
        deploy.setReDeployJar(bl);
        if (!deploy.deploySessionBeans(string4)) {
            Deploy.trace("\nSession bean code generation: error ");
            return;
        }
        if (!deploy.analyzeOnly) {
            boolean bl2 = statusOK = statusOK && deploy.createEJSJar();
            if (!deploy.copyGeneratedSourcesToDir()) {
                return;
            }
            deploy.close();
        }
        if ((stringArray2 = deploy.getMessages()).length > 0) {
            System.err.println("EJBDeploy: Messages:\n");
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            System.err.println(stringArray2[i] + "\n");
        }
        if (!statusOK) {
            System.err.println("EJBDeploy: there was error during deployment");
        } else {
            Deploy.trace("EJBDeploy: finished");
        }
    }

    public boolean open() {
        String[] stringArray;
        Object object;
        String string = this.getEJBJarFilename();
        String string2 = null;
        boolean bl = false;
        this.ejbJarProcessed = false;
        this.ejsJarCreated = false;
        if (!this.analyzeOnly) {
            try {
                this.setupWorkingDir();
                string2 = this.getWorkingDir();
            }
            catch (EJBDeployException eJBDeployException) {
                eJBDeployException.printStackTrace();
                return false;
            }
        }
        Deploy.trace("\nEJBDeploy: open(): Processing jar file " + string);
        try {
            int n;
            Vector<DeploymentDescriptor> vector = new Vector<DeploymentDescriptor>();
            try {
                if (this.ejbJarXml != null) {
                    for (n = 0; n < this.ejbJarXml.getEntities().size(); ++n) {
                        vector.addElement(DeployHelper.buildDeploymentDescriptor((EnterpriseObject)this.ejbJarXml.getEntities().elementAt(n)));
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                bl = true;
            }
            this.ejbeans = new EJBean[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                this.ejbeans[n] = new TopLinkEJBean((DeploymentDescriptor)vector.elementAt(n));
            }
            EJBJar eJBJar = new EJBJar(string, string2);
            object = DeployHelper.parseJarErrors(eJBJar.getMessages(), this.ejbeans != null);
            bl = ((String[])object).length != 0;
            this.addMessage((String[])object);
            if (!bl) {
                this.addEJSJarEntry(eJBJar.getJarEntries());
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            object = noClassDefFoundError.getMessage() + "\n" + Helper.printStackTraceToString(noClassDefFoundError);
            stringArray = "The specified class was not found. Please ensure that the required class is listed on your system classpath.";
            System.err.println((String)stringArray + "\n" + (String)object);
        }
        if (this.ejbeans != null) {
            String string3;
            int n;
            for (n = 0; n < this.ejbeans.length; ++n) {
                string3 = this.ejbeans[n].getDeploymentDescriptor().getEnterpriseBeanClassName();
                String string4 = string3.substring(0, string3.lastIndexOf("."));
                object = System.getProperty("file.separator");
                string4 = this.replaceSeparator('.', (String)object, string4);
                if (!packages.contains(string4)) {
                    packages.addElement(string4);
                }
                String string5 = this.ejbeans[n].getDeploymentDescriptor().getRemoteInterfaceClassName();
                string5 = EJBGenerator.getPackageNameWithDot((String)string5) + EJBGenRemoteSession.getEJSClassName((String)string5);
                string5 = string5.replace('.', '/') + ".class";
            }
            if (this.isDeployed()) {
                Deploy.trace("\nEJBDeploy: open(): EJB .jar file is already possibly deployed...");
            }
            for (n = 0; n < this.ejbeans.length; ++n) {
                object = this.ejbeans[n].getDeploymentDescriptor();
                string3 = object.getEnterpriseBeanClassName();
                Deploy.trace("\nEJBDeploy: open(): Verifying EJB " + string3);
                if (!this.ejbeans[n].verify()) {
                    bl = true;
                }
                stringArray = this.ejbeans[n].getMessages();
                if (this.ejbeans[n].isEntityBean()) {
                    TopLinkEntityDescriptor topLinkEntityDescriptor = (TopLinkEntityDescriptor)((Object)object);
                    boolean bl2 = bl = (stringArray = DeployHelper.parseEntityBeanErrors(stringArray, topLinkEntityDescriptor.usesCompoundKey())).length != 0;
                    if (topLinkEntityDescriptor.usesCompoundKey()) {
                        for (int i = 0; i < topLinkEntityDescriptor.getContainerManagedFields().length; ++i) {
                            Field field = topLinkEntityDescriptor.getContainerManagedFields()[i];
                            if (!field.getType().getName().equals(topLinkEntityDescriptor.getPrimaryKeyClassName())) continue;
                            String[] stringArray2 = new String[]{"ERROR:  The entity bean uses a compound key for its primary key field but the one of the CMP fields,  '" + field.getName() + "' specified in the ejb-jar.xml is of the same compound key class type " + topLinkEntityDescriptor.getPrimaryKeyClassName() + ".  The entity bean should use non-compound key and choose a CMP field as primary key field."};
                            this.addMessage(stringArray2);
                            bl = true;
                            break;
                        }
                    }
                }
                this.addMessage(stringArray);
            }
        }
        if (bl && !this.ignoreErrors) {
            return false;
        }
        this.ejbJarProcessed = true;
        return true;
    }

    public String replaceSeparator(char c, String string, String string2) {
        int n = string2.indexOf(46);
        while (n != -1) {
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1, string2.length());
            string2 = string3 + string + string4;
            n = string2.indexOf(46);
        }
        return string2;
    }

    private void setupWorkingDir() throws EJBDeployException {
        String string = this.getWorkingDir();
        Deploy.trace("EJBDeploy: setupWorkingDir(): Setting up working directory " + string);
        File file = new File(string);
        if (!file.isDirectory()) {
            Deploy.trace("EJBDeploy: setupWorkingDir(): Directory " + string + " is invalid");
            throw new EJBDeployException("DP_INVALID_WORKING_DIR", string);
        }
        if (!file.canWrite()) {
            Deploy.trace("EJBDeploy: setupWorkingDir(): Cannot write to directory " + string);
            throw new EJBDeployException("DP_WORKING_DIR_WRITE", string);
        }
        try {
            string = string + File.separator + ROOTDIR;
            file = new File(string);
            if (file.exists()) {
                Deploy.trace("EJBDeploy: setupWorkingDir(): Deleting directory " + string);
                FileUtils.deleteDirTree((File)file);
            }
            if (!file.mkdir()) {
                Deploy.trace("EJBDeploy: setupWorkingDir(): Cannot create temporary directory " + string);
                throw new EJBDeployException("DP_WORKING_DIR_WRITE", string);
            }
        }
        catch (IOException iOException) {
            Deploy.trace("EJBDeploy: setupWorkingDir(): Exception during directory creation", iOException);
            throw new EJBDeployException("DP_WORKING_DIR_WRITE", string);
        }
        this.setWorkingDir(string);
    }

    private static void trace(String string) {
        System.err.println(string);
    }

    private static void trace(String string, Throwable throwable) {
        System.err.println(string);
        throwable.printStackTrace();
    }

    protected String processOSPath(String string) {
        String string2 = System.getProperty("os.name");
        if (string2 != null && string2.startsWith("Windows")) {
            return "\"" + string + "\"";
        }
        return string;
    }
}

